/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util;

import com.quorum.tessera.config.util.EnvironmentVariableProvider;
import com.quorum.tessera.io.SystemAdapter;
import com.quorum.tessera.passwords.PasswordReaderFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigSecretReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigSecretReader.class);

    private ConfigSecretReader() {
    }

    public static Optional<char[]> readSecretFromFile() {
        Path secretPath;
        EnvironmentVariableProvider envProvider = new EnvironmentVariableProvider();
        if (envProvider.hasEnv("TESSERA_CONFIG_SECRET") && Files.exists(secretPath = Paths.get(envProvider.getEnv("TESSERA_CONFIG_SECRET"), new String[0]), new LinkOption[0])) {
            try {
                return Optional.of(new String(Files.readAllBytes(secretPath)).trim().toCharArray());
            }
            catch (IOException ex) {
                LOGGER.error("Error while reading secret from file");
            }
        }
        LOGGER.warn("Not able to find or read any secret for decrypting sensitive values in config.");
        return Optional.empty();
    }

    public static char[] readSecretFromConsole() {
        SystemAdapter.INSTANCE.out().println("Please enter the secret/password used to decrypt config value");
        return PasswordReaderFactory.create().readPasswordFromConsole();
    }
}

