/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util;

import com.quorum.tessera.config.util.ConfigSecretReader;
import org.jasypt.encryption.pbe.PBEStringCleanablePasswordEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedStringResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedStringResolver.class);
    private final PBEStringCleanablePasswordEncryptor encryptor = new StandardPBEStringEncryptor();
    private boolean isPasswordSet;

    public String resolve(String textToDecrypt) {
        if (PropertyValueEncryptionUtils.isEncryptedValue(textToDecrypt)) {
            if (!this.isPasswordSet) {
                this.encryptor.setPasswordCharArray(ConfigSecretReader.readSecretFromFile().orElseGet(ConfigSecretReader::readSecretFromConsole));
                this.isPasswordSet = true;
            }
            return PropertyValueEncryptionUtils.decrypt(textToDecrypt, this.encryptor);
        }
        LOGGER.warn("Some sensitive values are being given as unencrypted plain text in config. Please note this is NOT recommended for production environment.");
        return textToDecrypt;
    }
}

