/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.config.util;

import com.quorum.tessera.config.ConfigException;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface XmlProcessingCallback<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(XmlProcessingCallback.class);

    public T doExecute() throws IOException, JAXBException, TransformerException;

    public static <T> T execute(XmlProcessingCallback<T> callback) {
        try {
            return callback.doExecute();
        }
        catch (IOException | JAXBException | TransformerException ex) {
            LOGGER.error(null, ex);
            throw new ConfigException(ex);
        }
    }
}

