/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.encryption;

import com.quorum.tessera.ServiceLoaderUtil;
import com.quorum.tessera.encryption.Encryptor;
import com.quorum.tessera.encryption.EncryptorFactoryNotFoundException;
import java.util.Collections;
import java.util.Map;

public interface EncryptorFactory {
    default public Encryptor create() {
        return this.create(Collections.emptyMap());
    }

    public Encryptor create(Map<String, String> var1);

    public String getType();

    public static EncryptorFactory newFactory(String type) {
        return ServiceLoaderUtil.loadAll(EncryptorFactory.class).filter(f -> f.getType().equals(type)).findAny().orElseThrow(() -> new EncryptorFactoryNotFoundException(type));
    }
}

