/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.encryption;

import com.quorum.tessera.encryption.KeyManager;
import com.quorum.tessera.encryption.KeyNotFoundException;
import com.quorum.tessera.encryption.KeyPair;
import com.quorum.tessera.encryption.PrivateKey;
import com.quorum.tessera.encryption.PublicKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyManagerImpl.class);
    private final Set<KeyPair> localKeys;
    private final KeyPair defaultKeys;
    private final Set<PublicKey> forwardingPublicKeys;

    public KeyManagerImpl(Collection<KeyPair> keys, Collection<PublicKey> forwardKeys) {
        this.localKeys = new HashSet<KeyPair>(keys);
        this.defaultKeys = this.localKeys.iterator().next();
        this.forwardingPublicKeys = new HashSet<PublicKey>(forwardKeys);
    }

    @Override
    public PublicKey getPublicKeyForPrivateKey(PrivateKey privateKey) {
        LOGGER.debug("Attempting to find public key for the private key {}", (Object)privateKey);
        PublicKey publicKey = this.localKeys.stream().filter(keypair -> Objects.equals(keypair.getPrivateKey(), privateKey)).findFirst().map(KeyPair::getPublicKey).orElseThrow(() -> new KeyNotFoundException("Private key " + privateKey.encodeToBase64() + " not found when searching for public key"));
        LOGGER.debug("Found public key {} for private key {}", (Object)publicKey, (Object)privateKey);
        return publicKey;
    }

    @Override
    public PrivateKey getPrivateKeyForPublicKey(PublicKey publicKey) {
        LOGGER.debug("Attempting to find private key for the public key {}", (Object)publicKey);
        PrivateKey privateKey = this.localKeys.stream().filter(keypair -> Objects.equals(keypair.getPublicKey(), publicKey)).findFirst().map(KeyPair::getPrivateKey).orElseThrow(() -> new KeyNotFoundException("Public key " + publicKey.encodeToBase64() + " not found when searching for private key"));
        LOGGER.debug("Found private key {} for public key {}", (Object)privateKey, (Object)publicKey);
        return privateKey;
    }

    @Override
    public Set<PublicKey> getPublicKeys() {
        return this.localKeys.stream().map(KeyPair::getPublicKey).collect(Collectors.toSet());
    }

    @Override
    public PublicKey defaultPublicKey() {
        return this.defaultKeys.getPublicKey();
    }

    @Override
    public Set<PublicKey> getForwardingKeys() {
        return this.forwardingPublicKeys;
    }
}

