/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface IOCallback<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IOCallback.class);

    public T doExecute() throws IOException;

    public static <T> T execute(IOCallback<T> callback) {
        try {
            return callback.doExecute();
        }
        catch (IOException ex) {
            LOGGER.debug(null, ex);
            throw new UncheckedIOException(ex);
        }
    }
}

