/*
 * Decompiled with CFR 0.152.
 */
package com.quorum.tessera.service;

import com.quorum.tessera.service.Service;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContainer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceContainer.class);
    private final Service service;
    private final ScheduledExecutorService executorService;
    private final long initialDelay;
    private final long period;

    public ServiceContainer(Service service) {
        this(service, Executors.newScheduledThreadPool(1), 1000L, 1000L);
    }

    public ServiceContainer(Service service, ScheduledExecutorService executorService, long initialDelay, long period) {
        this.service = service;
        this.executorService = executorService;
        this.initialDelay = initialDelay;
        this.period = period;
    }

    @PostConstruct
    public void start() {
        this.executorService.scheduleAtFixedRate(this, this.initialDelay, this.period, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.executorService.shutdown();
        this.service.stop();
    }

    @Override
    public void run() {
        LOGGER.trace("Check status {}", (Object)this.service);
        Service.Status status = this.service.status();
        LOGGER.trace("{} Status is {}", (Object)this.service, (Object)status);
        if (status == Service.Status.STOPPED) {
            LOGGER.warn("Service {} is stopped, attempting to start it.", (Object)this.service);
            try {
                LOGGER.debug("Starting service {}", (Object)this.service);
                this.service.start();
                LOGGER.debug("Started service {}", (Object)this.service);
            }
            catch (Throwable ex) {
                LOGGER.trace(null, ex);
                LOGGER.error("Exception thrown : {} While starting service {}", (Object)Optional.ofNullable(ex.getCause()).orElse(ex).getMessage(), (Object)this.service);
            }
        }
    }
}

