/*
 * Decompiled with CFR 0.152.
 */
package de.mkammerer.argon2;

import de.mkammerer.argon2.Argon2;

public final class Argon2Helper {
    private static final long MILLIS_IN_NANOS = 1000000L;
    private static final int WARMUP_RUNS = 10;
    private static final int MIN_ITERATIONS = 1;
    private static final int MIN_MEMORY = 8;
    private static final int MIN_PARALLELISM = 1;

    private Argon2Helper() {
    }

    public static int findIterations(Argon2 argon2, long maxMillisecs, int memory, int parallelism) {
        return Argon2Helper.findIterations(argon2, maxMillisecs, memory, parallelism, new NoopLogger());
    }

    public static int findIterations(Argon2 argon2, long maxMillisecs, int memory, int parallelism, IterationLogger logger2) {
        long took;
        char[] password = "password".toCharArray();
        Argon2Helper.warmup(argon2, password);
        int iterations = 0;
        do {
            long start = System.nanoTime() / 1000000L;
            argon2.hash(++iterations, memory, parallelism, password);
            long end = System.nanoTime() / 1000000L;
            took = end - start;
            logger2.log(iterations, took);
        } while (took <= maxMillisecs);
        return iterations - 1;
    }

    private static void warmup(Argon2 argon2, char[] password) {
        for (int i = 0; i < 10; ++i) {
            argon2.hash(1, 8, 1, password);
        }
    }

    public static class NoopLogger
    implements IterationLogger {
        @Override
        public void log(int iterations, long millisecs) {
        }
    }

    public static interface IterationLogger {
        public void log(int var1, long var2);
    }
}

