/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.EnumSet;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorDescriptor;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

class ClassBasedValidatorDescriptor<A extends Annotation>
implements ConstraintValidatorDescriptor<A> {
    private static final long serialVersionUID = -8207687559460098548L;
    private static final Log LOG = LoggerFactory.make();
    private final Class<? extends ConstraintValidator<A, ?>> validatorClass;
    private final Type validatedType;
    private final EnumSet<ValidationTarget> validationTargets;

    public ClassBasedValidatorDescriptor(Class<? extends ConstraintValidator<A, ?>> validatorClass) {
        this.validatorClass = validatorClass;
        this.validatedType = TypeHelper.extractType(validatorClass);
        this.validationTargets = ClassBasedValidatorDescriptor.determineValidationTargets(validatorClass);
    }

    private static EnumSet<ValidationTarget> determineValidationTargets(Class<? extends ConstraintValidator<?, ?>> validatorClass) {
        SupportedValidationTarget supportedTargetAnnotation = validatorClass.getAnnotation(SupportedValidationTarget.class);
        if (supportedTargetAnnotation == null) {
            return EnumSet.of(ValidationTarget.ANNOTATED_ELEMENT);
        }
        return EnumSet.copyOf(Arrays.asList(supportedTargetAnnotation.value()));
    }

    @Override
    public Class<? extends ConstraintValidator<A, ?>> getValidatorClass() {
        return this.validatorClass;
    }

    @Override
    public ConstraintValidator<A, ?> newInstance(ConstraintValidatorFactory constraintFactory) {
        ConstraintValidator<A, ?> constraintValidator = constraintFactory.getInstance(this.validatorClass);
        if (constraintValidator == null) {
            throw LOG.getConstraintFactoryMustNotReturnNullException(this.validatorClass);
        }
        return constraintValidator;
    }

    @Override
    public Type getValidatedType() {
        return this.validatedType;
    }

    @Override
    public EnumSet<ValidationTarget> getValidationTargets() {
        return this.validationTargets;
    }
}

