package net.contextfw.web.application.elements.enhanced;

import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.dom.DOMBuilder;
import net.contextfw.web.application.elements.CSimpleElement;
import net.contextfw.web.application.internal.enhanced.EnhancedElementBuilder;

import com.google.inject.Inject;

public abstract class EnhancedSimpleElement implements CSimpleElement {

    private EnhancedElementBuilder builder;
    
    @Override
    public void build(DOMBuilder superBuilder) {
        try {
            DOMBuilder b = superBuilder.descend(builder.getActualClass(this).getSimpleName());
            builder.build(b, this);
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }

    @Inject
    public void setBuilder(EnhancedElementBuilder builder) {
        this.builder = builder;
    }
}