/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi;

import com.google.common.net.HostAndPort;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.ArtemisTcpTransportKt;
import net.corda.nodeapi.ConnectionDirection;
import net.corda.nodeapi.config.SSLConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/nodeapi/ArtemisTcpTransport;", "", "()V", "Companion", "node-api_main"})
public final class ArtemisTcpTransport {
    @NotNull
    public static final String VERIFY_PEER_LEGAL_NAME = "corda.verifyPeerCommonName";
    private static final List<String> CIPHER_SUITES;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        CIPHER_SUITES = CollectionsKt.listOf((Object[])new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256"});
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/corda/nodeapi/ArtemisTcpTransport$Companion;", "", "()V", "CIPHER_SUITES", "", "", "getCIPHER_SUITES", "()Ljava/util/List;", "VERIFY_PEER_LEGAL_NAME", "tcpTransport", "Lorg/apache/activemq/artemis/api/core/TransportConfiguration;", "direction", "Lnet/corda/nodeapi/ConnectionDirection;", "hostAndPort", "Lcom/google/common/net/HostAndPort;", "config", "Lnet/corda/nodeapi/config/SSLConfiguration;", "enableSSL", "", "node-api_main"})
    public static final class Companion {
        private final List<String> getCIPHER_SUITES() {
            return CIPHER_SUITES;
        }

        @NotNull
        public final TransportConfiguration tcpTransport(@NotNull ConnectionDirection direction, @NotNull HostAndPort hostAndPort, @Nullable SSLConfiguration config, boolean enableSSL) {
            String string;
            ConnectionDirection connectionDirection;
            Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Map options = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"host", (Object)hostAndPort.getHost()), TuplesKt.to((Object)"port", (Object)hostAndPort.getPort()), TuplesKt.to((Object)"protocols", (Object)"CORE,AMQP")});
            if (config != null && enableSSL) {
                ArtemisTcpTransportKt.expectedOnDefaultFileSystem(config.getSslKeystore());
                ArtemisTcpTransportKt.expectedOnDefaultFileSystem(config.getTrustStoreFile());
                Pair[] pairArray = new Pair[11];
                pairArray[0] = TuplesKt.to((Object)"sslEnabled", (Object)true);
                pairArray[1] = TuplesKt.to((Object)"keyStoreProvider", (Object)"JKS");
                pairArray[2] = TuplesKt.to((Object)"keyStorePath", (Object)config.getSslKeystore());
                pairArray[3] = TuplesKt.to((Object)"keyStorePassword", (Object)config.getKeyStorePassword());
                pairArray[4] = TuplesKt.to((Object)"trustStoreProvider", (Object)"JKS");
                pairArray[5] = TuplesKt.to((Object)"trustStorePath", (Object)config.getTrustStoreFile());
                pairArray[6] = TuplesKt.to((Object)"trustStorePassword", (Object)config.getTrustStorePassword());
                pairArray[7] = TuplesKt.to((Object)"enabledCipherSuites", (Object)CollectionsKt.joinToString$default((Iterable)this.getCIPHER_SUITES(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                pairArray[8] = TuplesKt.to((Object)"enabledProtocols", (Object)"TLSv1.2");
                pairArray[9] = TuplesKt.to((Object)"needClientAuth", (Object)true);
                ConnectionDirection connectionDirection2 = direction;
                if (!(connectionDirection2 instanceof ConnectionDirection.Outbound)) {
                    connectionDirection2 = null;
                }
                ConnectionDirection.Outbound outbound = (ConnectionDirection.Outbound)connectionDirection2;
                pairArray[10] = TuplesKt.to((Object)ArtemisTcpTransport.VERIFY_PEER_LEGAL_NAME, (Object)(outbound != null ? outbound.getExpectedCommonName() : null));
                Map tlsOptions = MapsKt.mapOf((Pair[])pairArray);
                options.putAll(tlsOptions);
            }
            if ((connectionDirection = direction) instanceof ConnectionDirection.Inbound) {
                string = ((ConnectionDirection.Inbound)direction).getAcceptorFactoryClassName();
            } else if (connectionDirection instanceof ConnectionDirection.Outbound) {
                string = ((ConnectionDirection.Outbound)direction).getConnectorFactoryClassName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String factoryName = string;
            return new TransportConfiguration(factoryName, options);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration tcpTransport$default(Companion companion, ConnectionDirection connectionDirection, HostAndPort hostAndPort, SSLConfiguration sSLConfiguration, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.tcpTransport(connectionDirection, hostAndPort, sSLConfiguration, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

