/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.EncodingUtils;
import net.corda.core.messaging.MessageRecipientGroup;
import net.corda.core.messaging.MessageRecipients;
import net.corda.core.messaging.SingleMessageRecipient;
import net.corda.core.node.NodeInfo;
import net.corda.core.node.ServiceEntry;
import net.corda.core.node.services.ServiceType;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SingletonSerializeAsToken;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.config.SSLConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u000f2\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent;", "Lnet/corda/core/serialization/SingletonSerializeAsToken;", "()V", "config", "Lnet/corda/nodeapi/config/SSLConfiguration;", "getConfig", "()Lnet/corda/nodeapi/config/SSLConfiguration;", "checkStorePasswords", "", "getArtemisPeerAddress", "Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisPeerAddress;", "nodeInfo", "Lnet/corda/core/node/NodeInfo;", "ArtemisAddress", "ArtemisPeerAddress", "Companion", "NetworkMapAddress", "NodeAddress", "ServiceAddress", "node-api_main"})
public abstract class ArtemisMessagingComponent
extends SingletonSerializeAsToken {
    @NotNull
    public static final String NODE_USER = "SystemUsers/Node";
    @NotNull
    public static final String PEER_USER = "SystemUsers/Peer";
    @NotNull
    public static final String INTERNAL_PREFIX = "internal.";
    @NotNull
    public static final String PEERS_PREFIX = "internal.peers.";
    @NotNull
    public static final String SERVICES_PREFIX = "internal.services.";
    @NotNull
    public static final String IP_REQUEST_PREFIX = "ip.";
    @NotNull
    public static final String P2P_QUEUE = "p2p.inbound";
    @NotNull
    public static final String NOTIFICATIONS_ADDRESS = "internal.activemq.notifications";
    @NotNull
    public static final String NETWORK_MAP_QUEUE = "internal.networkmap";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract SSLConfiguration getConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void checkStorePasswords() {
        Object object;
        Closeable closeable;
        Path path;
        SSLConfiguration sSLConfiguration = this.getConfig();
        if (sSLConfiguration == null) {
            return;
        }
        SSLConfiguration config = sSLConfiguration;
        Path[] elements$iv = new Path[]{config.getSslKeystore(), config.getNodeKeystore()};
        Object $receiver$iv = elements$iv;
        for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
            void $receiver$iv2;
            Path it;
            Object element$iv = $receiver$iv[i];
            path = it = (Path)element$iv;
            OpenOption[] options$iv = new OpenOption[]{};
            closeable = Files.newInputStream((Path)$receiver$iv2, Arrays.copyOf(options$iv, options$iv.length));
            boolean bl = false;
            try {
                char[] cArray;
                InputStream it2 = (InputStream)closeable;
                String string = config.getKeyStorePassword();
                InputStream inputStream = it2;
                KeyStore keyStore = KeyStore.getInstance("JKS");
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
                keyStore.load(inputStream, cArray);
                object = Unit.INSTANCE;
                continue;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        $receiver$iv = config.getTrustStoreFile();
        OpenOption[] options$iv = new OpenOption[]{};
        Closeable closeable4 = Files.newInputStream((Path)$receiver$iv, Arrays.copyOf(options$iv, options$iv.length));
        boolean bl = false;
        try {
            InputStream it = (InputStream)closeable4;
            String string = config.getTrustStorePassword();
            closeable = it;
            KeyStore keyStore = KeyStore.getInstance("JKS");
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string3.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            object = cArray;
            keyStore.load((InputStream)closeable, (char[])object);
            path = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable5 = closeable4;
                if (closeable5 != null) {
                    closeable5.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable6 = closeable4;
                if (closeable6 != null) {
                    closeable6.close();
                }
            }
        }
    }

    @NotNull
    public final ArtemisPeerAddress getArtemisPeerAddress(@NotNull NodeInfo nodeInfo) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)nodeInfo, (String)"nodeInfo");
            Iterable $receiver$iv = nodeInfo.getAdvertisedServices();
            for (Object element$iv : $receiver$iv) {
                ServiceEntry it = (ServiceEntry)element$iv;
                if (!Intrinsics.areEqual((Object)it.getInfo().getType(), (Object)ServiceType.Companion.getNetworkMap())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl ? (ArtemisPeerAddress)new NetworkMapAddress((NetworkHostAndPort)CollectionsKt.first((List)nodeInfo.getAddresses())) : (ArtemisPeerAddress)NodeAddress.Companion.asPeer(nodeInfo.getLegalIdentity().getOwningKey(), (NetworkHostAndPort)CollectionsKt.first((List)nodeInfo.getAddresses()));
    }

    static {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/MessageRecipients;", "queueName", "", "getQueueName", "()Ljava/lang/String;", "node-api_main"})
    public static interface ArtemisAddress
    extends MessageRecipients {
        @NotNull
        public String getQueueName();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u00012\u00020\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisPeerAddress;", "Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/SingleMessageRecipient;", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "getHostAndPort", "()Lnet/corda/core/utilities/NetworkHostAndPort;", "node-api_main"})
    public static interface ArtemisPeerAddress
    extends ArtemisAddress,
    SingleMessageRecipient {
        @NotNull
        public NetworkHostAndPort getHostAndPort();
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$NetworkMapAddress;", "Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisPeerAddress;", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "(Lnet/corda/core/utilities/NetworkHostAndPort;)V", "getHostAndPort", "()Lnet/corda/core/utilities/NetworkHostAndPort;", "queueName", "", "getQueueName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "node-api_main"})
    public static final class NetworkMapAddress
    implements ArtemisPeerAddress {
        @NotNull
        private final NetworkHostAndPort hostAndPort;

        @Override
        @NotNull
        public String getQueueName() {
            return ArtemisMessagingComponent.NETWORK_MAP_QUEUE;
        }

        @Override
        @NotNull
        public NetworkHostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        public NetworkMapAddress(@NotNull NetworkHostAndPort hostAndPort) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            this.hostAndPort = hostAndPort;
        }

        @NotNull
        public final NetworkHostAndPort component1() {
            return this.getHostAndPort();
        }

        @NotNull
        public final NetworkMapAddress copy(@NotNull NetworkHostAndPort hostAndPort) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            return new NetworkMapAddress(hostAndPort);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NetworkMapAddress copy$default(NetworkMapAddress networkMapAddress, NetworkHostAndPort networkHostAndPort, int n, Object object) {
            if ((n & 1) != 0) {
                networkHostAndPort = networkMapAddress.getHostAndPort();
            }
            return networkMapAddress.copy(networkHostAndPort);
        }

        public String toString() {
            return "NetworkMapAddress(hostAndPort=" + this.getHostAndPort() + ")";
        }

        public int hashCode() {
            NetworkHostAndPort networkHostAndPort = this.getHostAndPort();
            return networkHostAndPort != null ? networkHostAndPort.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NetworkMapAddress)) break block3;
                    NetworkMapAddress networkMapAddress = (NetworkMapAddress)object;
                    if (!Intrinsics.areEqual((Object)this.getHostAndPort(), (Object)networkMapAddress.getHostAndPort())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$NodeAddress;", "Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisPeerAddress;", "queueName", "", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "(Ljava/lang/String;Lnet/corda/core/utilities/NetworkHostAndPort;)V", "getHostAndPort", "()Lnet/corda/core/utilities/NetworkHostAndPort;", "getQueueName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "node-api_main"})
    public static final class NodeAddress
    implements ArtemisPeerAddress {
        @NotNull
        private final String queueName;
        @NotNull
        private final NetworkHostAndPort hostAndPort;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getQueueName() {
            return this.queueName;
        }

        @Override
        @NotNull
        public NetworkHostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        public NodeAddress(@NotNull String queueName, @NotNull NetworkHostAndPort hostAndPort) {
            Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            this.queueName = queueName;
            this.hostAndPort = hostAndPort;
        }

        @NotNull
        public final String component1() {
            return this.getQueueName();
        }

        @NotNull
        public final NetworkHostAndPort component2() {
            return this.getHostAndPort();
        }

        @NotNull
        public final NodeAddress copy(@NotNull String queueName, @NotNull NetworkHostAndPort hostAndPort) {
            Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            return new NodeAddress(queueName, hostAndPort);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NodeAddress copy$default(NodeAddress nodeAddress, String string, NetworkHostAndPort networkHostAndPort, int n, Object object) {
            if ((n & 1) != 0) {
                string = nodeAddress.getQueueName();
            }
            if ((n & 2) != 0) {
                networkHostAndPort = nodeAddress.getHostAndPort();
            }
            return nodeAddress.copy(string, networkHostAndPort);
        }

        public String toString() {
            return "NodeAddress(queueName=" + this.getQueueName() + ", hostAndPort=" + this.getHostAndPort() + ")";
        }

        public int hashCode() {
            String string = this.getQueueName();
            NetworkHostAndPort networkHostAndPort = this.getHostAndPort();
            return (string != null ? string.hashCode() : 0) * 31 + (networkHostAndPort != null ? networkHostAndPort.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NodeAddress)) break block3;
                    NodeAddress nodeAddress = (NodeAddress)object;
                    if (!Intrinsics.areEqual((Object)this.getQueueName(), (Object)nodeAddress.getQueueName()) || !Intrinsics.areEqual((Object)this.getHostAndPort(), (Object)nodeAddress.getHostAndPort())) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$NodeAddress$Companion;", "", "()V", "asPeer", "Lnet/corda/nodeapi/ArtemisMessagingComponent$NodeAddress;", "peerIdentity", "Ljava/security/PublicKey;", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "asService", "serviceIdentity", "node-api_main"})
        public static final class Companion {
            @NotNull
            public final NodeAddress asPeer(@NotNull PublicKey peerIdentity, @NotNull NetworkHostAndPort hostAndPort) {
                Intrinsics.checkParameterIsNotNull((Object)peerIdentity, (String)"peerIdentity");
                Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
                return new NodeAddress(ArtemisMessagingComponent.PEERS_PREFIX + EncodingUtils.toBase58String((PublicKey)peerIdentity), hostAndPort);
            }

            @NotNull
            public final NodeAddress asService(@NotNull PublicKey serviceIdentity, @NotNull NetworkHostAndPort hostAndPort) {
                Intrinsics.checkParameterIsNotNull((Object)serviceIdentity, (String)"serviceIdentity");
                Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
                return new NodeAddress(ArtemisMessagingComponent.SERVICES_PREFIX + EncodingUtils.toBase58String((PublicKey)serviceIdentity), hostAndPort);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$ServiceAddress;", "Lnet/corda/nodeapi/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/MessageRecipientGroup;", "identity", "Ljava/security/PublicKey;", "(Ljava/security/PublicKey;)V", "getIdentity", "()Ljava/security/PublicKey;", "queueName", "", "getQueueName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "node-api_main"})
    public static final class ServiceAddress
    implements ArtemisAddress,
    MessageRecipientGroup {
        @NotNull
        private final String queueName;
        @NotNull
        private final PublicKey identity;

        @Override
        @NotNull
        public String getQueueName() {
            return this.queueName;
        }

        @NotNull
        public final PublicKey getIdentity() {
            return this.identity;
        }

        public ServiceAddress(@NotNull PublicKey identity) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            this.identity = identity;
            this.queueName = ArtemisMessagingComponent.SERVICES_PREFIX + EncodingUtils.toBase58String((PublicKey)this.identity);
        }

        @NotNull
        public final PublicKey component1() {
            return this.identity;
        }

        @NotNull
        public final ServiceAddress copy(@NotNull PublicKey identity) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            return new ServiceAddress(identity);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ServiceAddress copy$default(ServiceAddress serviceAddress, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                publicKey = serviceAddress.identity;
            }
            return serviceAddress.copy(publicKey);
        }

        public String toString() {
            return "ServiceAddress(identity=" + this.identity + ")";
        }

        public int hashCode() {
            PublicKey publicKey = this.identity;
            return publicKey != null ? publicKey.hashCode() : 0;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ServiceAddress)) break block3;
                    ServiceAddress serviceAddress = (ServiceAddress)object;
                    if (!Intrinsics.areEqual((Object)this.identity, (Object)serviceAddress.identity)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/corda/nodeapi/ArtemisMessagingComponent$Companion;", "", "()V", "INTERNAL_PREFIX", "", "IP_REQUEST_PREFIX", "NETWORK_MAP_QUEUE", "NODE_USER", "NOTIFICATIONS_ADDRESS", "P2P_QUEUE", "PEERS_PREFIX", "PEER_USER", "SERVICES_PREFIX", "node-api_main"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

