/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.serialization;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.nodeapi.serialization.NotSupportedSeralizationScheme;
import net.corda.nodeapi.serialization.SerializationScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0011H\u0002J-\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00130&\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010'\u001a\u0002H\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lnet/corda/nodeapi/serialization/SerializationFactoryImpl;", "Lnet/corda/core/serialization/SerializationFactory;", "()V", "alreadyRegisteredSchemes", "", "Lnet/corda/nodeapi/serialization/SerializationScheme;", "getAlreadyRegisteredSchemes", "()Ljava/util/Collection;", "creator", "", "Ljava/lang/StackTraceElement;", "registeredSchemes", "", "schemes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "Lnet/corda/core/utilities/ByteSequence;", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "deserialize", "T", "", "byteSequence", "clazz", "Ljava/lang/Class;", "context", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "registerScheme", "", "scheme", "schemeFor", "target", "serialize", "Lnet/corda/core/serialization/SerializedBytes;", "obj", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "toString", "", "node-api_main"})
public class SerializationFactoryImpl
implements SerializationFactory {
    private final List<StackTraceElement> creator = ArraysKt.asList((Object[])new Exception().getStackTrace());
    private final Collection<SerializationScheme> registeredSchemes;
    private final ConcurrentHashMap<Pair<ByteSequence, SerializationContext.UseCase>, SerializationScheme> schemes;

    private final SerializationScheme schemeFor(ByteSequence byteSequence, SerializationContext.UseCase target) {
        SerializationScheme serializationScheme = this.schemes.computeIfAbsent((Pair<ByteSequence, SerializationContext.UseCase>)TuplesKt.to((Object)byteSequence.take(8).copy(), (Object)target), (Function<Pair<ByteSequence, SerializationContext.UseCase>, SerializationScheme>)new Function<Pair<? extends ByteSequence, ? extends SerializationContext.UseCase>, SerializationScheme>(this){
            final /* synthetic */ SerializationFactoryImpl this$0;

            @NotNull
            public final SerializationScheme apply(@NotNull Pair<? extends ByteSequence, ? extends SerializationContext.UseCase> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                for (SerializationScheme scheme : SerializationFactoryImpl.access$getRegisteredSchemes$p(this.this$0)) {
                    if (!scheme.canDeserializeVersion((ByteSequence)it.getFirst(), (SerializationContext.UseCase)it.getSecond())) continue;
                    return scheme;
                }
                return NotSupportedSeralizationScheme.INSTANCE;
            }
            {
                this.this$0 = serializationFactoryImpl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)serializationScheme, (String)"schemes.computeIfAbsent(\u2026alizationScheme\n        }");
        return serializationScheme;
    }

    @NotNull
    public <T> T deserialize(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.schemeFor(byteSequence, context.getUseCase()).deserialize(byteSequence, clazz, context);
    }

    @NotNull
    public <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return this.schemeFor(context.getPreferedSerializationVersion(), context.getUseCase()).serialize(obj, context);
    }

    public final void registerScheme(@NotNull SerializationScheme scheme) {
        Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
        boolean bl = this.schemes.isEmpty();
        if (!bl) {
            String string = "All serialization schemes must be registered before any scheme is used.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Collection<SerializationScheme> collection = this.registeredSchemes;
        collection.add(scheme);
    }

    @NotNull
    public final Collection<SerializationScheme> getAlreadyRegisteredSchemes() {
        Collection<SerializationScheme> collection = Collections.unmodifiableCollection(this.registeredSchemes);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"Collections.unmodifiable\u2026ection(registeredSchemes)");
        return collection;
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + " registeredSchemes=" + this.registeredSchemes + " " + CollectionsKt.joinToString$default((Iterable)this.creator, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof SerializationFactoryImpl && Intrinsics.areEqual(((SerializationFactoryImpl)other).registeredSchemes, this.registeredSchemes);
    }

    public int hashCode() {
        return ((Object)this.registeredSchemes).hashCode();
    }

    public SerializationFactoryImpl() {
        SerializationFactoryImpl serializationFactoryImpl = this;
        List list = new ArrayList();
        Collection collection = Collections.synchronizedCollection(list);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"Collections.synchronized\u2026llection(mutableListOf())");
        serializationFactoryImpl.registeredSchemes = collection;
        this.schemes = new ConcurrentHashMap();
    }

    @NotNull
    public static final /* synthetic */ Collection access$getRegisteredSchemes$p(SerializationFactoryImpl $this) {
        return $this.registeredSchemes;
    }
}

