/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigUtil;
import com.typesafe.config.ConfigValue;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KTypesJvm;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.internal.InternalUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.config.OldConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a3\u0010\u0003\u001a\u0002H\u0004\"\u000e\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a \u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0003\u001a\u0018\u0010\r\u001a\u00020\t*\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002\u001a\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0013*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a,\u0010\u0018\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u0004*\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00132\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0086\u0002\u00a2\u0006\u0002\u0010\u001b\u001a'\u0010\u001c\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u0004*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0003\u00a2\u0006\u0002\u0010\u001d\u001a\u001e\u0010\u001e\u001a\u0002H\u0004\"\n\b\u0000\u0010\u0004\u0018\u0001*\u00020\u0013*\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u001f\u001a'\u0010\u001e\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u0013*\u00020\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040 \u00a2\u0006\u0002\u0010!\u001a\n\u0010\"\u001a\u00020#*\u00020\u000e\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enumBridge", "T", "", "clazz", "Ljava/lang/Class;", "name", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", "parseEnum", "enumType", "defaultToOldPath", "Lcom/typesafe/config/Config;", "property", "Lkotlin/reflect/KProperty;", "getCollectionValue", "", "", "path", "type", "Lkotlin/reflect/KType;", "getSingleValue", "getValue", "receiver", "metadata", "(Lcom/typesafe/config/Config;Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "getValueInternal", "(Lcom/typesafe/config/Config;Ljava/lang/String;Lkotlin/reflect/KType;)Ljava/lang/Object;", "parseAs", "(Lcom/typesafe/config/Config;)Ljava/lang/Object;", "Lkotlin/reflect/KClass;", "(Lcom/typesafe/config/Config;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "toProperties", "Ljava/util/Properties;", "node-api_main"})
@JvmName(name="ConfigUtilities")
public final class ConfigUtilities {
    private static final Logger logger = LoggerFactory.getLogger((String)"net.corda.nodeapi.config");

    public static final <T> T getValue(@NotNull Config $receiver, @NotNull Object receiver, @NotNull KProperty<?> metadata) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
        return ConfigUtilities.getValueInternal($receiver, metadata.getName(), metadata.getReturnType());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final <T> T parseAs(@NotNull Config $receiver, @NotNull KClass<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        var2_2 = clazz.isData();
        if (!var2_2) {
            var4_4 = "Only Kotlin data classes can be parsed";
            throw (Throwable)new IllegalArgumentException(var4_4.toString());
        }
        v0 = KClasses.getPrimaryConstructor(clazz);
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        constructor = v0;
        var4_5 = constructor.getParameters();
        var5_6 = $receiver$iv;
        destination$iv$iv /* !! */  = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (KParameter)element$iv$iv;
            if (!it.isOptional()) ** GOTO lbl-1000
            v1 = it.getName();
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            if (!$receiver.hasPath(v1)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (v2) continue;
            destination$iv$iv /* !! */ .add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv /* !! */ ;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv /* !! */  = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (T element$iv$iv : $receiver$iv$iv) {
            block8: {
                $i$a$1$filterNot = (KParameter)element$iv$iv;
                var21_18 = destination$iv$iv;
                var22_19 = it;
                it = (KParameter)element$iv$iv;
                $receiver$iv = KClasses.getMemberProperties(clazz);
                for (T element$iv : $receiver$iv) {
                    it = (KProperty1)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)param.getName())) continue;
                    break block8;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            property = (KProperty1)element$iv;
            path = ConfigUtilities.defaultToOldPath($receiver, (KProperty)property);
            var23_20 = ConfigUtilities.getValueInternal($receiver, path, param.getType());
            var21_18.put(var22_19, var23_20);
        }
        args = destination$iv$iv;
        return (T)constructor.callBy(args);
    }

    private static final <T> T parseAs(@NotNull Config $receiver) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return ConfigUtilities.parseAs($receiver, Reflection.getOrCreateKotlinClass(Object.class));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Properties toProperties(@NotNull Config $receiver) {
        void var2_2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable iterable = $receiver.entrySet();
        Map destination$iv = new Properties();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it;
            Map.Entry entry = (Map.Entry)element$iv;
            Map map = destination$iv;
            String string = CollectionsKt.joinToString$default((Iterable)ConfigUtil.splitPath((String)((String)it.getKey())), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            it = (Map.Entry)element$iv;
            String string2 = ((ConfigValue)it.getValue()).unwrapped().toString();
            map.put(string, string2);
        }
        return (Properties)var2_2;
    }

    private static final <T> T getValueInternal(@NotNull Config $receiver, String path, KType type) {
        return (T)(type.getArguments().isEmpty() ? ConfigUtilities.getSingleValue($receiver, path, type) : ConfigUtilities.getCollectionValue($receiver, path, type));
    }

    private static final Object getSingleValue(@NotNull Config $receiver, String path, KType type) {
        Enum<?> enum_;
        if (type.isMarkedNullable() && !$receiver.hasPath(path)) {
            return null;
        }
        KClass typeClass = KTypesJvm.getJvmErasure((KType)type);
        KClass kClass = typeClass;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            enum_ = $receiver.getString(path);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            enum_ = $receiver.getInt(path);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            enum_ = $receiver.getLong(path);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            enum_ = $receiver.getDouble(path);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            enum_ = $receiver.getBoolean(path);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            enum_ = LocalDate.parse($receiver.getString(path));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            enum_ = Instant.parse($receiver.getString(path));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(NetworkHostAndPort.class))) {
            String string = $receiver.getString(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getString(path)");
            enum_ = NetworkHostAndPort.Companion.parse(string);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Path.class))) {
            enum_ = Paths.get($receiver.getString(path), new String[0]);
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(URL.class))) {
            enum_ = new URL($receiver.getString(path));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Properties.class))) {
            enum_ = ConfigUtilities.toProperties($receiver.getConfig(path));
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(CordaX500Name.class))) {
            String string = $receiver.getString(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getString(path)");
            enum_ = CordaX500Name.Companion.parse(string);
        } else if (JvmClassMappingKt.getJavaClass((KClass)typeClass).isEnum()) {
            Class clazz = JvmClassMappingKt.getJavaClass((KClass)typeClass);
            String string = $receiver.getString(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getString(path)");
            enum_ = ConfigUtilities.parseEnum(clazz, string);
        } else {
            enum_ = ConfigUtilities.parseAs($receiver.getConfig(path), typeClass);
        }
        return enum_;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<Object> getCollectionValue(@NotNull Config $receiver, String path, KType type) {
        String it;
        void p1;
        Object item$iv$iv3;
        void $receiver$iv$iv;
        Object destination$iv$iv;
        Enum<?> enum_;
        CharSequence p12;
        Object object;
        Iterable $receiver$iv$iv2;
        Iterable destination$iv$iv2;
        Iterable $receiver$iv;
        List list;
        boolean bl;
        KClass typeClass = KTypesJvm.getJvmErasure((KType)type);
        boolean bl2 = bl = Intrinsics.areEqual((Object)typeClass, (Object)Reflection.getOrCreateKotlinClass(List.class)) || Intrinsics.areEqual((Object)typeClass, (Object)Reflection.getOrCreateKotlinClass(Set.class));
        if (!bl) {
            String string = "" + typeClass + " is not supported";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        KType kType = ((KTypeProjection)type.getArguments().get(0)).getType();
        if (kType == null || (kType = KTypesJvm.getJvmErasure((KType)kType)) == null) {
            throw (Throwable)new IllegalArgumentException("Cannot work with star projection: " + type);
        }
        KType elementClass = kType;
        if (!$receiver.hasPath(path)) {
            return Intrinsics.areEqual((Object)typeClass, (Object)Reflection.getOrCreateKotlinClass(List.class)) ? (Collection)CollectionsKt.emptyList() : (Collection)SetsKt.emptySet();
        }
        KType kType2 = elementClass;
        if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            List list2 = $receiver.getStringList(path);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"getStringList(path)");
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            List list3 = $receiver.getIntList(path);
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"getIntList(path)");
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            List list4 = $receiver.getLongList(path);
            list = list4;
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"getLongList(path)");
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            List list5 = $receiver.getDoubleList(path);
            list = list5;
            Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"getDoubleList(path)");
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            List list6 = $receiver.getBooleanList(path);
            list = list6;
            Intrinsics.checkExpressionValueIsNotNull((Object)list6, (String)"getBooleanList(path)");
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            Iterable iterable = $receiver$iv = (Iterable)$receiver.getStringList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                CharSequence charSequence = (CharSequence)item$iv$iv2;
                object = destination$iv$iv2;
                enum_ = LocalDate.parse(p12);
                object.add(enum_);
            }
            list = (List)destination$iv$iv2;
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)$receiver.getStringList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                p12 = (CharSequence)item$iv$iv2;
                object = destination$iv$iv2;
                enum_ = Instant.parse(p12);
                object.add((LocalDate)((Object)enum_));
            }
            list = (List)destination$iv$iv2;
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(NetworkHostAndPort.class))) {
            $receiver$iv = $receiver.getStringList(path);
            $receiver$iv$iv2 = NetworkHostAndPort.Companion;
            destination$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv3 : $receiver$iv$iv) {
                String $i$a$2$unknown = (String)item$iv$iv3;
                object = destination$iv$iv;
                enum_ = $receiver$iv$iv2.parse((String)p1);
                object.add(enum_);
            }
            list = (List)destination$iv$iv;
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Path.class))) {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)$receiver.getStringList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                item$iv$iv3 = (String)item$iv$iv2;
                object = destination$iv$iv2;
                enum_ = Paths.get(it, new String[0]);
                object.add(enum_);
            }
            list = (List)destination$iv$iv2;
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(URL.class))) {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)$receiver.getStringList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                it = (String)item$iv$iv2;
                object = destination$iv$iv2;
                enum_ = new URL((String)p12);
                object.add(enum_);
            }
            list = (List)destination$iv$iv2;
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(CordaX500Name.class))) {
            $receiver$iv = $receiver.getStringList(path);
            $receiver$iv$iv2 = CordaX500Name.Companion;
            destination$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv3 : $receiver$iv$iv) {
                String $i$a$5$unknown = (String)item$iv$iv3;
                object = destination$iv$iv;
                enum_ = $receiver$iv$iv2.parse((String)p1);
                object.add(enum_);
            }
            list = (List)destination$iv$iv;
        } else if (Intrinsics.areEqual((Object)kType2, (Object)Reflection.getOrCreateKotlinClass(Properties.class))) {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)$receiver.getConfigList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                item$iv$iv3 = (Config)item$iv$iv2;
                object = destination$iv$iv2;
                enum_ = ConfigUtilities.toProperties((Config)p12);
                object.add(enum_);
            }
            list = (List)destination$iv$iv2;
        } else if (JvmClassMappingKt.getJavaClass((KClass)elementClass).isEnum()) {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)$receiver.getStringList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                p12 = (String)item$iv$iv2;
                object = destination$iv$iv2;
                Class clazz = JvmClassMappingKt.getJavaClass((KClass)elementClass);
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                enum_ = ConfigUtilities.parseEnum(clazz, string);
                object.add(enum_);
            }
            list = (List)destination$iv$iv2;
        } else {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)$receiver.getConfigList(path);
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                it = (Config)item$iv$iv2;
                object = destination$iv$iv2;
                enum_ = ConfigUtilities.parseAs((Config)it, elementClass);
                object.add(enum_);
            }
            list = (List)destination$iv$iv2;
        }
        List values = list;
        return Intrinsics.areEqual((Object)typeClass, (Object)Reflection.getOrCreateKotlinClass(Set.class)) ? (Collection)CollectionsKt.toSet((Iterable)values) : (Collection)values;
    }

    /*
     * WARNING - void declaration
     */
    private static final String defaultToOldPath(@NotNull Config $receiver, KProperty<?> property) {
        if (!$receiver.hasPath(property.getName())) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)property.getAnnotations();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof OldConfig)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            OldConfig oldConfig = (OldConfig)InternalUtilsKt.noneOrSingle((List)((List)destination$iv$iv));
            if (oldConfig != null && $receiver.hasPath(oldConfig.value())) {
                logger.warn("Config key " + oldConfig.value() + " has been deprecated and will be removed in a future release. " + "Use " + property.getName() + " instead");
                return oldConfig.value();
            }
        }
        return property.getName();
    }

    private static final Enum<?> parseEnum(Class<?> enumType, String name) {
        Class<?> clazz = enumType;
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<java.net.Proxy.Type>");
        }
        return ConfigUtilities.enumBridge(clazz, name);
    }

    private static final <T extends Enum<T>> T enumBridge(Class<T> clazz, String name) {
        T t = Enum.valueOf(clazz, name);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"java.lang.Enum.valueOf(clazz, name)");
        return t;
    }
}

