/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.contracts.Attachment;
import net.corda.core.crypto.SecureHash;
import net.corda.core.serialization.CordaSerializable;
import net.corda.nodeapi.internal.AttachmentsClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\t\u0018\u00002\u00020\u0001:\u0001\u0019B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u000fH\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0016\u0010\u0017\u001a\u00020\u0014*\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0002R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/corda/nodeapi/internal/AttachmentsClassLoader;", "Ljava/security/SecureClassLoader;", "attachments", "", "Lnet/corda/core/contracts/Attachment;", "parent", "Ljava/lang/ClassLoader;", "(Ljava/util/List;Ljava/lang/ClassLoader;)V", "fakeStreamHandler", "net/corda/nodeapi/internal/AttachmentsClassLoader$fakeStreamHandler$1", "Lnet/corda/nodeapi/internal/AttachmentsClassLoader$fakeStreamHandler$1;", "idsToAttachments", "Ljava/util/HashMap;", "Lnet/corda/core/crypto/SecureHash;", "pathsToAttachments", "", "findClass", "Ljava/lang/Class;", "name", "findResource", "Ljava/net/URL;", "getResourceAsStream", "Ljava/io/InputStream;", "toURL", "path", "OverlappingAttachments", "node-api_main"})
public final class AttachmentsClassLoader
extends SecureClassLoader {
    private final HashMap<String, Attachment> pathsToAttachments;
    private final HashMap<SecureHash, Attachment> idsToAttachments;
    private final fakeStreamHandler.1 fakeStreamHandler;

    private final URL toURL(@NotNull Attachment $receiver, String path) {
        StringBuilder stringBuilder = new StringBuilder().append("attachment://").append($receiver.getId()).append('/');
        String string = path;
        if (string == null) {
            string = "";
        }
        return new URL(null, stringBuilder.append((Object)string).toString(), this.fakeStreamHandler);
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) {
        CodeSource codeSource;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null);
        Serializable serializable = new StringBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        Object object = string3;
        String path = serializable.append((String)object).append(".class").toString();
        Attachment attachment = this.pathsToAttachments.get(path);
        if (attachment == null) {
            throw (Throwable)new ClassNotFoundException(name);
        }
        Attachment attachment2 = attachment;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            attachment2.extractFile(path, (OutputStream)stream);
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new ClassNotFoundException(name);
        }
        byte[] bytes = stream.toByteArray();
        URL uRL = this.toURL(attachment2, null);
        object = codeSource;
        serializable = codeSource;
        CodeSigner[] codeSignerArray = new CodeSigner[]{};
        ((CodeSource)object)(uRL, codeSignerArray);
        Serializable codesource = serializable;
        Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, (CodeSource)codesource);
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"defineClass(name, bytes,\u2026, bytes.size, codesource)");
        return clazz;
    }

    @Override
    @Nullable
    protected URL findResource(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = name;
        HashMap<String, Attachment> hashMap = this.pathsToAttachments;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        Attachment attachment = hashMap.get(string3);
        if (attachment == null) {
            return null;
        }
        Attachment attachment2 = attachment;
        return this.toURL(attachment2, name);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name) {
        String string;
        Attachment attachment;
        block10: {
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                URL uRL = this.getResource(name);
                if (uRL == null) {
                    return null;
                }
                URL url = uRL;
                if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)"attachment") ^ true) {
                    return null;
                }
                String string2 = url.getHost();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.host");
                Attachment attachment2 = this.idsToAttachments.get(SecureHash.Companion.parse(string2));
                if (attachment2 == null) {
                    return null;
                }
                attachment = attachment2;
                string = url.getPath();
                if (string == null) break block9;
                String string3 = string;
                int n = 1;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                string = string5;
                if (string5 != null) break block10;
            }
            return null;
        }
        String path = string;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            attachment.extractFile(path, (OutputStream)stream);
            return new ByteArrayInputStream(stream.toByteArray());
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentsClassLoader(@NotNull List<? extends Attachment> attachments, @NotNull ClassLoader parent) {
        Intrinsics.checkParameterIsNotNull(attachments, (String)"attachments");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        super(parent);
        this.pathsToAttachments = new HashMap();
        this.idsToAttachments = new HashMap();
        for (Attachment attachment : attachments) {
            Closeable closeable;
            Unit unit;
            Object object = attachment.openAsJAR();
            boolean bl = false;
            try {
                JarInputStream jar = (JarInputStream)object;
                while (jar.getNextJarEntry() != null) {
                    Object object2;
                    JarEntry entry;
                    Object object3 = entry.getName();
                    String string = object3;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                    String path = StringsKt.replace$default((String)string2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                    Object object4 = object2 = (object3 = (Map)this.pathsToAttachments);
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                    }
                    if (object4.containsKey(path)) {
                        throw (Throwable)new OverlappingAttachments(path);
                    }
                    object3 = this.pathsToAttachments;
                    object2 = attachment;
                    object3.put(path, object2);
                }
                unit = Unit.INSTANCE;
                closeable = object;
            }
            catch (Exception exception) {
                try {
                    bl = true;
                    try {
                        Closeable closeable2 = object;
                        if (closeable2 != null) {
                            closeable2.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        Closeable closeable3 = object;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    throw throwable;
                }
            }
            if (closeable != null) {
                closeable.close();
            }
            object = this.idsToAttachments;
            SecureHash secureHash = attachment.getId();
            unit = attachment;
            object.put(secureHash, unit);
        }
        this.fakeStreamHandler = new URLStreamHandler(){

            @Nullable
            protected URLConnection openConnection(@Nullable URL u) {
                throw (Throwable)new UnsupportedOperationException();
            }
        };
    }

    public /* synthetic */ AttachmentsClassLoader(List list, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"ClassLoader.getSystemClassLoader()");
            classLoader = classLoader2;
        }
        this(list, classLoader);
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lnet/corda/nodeapi/internal/AttachmentsClassLoader$OverlappingAttachments;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "toString", "node-api_main"})
    public static final class OverlappingAttachments
    extends Exception {
        @NotNull
        private final String path;

        @Override
        @NotNull
        public String toString() {
            return "Multiple attachments define a file at path " + this.path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public OverlappingAttachments(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.path = path;
        }
    }
}

