/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.corda.core.serialization.CordaSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0000J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lnet/corda/nodeapi/internal/ServiceType;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "equals", "", "other", "getSubType", "subTypeId", "hashCode", "", "isNotary", "isSubTypeOf", "superType", "toString", "Companion", "node-api_main"})
public final class ServiceType {
    @NotNull
    private final String id;
    @NotNull
    private static final ServiceType notary;
    @NotNull
    private static final ServiceType networkMap;
    public static final Companion Companion;

    @NotNull
    public final ServiceType getSubType(@NotNull String subTypeId) {
        Intrinsics.checkParameterIsNotNull((Object)subTypeId, (String)"subTypeId");
        return ServiceType.Companion.baseWithSubType(this.id, subTypeId);
    }

    public final boolean isSubTypeOf(@NotNull ServiceType superType) {
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return Intrinsics.areEqual((Object)this.id, (Object)superType.id) || StringsKt.startsWith$default((String)this.id, (String)(superType.id + "."), (boolean)false, (int)2, null);
    }

    public final boolean isNotary() {
        return this.isSubTypeOf(Companion.getNotary());
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof ServiceType && Intrinsics.areEqual((Object)((ServiceType)other).id, (Object)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    private ServiceType(String id) {
        this.id = id;
        CharSequence charSequence = this.id;
        Regex regex = new Regex("[a-z][a-zA-Z0-9._]+");
        boolean bl = regex.matches(charSequence);
        if (!bl) {
            String string = this.id;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    static {
        Companion = new Companion(null);
        notary = Companion.getCorda().getSubType("notary");
        networkMap = Companion.getCorda().getSubType("network_map");
    }

    public /* synthetic */ ServiceType(@NotNull String id, DefaultConstructorMarker $constructor_marker) {
        this(id);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/ServiceType$Companion;", "", "()V", "corda", "Lnet/corda/nodeapi/internal/ServiceType;", "getCorda", "()Lnet/corda/nodeapi/internal/ServiceType;", "networkMap", "getNetworkMap", "notary", "getNotary", "baseWithSubType", "baseId", "", "subTypeId", "parse", "id", "node-api_main"})
    public static final class Companion {
        @NotNull
        public final ServiceType getCorda() {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            String caller = ((StackTraceElement)ArraysKt.first((Object[])stack)).getClassName();
            boolean bl = StringsKt.startsWith$default((String)caller, (String)"net.corda.", (boolean)false, (int)2, null);
            if (!bl) {
                String string = "Corda ServiceType namespace is reserved for Corda core components";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return new ServiceType("corda", null);
        }

        @NotNull
        public final ServiceType getNotary() {
            return notary;
        }

        @NotNull
        public final ServiceType getNetworkMap() {
            return networkMap;
        }

        @NotNull
        public final ServiceType parse(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new ServiceType(id, null);
        }

        private final ServiceType baseWithSubType(String baseId, String subTypeId) {
            return new ServiceType("" + baseId + '.' + subTypeId, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

