/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationDefaults;
import net.corda.core.utilities.ByteSequence;
import net.corda.nodeapi.internal.serialization.BuiltInExceptionsWhitelist;
import net.corda.nodeapi.internal.serialization.GlobalTransientClassWhiteList;
import net.corda.nodeapi.internal.serialization.MutableClassWhitelist;
import net.corda.nodeapi.internal.serialization.SerializationContextImpl;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a+\u0010\b\u001a\u00020\t*\u00020\n2\u001a\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\r0\f\"\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\u0002\u0010\u000e\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"AMQP_ENABLED", "", "getAMQP_ENABLED", "()Z", "AMQP_P2P_CONTEXT", "Lnet/corda/nodeapi/internal/serialization/SerializationContextImpl;", "getAMQP_P2P_CONTEXT", "()Lnet/corda/nodeapi/internal/serialization/SerializationContextImpl;", "addToWhitelist", "", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "types", "", "Ljava/lang/Class;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;[Ljava/lang/Class;)V", "node-api_main"})
@JvmName(name="AMQPSerializationScheme")
public final class AMQPSerializationScheme {
    @NotNull
    private static final SerializationContextImpl AMQP_P2P_CONTEXT;

    public static final boolean getAMQP_ENABLED() {
        return Intrinsics.areEqual((Object)SerializationDefaults.INSTANCE.getP2P_CONTEXT().getPreferredSerializationVersion(), (Object)SchemaKt.getAmqpHeaderV1_0());
    }

    public static final void addToWhitelist(@NotNull SerializerFactory $receiver, Class<?> ... types) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        boolean bl2 = bl = ArraysKt.toSet((Object[])types).size() == ((Object[])types).length;
        if (!bl) {
            List duplicates = ArraysKt.toMutableList((Object[])types);
            Iterable $receiver$iv = ArraysKt.toSet((Object[])types);
            for (Object element$iv : $receiver$iv) {
                Class it = (Class)element$iv;
                Collection collection = duplicates;
                collection.remove(it);
            }
            String string = "Cannot add duplicate classes to the whitelist (" + duplicates + ").";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            ClassWhitelist classWhitelist = $receiver.getWhitelist();
            if (!(classWhitelist instanceof MutableClassWhitelist)) {
                classWhitelist = null;
            }
            MutableClassWhitelist mutableClassWhitelist = (MutableClassWhitelist)classWhitelist;
            if (mutableClassWhitelist == null) continue;
            mutableClassWhitelist.add(type);
        }
    }

    @NotNull
    public static final SerializationContextImpl getAMQP_P2P_CONTEXT() {
        return AMQP_P2P_CONTEXT;
    }

    static {
        ByteSequence byteSequence = (ByteSequence)SchemaKt.getAmqpHeaderV1_0();
        ClassLoader classLoader = SerializationDefaults.INSTANCE.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"SerializationDefaults.javaClass.classLoader");
        AMQP_P2P_CONTEXT = new SerializationContextImpl(byteSequence, classLoader, new GlobalTransientClassWhiteList(new BuiltInExceptionsWhitelist()), MapsKt.emptyMap(), true, SerializationContext.UseCase.P2P);
    }
}

