/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationWhitelist;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.nodeapi.internal.serialization.AMQPSerializationScheme;
import net.corda.nodeapi.internal.serialization.AbstractAMQPSerializationScheme;
import net.corda.nodeapi.internal.serialization.AbstractAMQPSerializationScheme$WhenMappings;
import net.corda.nodeapi.internal.serialization.SerializationScheme;
import net.corda.nodeapi.internal.serialization.amqp.DeserializationInput;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationOutput;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.custom.BigDecimalSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.BitSetSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.ClassSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.CurrencySerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.DurationSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.EnumSetSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.InputStreamSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.InstantSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.LocalDateSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.LocalDateTimeSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.LocalTimeSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.MonthDaySerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.OffsetDateTimeSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.OffsetTimeSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.OpaqueBytesSubSequenceSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.PartyAndCertificateSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.PeriodSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.PublicKeySerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.SimpleStringSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.StringBufferSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.ThrowableSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.X500NameSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.X509CertificateHolderSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.YearMonthSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.YearSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.ZoneIdSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.ZonedDateTimeSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J5\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H$J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0019\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u001a\u001a\u0002H\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001bR&\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/corda/nodeapi/internal/serialization/AbstractAMQPSerializationScheme;", "Lnet/corda/nodeapi/internal/serialization/SerializationScheme;", "()V", "serializerFactoriesForContexts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "Lnet/corda/core/serialization/ClassWhitelist;", "Ljava/lang/ClassLoader;", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "canDeserializeVersion", "", "byteSequence", "Lnet/corda/core/utilities/ByteSequence;", "deserialize", "T", "", "clazz", "Ljava/lang/Class;", "context", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;Lnet/corda/core/serialization/SerializationContext;)Ljava/lang/Object;", "getSerializerFactory", "rpcClientSerializerFactory", "rpcServerSerializerFactory", "serialize", "Lnet/corda/core/serialization/SerializedBytes;", "obj", "(Ljava/lang/Object;Lnet/corda/core/serialization/SerializationContext;)Lnet/corda/core/serialization/SerializedBytes;", "Companion", "node-api_main"})
public abstract class AbstractAMQPSerializationScheme
implements SerializationScheme {
    private final ConcurrentHashMap<Pair<ClassWhitelist, ClassLoader>, SerializerFactory> serializerFactoriesForContexts = new ConcurrentHashMap();
    private static final Lazy serializationWhitelists$delegate;
    public static final Companion Companion;

    @NotNull
    protected abstract SerializerFactory rpcClientSerializerFactory(@NotNull SerializationContext var1);

    @NotNull
    protected abstract SerializerFactory rpcServerSerializerFactory(@NotNull SerializationContext var1);

    private final SerializerFactory getSerializerFactory(SerializationContext context) {
        SerializerFactory serializerFactory;
        SerializerFactory it;
        SerializerFactory serializerFactory2 = it = (serializerFactory = this.serializerFactoriesForContexts.computeIfAbsent((Pair<ClassWhitelist, ClassLoader>)new Pair((Object)context.getWhitelist(), (Object)context.getDeserializationClassLoader()), (Function<Pair<ClassWhitelist, ClassLoader>, SerializerFactory>)new Function<Pair<? extends ClassWhitelist, ? extends ClassLoader>, SerializerFactory>(this, context){
            final /* synthetic */ AbstractAMQPSerializationScheme this$0;
            final /* synthetic */ SerializationContext $context;

            @NotNull
            public final SerializerFactory apply(@NotNull Pair<? extends ClassWhitelist, ? extends ClassLoader> it) {
                SerializerFactory serializerFactory;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                switch (AbstractAMQPSerializationScheme$WhenMappings.$EnumSwitchMapping$0[this.$context.getUseCase().ordinal()]) {
                    case 1: {
                        throw (Throwable)new IllegalStateException("AMQP should not be used for checkpoint serialization.");
                    }
                    case 2: {
                        serializerFactory = this.this$0.rpcClientSerializerFactory(this.$context);
                        break;
                    }
                    case 3: {
                        serializerFactory = this.this$0.rpcServerSerializerFactory(this.$context);
                        break;
                    }
                    default: {
                        serializerFactory = new SerializerFactory(this.$context.getWhitelist(), this.$context.getDeserializationClassLoader());
                    }
                }
                return serializerFactory;
            }
            {
                this.this$0 = abstractAMQPSerializationScheme;
                this.$context = serializationContext;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)serializerFactory2, (String)"it");
        Companion.registerCustomSerializers(serializerFactory2);
        SerializerFactory serializerFactory3 = serializerFactory;
        Intrinsics.checkExpressionValueIsNotNull((Object)serializerFactory3, (String)"serializerFactoriesForCo\u2026erCustomSerializers(it) }");
        return serializerFactory3;
    }

    @Override
    @NotNull
    public <T> T deserialize(@NotNull ByteSequence byteSequence, @NotNull Class<T> clazz, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializerFactory serializerFactory = this.getSerializerFactory(context);
        return new DeserializationInput(serializerFactory).deserialize(byteSequence, clazz);
    }

    @Override
    @NotNull
    public <T> SerializedBytes<T> serialize(@NotNull T obj, @NotNull SerializationContext context) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SerializerFactory serializerFactory = this.getSerializerFactory(context);
        return new SerializationOutput(serializerFactory).serialize(obj);
    }

    protected final boolean canDeserializeVersion(@NotNull ByteSequence byteSequence) {
        Intrinsics.checkParameterIsNotNull((Object)byteSequence, (String)"byteSequence");
        return AMQPSerializationScheme.getAMQP_ENABLED() && Intrinsics.areEqual((Object)byteSequence, (Object)SchemaKt.getAmqpHeaderV1_0());
    }

    static {
        Companion = new Companion(null);
        serializationWhitelists$delegate = LazyKt.lazy((Function0)Companion.serializationWhitelists.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/serialization/AbstractAMQPSerializationScheme$Companion;", "", "()V", "serializationWhitelists", "", "Lnet/corda/core/serialization/SerializationWhitelist;", "getSerializationWhitelists", "()Ljava/util/List;", "serializationWhitelists$delegate", "Lkotlin/Lazy;", "registerCustomSerializers", "", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "node-api_main"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        private final List<SerializationWhitelist> getSerializationWhitelists() {
            Lazy lazy = serializationWhitelists$delegate;
            Companion companion = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (List)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void registerCustomSerializers(@NotNull SerializerFactory factory) {
            Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
            SerializerFactory $receiver = factory;
            $receiver.register(PublicKeySerializer.INSTANCE);
            $receiver.register(new ThrowableSerializer($receiver));
            $receiver.register(X500NameSerializer.INSTANCE);
            $receiver.register(BigDecimalSerializer.INSTANCE);
            $receiver.register(CurrencySerializer.INSTANCE);
            $receiver.register(new OpaqueBytesSubSequenceSerializer($receiver));
            $receiver.register(new InstantSerializer($receiver));
            $receiver.register(new DurationSerializer($receiver));
            $receiver.register(new LocalDateSerializer($receiver));
            $receiver.register(new LocalDateTimeSerializer($receiver));
            $receiver.register(new LocalTimeSerializer($receiver));
            $receiver.register(new ZonedDateTimeSerializer($receiver));
            $receiver.register(new ZoneIdSerializer($receiver));
            $receiver.register(new OffsetTimeSerializer($receiver));
            $receiver.register(new OffsetDateTimeSerializer($receiver));
            $receiver.register(new YearSerializer($receiver));
            $receiver.register(new YearMonthSerializer($receiver));
            $receiver.register(new MonthDaySerializer($receiver));
            $receiver.register(new PeriodSerializer($receiver));
            $receiver.register(new ClassSerializer($receiver));
            $receiver.register(X509CertificateHolderSerializer.INSTANCE);
            $receiver.register(new PartyAndCertificateSerializer(factory));
            $receiver.register(StringBufferSerializer.INSTANCE);
            $receiver.register(SimpleStringSerializer.INSTANCE);
            $receiver.register(InputStreamSerializer.INSTANCE);
            $receiver.register(new BitSetSerializer($receiver));
            $receiver.register(new EnumSetSerializer($receiver));
            for (SerializationWhitelist whitelistProvider : this.getSerializationWhitelists()) {
                Class[] classArray;
                void thisCollection$iv;
                void $receiver$iv;
                Collection collection = whitelistProvider.getWhitelist();
                SerializerFactory serializerFactory = factory;
                if ($receiver$iv == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new Class[thisCollection$iv.size()]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Class[] classArray2 = classArray;
                AMQPSerializationScheme.addToWhitelist(serializerFactory, Arrays.copyOf(classArray2, classArray2.length));
            }
        }

        private Companion() {
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "serializationWhitelists", "getSerializationWhitelists()Ljava/util/List;"))};
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

