/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/serialization/AutoCloseableSerialisationDetector;", "Lcom/esotericsoftware/kryo/Serializer;", "Ljava/lang/AutoCloseable;", "()V", "read", "", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "closeable", "node-api_main"})
final class AutoCloseableSerialisationDetector
extends Serializer<AutoCloseable> {
    public static final AutoCloseableSerialisationDetector INSTANCE;

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull AutoCloseable closeable) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)closeable, (String)"closeable");
        String message = "" + closeable.getClass().getName() + ", which is a closeable resource, has been detected during flow checkpointing. " + "Restoring such resources across node restarts is not supported. Make sure code accessing it is " + "confined to a private method or the reference is nulled out.";
        throw (Throwable)new UnsupportedOperationException(message);
    }

    @NotNull
    public Void read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<AutoCloseable> type) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        throw (Throwable)new IllegalStateException("Should not reach here!");
    }

    private AutoCloseableSerialisationDetector() {
        INSTANCE = this;
    }

    static {
        new AutoCloseableSerialisationDetector();
    }
}

