/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/internal/serialization/CertPathSerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Ljava/security/cert/CertPath;", "()V", "factory", "Ljava/security/cert/CertificateFactory;", "getFactory", "()Ljava/security/cert/CertificateFactory;", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "obj", "node-api_main"})
@ThreadSafe
public final class CertPathSerializer
extends Serializer<CertPath> {
    @NotNull
    private static final CertificateFactory factory;
    public static final CertPathSerializer INSTANCE;

    @NotNull
    public final CertificateFactory getFactory() {
        return factory;
    }

    @NotNull
    public CertPath read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<CertPath> type) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        CertPath certPath = factory.generateCertPath((InputStream)input);
        Intrinsics.checkExpressionValueIsNotNull((Object)certPath, (String)"factory.generateCertPath(input)");
        return certPath;
    }

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull CertPath obj) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        output.writeBytes(obj.getEncoded());
    }

    private CertPathSerializer() {
        INSTANCE = this;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Intrinsics.checkExpressionValueIsNotNull((Object)certificateFactory, (String)"CertificateFactory.getInstance(\"X.509\")");
        factory = certificateFactory;
    }

    static {
        new CertPathSerializer();
    }
}

