/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.corda.core.crypto.CompositeKey;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lnet/corda/nodeapi/internal/serialization/CompositeKeySerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Lnet/corda/core/crypto/CompositeKey;", "()V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "obj", "node-api_main"})
@ThreadSafe
public final class CompositeKeySerializer
extends Serializer<CompositeKey> {
    public static final CompositeKeySerializer INSTANCE;

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull CompositeKey obj) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        output.writeInt(obj.getThreshold());
        output.writeInt(obj.getChildren().size());
        Iterable $receiver$iv = obj.getChildren();
        for (Object element$iv : $receiver$iv) {
            CompositeKey.NodeAndWeight it = (CompositeKey.NodeAndWeight)element$iv;
            kryo.writeClassAndObject(output, (Object)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompositeKey read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<CompositeKey> type) {
        void $receiver$iv$iv$iv;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        int threshold = input.readInt();
        int minLen$iv = 2;
        Integer expectedLen$iv = null;
        int elemCount$iv = input.readInt();
        if (elemCount$iv < minLen$iv) {
            throw (Throwable)new KryoException("Cannot deserialize list, too little elements. Minimum required: " + minLen$iv + ", got: " + elemCount$iv);
        }
        int n = 1;
        Iterable iterable = $receiver$iv$iv = (Iterable)new IntRange(n, elemCount$iv);
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv$iv;
            int n2 = item$iv$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv$iv;
            Object object = kryo.readClassAndObject(input);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.core.crypto.CompositeKey.NodeAndWeight");
            }
            CompositeKey.NodeAndWeight nodeAndWeight = (CompositeKey.NodeAndWeight)object;
            collection.add(nodeAndWeight);
        }
        List children = (List)destination$iv$iv$iv;
        CompositeKey.Builder builder = new CompositeKey.Builder();
        Iterable $receiver$iv = children;
        for (Object element$iv : $receiver$iv) {
            CompositeKey.NodeAndWeight it = (CompositeKey.NodeAndWeight)element$iv;
            builder.addKey(it.getNode(), it.getWeight());
        }
        PublicKey publicKey = builder.build(Integer.valueOf(threshold));
        if (publicKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.corda.core.crypto.CompositeKey");
        }
        return (CompositeKey)publicKey;
    }

    private CompositeKeySerializer() {
        INSTANCE = this;
    }

    static {
        new CompositeKeySerializer();
    }
}

