/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializationContext;
import net.corda.nodeapi.internal.AttachmentsClassLoader;
import net.corda.nodeapi.internal.serialization.ThrowableSerializer;
import net.corda.nodeapi.internal.serialization.TransientClassWhiteList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0014\u0010\u0014\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010\u0015\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/corda/nodeapi/internal/serialization/CordaClassResolver;", "Lcom/esotericsoftware/kryo/util/DefaultClassResolver;", "serializationContext", "Lnet/corda/core/serialization/SerializationContext;", "(Lnet/corda/core/serialization/SerializationContext;)V", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "whitelistEnabled", "", "checkClass", "Lcom/esotericsoftware/kryo/Registration;", "type", "Ljava/lang/Class;", "checkForAnnotation", "disableWhitelist", "", "enableWhitelist", "getRegistration", "hasInheritedAnnotation", "registerImplicit", "reset", "KotlinObjectSerializer", "node-api_main"})
public final class CordaClassResolver
extends DefaultClassResolver {
    @NotNull
    private final ClassWhitelist whitelist;
    private boolean whitelistEnabled;

    @NotNull
    public final ClassWhitelist getWhitelist() {
        return this.whitelist;
    }

    @Nullable
    public Registration getRegistration(@NotNull Class<?> type) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Registration registration = super.getRegistration(type);
        if (registration == null) {
            registration = this.checkClass(type);
        }
        return registration;
    }

    public final void disableWhitelist() {
        this.whitelistEnabled = false;
    }

    public final void enableWhitelist() {
        this.whitelistEnabled = true;
    }

    private final Registration checkClass(Class<?> type) {
        if (!this.whitelistEnabled) {
            return null;
        }
        if (type.isPrimitive() || Intrinsics.areEqual(type, Object.class) || Modifier.isAbstract(type.getModifiers()) || Intrinsics.areEqual(type, String.class)) {
            return null;
        }
        if (type.isArray()) {
            Class<?> clazz = type.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.componentType");
            return this.checkClass(clazz);
        }
        if (!type.isEnum() && Enum.class.isAssignableFrom(type)) {
            Class<?> clazz = type.getSuperclass();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.superclass");
            return this.checkClass(clazz);
        }
        if (Lambda.class.isAssignableFrom(type)) {
            return null;
        }
        if (!this.whitelist.hasListed(type) && !this.checkForAnnotation(type)) {
            throw (Throwable)new KryoException("Class " + Util.className(type) + " is not annotated or on the whitelist, so cannot be used in serialization");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Registration registerImplicit(@NotNull Class<?> type) {
        Object object;
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        try {
            object = JvmClassMappingKt.getKotlinClass(type).getObjectInstance();
        }
        catch (Throwable t) {
            object = null;
        }
        Object objectInstance = object;
        boolean references = this.kryo.getReferences();
        try {
            FieldSerializer fieldSerializer;
            Serializer serializer2;
            this.kryo.setReferences(true);
            if (objectInstance != null) {
                serializer2 = new KotlinObjectSerializer(objectInstance);
            } else if (Lambda.class.isAssignableFrom(type)) {
                FieldSerializer $receiver = fieldSerializer = new FieldSerializer(this.kryo, type);
                $receiver.setIgnoreSyntheticFields(false);
                serializer2 = (Serializer)fieldSerializer;
            } else if (Throwable.class.isAssignableFrom(type)) {
                Kryo kryo = this.kryo;
                Intrinsics.checkExpressionValueIsNotNull((Object)kryo, (String)"kryo");
                serializer2 = new ThrowableSerializer(kryo, type);
            } else {
                serializer2 = this.kryo.getDefaultSerializer(type);
            }
            Serializer serializer3 = serializer2;
            Registration registration = this.register(new Registration(type, serializer3, -1));
            Intrinsics.checkExpressionValueIsNotNull((Object)registration, (String)"register(Registration(ty\u2026erializer, NAME.toInt()))");
            fieldSerializer = registration;
            return fieldSerializer;
        }
        finally {
            this.kryo.setReferences(references);
        }
    }

    private final boolean checkForAnnotation(Class<?> type) {
        return !(type.getClassLoader() instanceof AttachmentsClassLoader) && !KryoSerializable.class.isAssignableFrom(type) && !type.isAnnotationPresent(DefaultSerializer.class) && (type.isAnnotationPresent(CordaSerializable.class) || this.hasInheritedAnnotation(type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInheritedAnnotation(Class<?> type) {
        Object[] $receiver$iv = type.getInterfaces();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Object element$iv = $receiver$iv[i];
            Class it = (Class)element$iv;
            if (it.isAnnotationPresent(CordaSerializable.class)) return true;
            Class clazz = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"it");
            if (this.hasInheritedAnnotation(clazz)) {
                return true;
            }
            boolean bl = false;
            if (!bl) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (type.getSuperclass() == null) return false;
        Class<?> clazz = type.getSuperclass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.superclass");
        if (!this.hasInheritedAnnotation(clazz)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void reset() {
        super.reset();
        if (this.nameToClass != null) {
            void $receiver$iv$iv;
            List classesToRemove = new ArrayList(this.nameToClass.size);
            Iterable $receiver$iv = (Iterable)this.nameToClass.entries();
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ObjectMap.Entry it = (ObjectMap.Entry)element$iv$iv;
                if (!(((Class)it.value).getClassLoader() instanceof AttachmentsClassLoader)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                ObjectMap.Entry it = (ObjectMap.Entry)element$iv;
                Collection collection = classesToRemove;
                Object object = it.key;
                collection.add(object);
            }
            for (String className : classesToRemove) {
                this.nameToClass.remove((Object)className);
            }
        }
    }

    public CordaClassResolver(@NotNull SerializationContext serializationContext) {
        Intrinsics.checkParameterIsNotNull((Object)serializationContext, (String)"serializationContext");
        this.whitelist = new TransientClassWhiteList(serializationContext.getWhitelist());
        this.whitelistEnabled = true;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/serialization/CordaClassResolver$KotlinObjectSerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "", "objectInstance", "(Ljava/lang/Object;)V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "obj", "node-api_main"})
    private static final class KotlinObjectSerializer
    extends Serializer<Object> {
        private final Object objectInstance;

        @NotNull
        public Object read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<Object> type) {
            Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            return this.objectInstance;
        }

        public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull Object obj) {
            Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        }

        public KotlinObjectSerializer(@NotNull Object objectInstance) {
            Intrinsics.checkParameterIsNotNull((Object)objectInstance, (String)"objectInstance");
            this.objectInstance = objectInstance;
        }
    }
}

