/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/serialization/CordaClosureSerializer;", "Lcom/esotericsoftware/kryo/serializers/ClosureSerializer;", "()V", "ERROR_MESSAGE", "", "getERROR_MESSAGE", "()Ljava/lang/String;", "isSerializable", "", "target", "", "write", "", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "output", "Lcom/esotericsoftware/kryo/io/Output;", "node-api_main"})
public final class CordaClosureSerializer
extends ClosureSerializer {
    @NotNull
    private static final String ERROR_MESSAGE = "Unable to serialize Java Lambda expression, unless explicitly declared e.g., Runnable r = (Runnable & Serializable) () -> System.out.println(\"Hello world!\");";
    public static final CordaClosureSerializer INSTANCE;

    @NotNull
    public final String getERROR_MESSAGE() {
        return ERROR_MESSAGE;
    }

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull Object target) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (!this.isSerializable(target)) {
            throw (Throwable)new IllegalArgumentException(ERROR_MESSAGE);
        }
        super.write(kryo, output, target);
    }

    private final boolean isSerializable(Object target) {
        return target instanceof Serializable;
    }

    private CordaClosureSerializer() {
        INSTANCE = this;
        ERROR_MESSAGE = ERROR_MESSAGE;
    }

    static {
        new CordaClosureSerializer();
    }
}

