/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.nodeapi.internal.serialization.KryoKt;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lnet/corda/nodeapi/internal/serialization/Ed25519PrivateKeySerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Lnet/i2p/crypto/eddsa/EdDSAPrivateKey;", "()V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "obj", "node-api_main"})
@ThreadSafe
public final class Ed25519PrivateKeySerializer
extends Serializer<EdDSAPrivateKey> {
    public static final Ed25519PrivateKeySerializer INSTANCE;

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull EdDSAPrivateKey obj) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        boolean bl = Intrinsics.areEqual((Object)obj.getParams(), (Object)Crypto.EDDSA_ED25519_SHA512.getAlgSpec());
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] byArray = obj.getSeed();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"obj.seed");
        KryoKt.writeBytesWithLength(output, byArray);
    }

    @NotNull
    public EdDSAPrivateKey read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<EdDSAPrivateKey> type) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        byte[] seed = KryoKt.readBytesWithLength(input);
        AlgorithmParameterSpec algorithmParameterSpec = Crypto.EDDSA_ED25519_SHA512.getAlgSpec();
        if (algorithmParameterSpec == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec");
        }
        return new EdDSAPrivateKey(new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)((EdDSANamedCurveSpec)algorithmParameterSpec)));
    }

    private Ed25519PrivateKeySerializer() {
        INSTANCE = this;
    }

    static {
        new Ed25519PrivateKeySerializer();
    }
}

