/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.serialization.KryoKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lnet/corda/nodeapi/internal/serialization/InputStreamSerializer;", "Lcom/esotericsoftware/kryo/Serializer;", "Ljava/io/InputStream;", "()V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "stream", "node-api_main"})
public final class InputStreamSerializer
extends Serializer<InputStream> {
    public static final InputStreamSerializer INSTANCE;

    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull InputStream stream) {
        int numberOfBytesRead;
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        byte[] buffer = new byte[4096];
        while ((numberOfBytesRead = stream.read(buffer)) != -1) {
            output.writeInt(numberOfBytesRead, true);
            output.writeBytes(buffer, 0, numberOfBytesRead);
        }
        output.writeInt(0);
    }

    @NotNull
    public InputStream read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<InputStream> type) {
        byte[] chunk;
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        while (!((byArray = (chunk = KryoKt.readBytesWithLength(input))).length == 0)) {
            chunks.add(chunk);
        }
        Iterable $receiver$iv = chunks;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            byte[] it = (byte[])element$iv;
            sum$iv += it.length;
        }
        byte[] flattened = new byte[sum$iv];
        int offset = 0;
        for (byte[] chunk2 : chunks) {
            System.arraycopy(chunk2, 0, flattened, offset, chunk2.length);
            offset += chunk2.length;
        }
        return new ByteArrayInputStream(flattened);
    }

    private InputStreamSerializer() {
        INSTANCE = this;
    }

    static {
        new InputStreamSerializer();
    }
}

