/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.util.Util;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.nodeapi.internal.serialization.MutableClassWhitelist;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u00052\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/corda/nodeapi/internal/serialization/LoggingWhitelist;", "Lnet/corda/nodeapi/internal/serialization/MutableClassWhitelist;", "delegate", "Lnet/corda/core/serialization/ClassWhitelist;", "global", "", "(Lnet/corda/core/serialization/ClassWhitelist;Z)V", "alreadySeen", "", "", "getAlreadySeen", "()Ljava/util/Set;", "getDelegate", "()Lnet/corda/core/serialization/ClassWhitelist;", "getGlobal", "()Z", "locallySeen", "add", "", "entry", "Ljava/lang/Class;", "hasListed", "type", "Companion", "node-api_main"})
public final class LoggingWhitelist
implements MutableClassWhitelist {
    private final Set<String> locallySeen;
    @NotNull
    private final ClassWhitelist delegate;
    private final boolean global;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Set<String> globallySeen;
    @Nullable
    private static final PrintWriter journalWriter;
    public static final Companion Companion;

    private final Set<String> getAlreadySeen() {
        return this.global ? Companion.getGloballySeen() : this.locallySeen;
    }

    public boolean hasListed(@NotNull Class<?> type) {
        block1: {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            if (!(this.getAlreadySeen().contains(type.getName()) ^ true) || this.delegate.hasListed(type)) break block1;
            Collection collection = this.getAlreadySeen();
            String string = type.getName();
            collection.add(string);
            String className = Util.className(type);
            Companion.getLog().warn("Dynamically whitelisted class " + className);
            PrintWriter printWriter = Companion.getJournalWriter();
            if (printWriter != null) {
                printWriter.println(className);
            }
        }
        return true;
    }

    @Override
    public void add(@NotNull Class<?> entry) {
        Intrinsics.checkParameterIsNotNull(entry, (String)"entry");
        if (!(this.delegate instanceof MutableClassWhitelist)) {
            throw (Throwable)new UnsupportedOperationException("Cannot add to whitelist since delegate whitelist is not mutable.");
        }
        ((MutableClassWhitelist)this.delegate).add(entry);
    }

    @NotNull
    public final ClassWhitelist getDelegate() {
        return this.delegate;
    }

    public final boolean getGlobal() {
        return this.global;
    }

    public LoggingWhitelist(@NotNull ClassWhitelist delegate, boolean global) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.global = global;
        LoggingWhitelist loggingWhitelist = this;
        loggingWhitelist.locallySeen = set = (Set)new LinkedHashSet();
    }

    public /* synthetic */ LoggingWhitelist(ClassWhitelist classWhitelist, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(classWhitelist, bl);
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = LoggerFactory.getLogger(LoggingWhitelist.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LoggerFactory.getLogger(T::class.java)");
        log = logger2;
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.synchronizedSet(mutableSetOf())");
        globallySeen = set;
        journalWriter = LoggingWhitelist.Companion.openOptionalDynamicWhitelistJournal();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/serialization/LoggingWhitelist$Companion;", "", "()V", "globallySeen", "", "", "getGloballySeen", "()Ljava/util/Set;", "journalWriter", "Ljava/io/PrintWriter;", "getJournalWriter", "()Ljava/io/PrintWriter;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "openOptionalDynamicWhitelistJournal", "node-api_main"})
    public static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final Set<String> getGloballySeen() {
            return globallySeen;
        }

        @Nullable
        public final PrintWriter getJournalWriter() {
            return journalWriter;
        }

        private final PrintWriter openOptionalDynamicWhitelistJournal() {
            CharSequence charSequence;
            String fileName = System.getenv("WHITELIST_FILE");
            if (fileName != null && (charSequence = (CharSequence)fileName).length() > 0) {
                try {
                    return new PrintWriter((Writer)Files.newBufferedWriter(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE), true);
                }
                catch (Exception ioEx) {
                    this.getLog().error("Could not open/create whitelist journal file for append: " + fileName, (Throwable)ioEx);
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

