/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Attachment;
import net.corda.core.crypto.SecureHash;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.MissingAttachmentsException;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.utilities.ByteSequence;
import net.corda.nodeapi.internal.AttachmentsClassLoader;
import net.corda.nodeapi.internal.serialization.SerializationSchemeKt;
import net.corda.nodeapi.internal.serialization.SerializeAsTokenContextImpl;
import net.corda.nodeapi.internal.serialization.SerializeAsTokenContextImplKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003J\t\u0010&\u001a\u00020\u000eH\u00c6\u0003JQ\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0016\u0010.\u001a\u00020\u00012\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u00020\u0005H\u0016J\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\nH\u0016J\u0014\u00107\u001a\u00020\u00012\n\u00108\u001a\u0006\u0012\u0002\b\u000309H\u0016J\b\u0010:\u001a\u00020\u0001H\u0016R \u0010\u0010\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006;"}, d2={"Lnet/corda/nodeapi/internal/serialization/SerializationContextImpl;", "Lnet/corda/core/serialization/SerializationContext;", "preferredSerializationVersion", "Lnet/corda/core/utilities/ByteSequence;", "deserializationClassLoader", "Ljava/lang/ClassLoader;", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "properties", "", "", "objectReferencesEnabled", "", "useCase", "Lnet/corda/core/serialization/SerializationContext$UseCase;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/ClassLoader;Lnet/corda/core/serialization/ClassWhitelist;Ljava/util/Map;ZLnet/corda/core/serialization/SerializationContext$UseCase;)V", "cache", "Lcom/google/common/cache/Cache;", "", "Lnet/corda/core/crypto/SecureHash;", "Lnet/corda/nodeapi/internal/AttachmentsClassLoader;", "getDeserializationClassLoader", "()Ljava/lang/ClassLoader;", "getObjectReferencesEnabled", "()Z", "getPreferredSerializationVersion", "()Lnet/corda/core/utilities/ByteSequence;", "getProperties", "()Ljava/util/Map;", "getUseCase", "()Lnet/corda/core/serialization/SerializationContext$UseCase;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "withAttachmentsClassLoader", "attachmentHashes", "withClassLoader", "classLoader", "withPreferredSerializationVersion", "versionHeader", "withProperty", "property", "value", "withWhitelisted", "clazz", "Ljava/lang/Class;", "withoutReferences", "node-api_main"})
public final class SerializationContextImpl
implements SerializationContext {
    private final Cache<List<SecureHash>, AttachmentsClassLoader> cache;
    @NotNull
    private final ByteSequence preferredSerializationVersion;
    @NotNull
    private final ClassLoader deserializationClassLoader;
    @NotNull
    private final ClassWhitelist whitelist;
    @NotNull
    private final Map<Object, Object> properties;
    private final boolean objectReferencesEnabled;
    @NotNull
    private final SerializationContext.UseCase useCase;

    @NotNull
    public SerializationContext withAttachmentsClassLoader(@NotNull List<? extends SecureHash> attachmentHashes) {
        Intrinsics.checkParameterIsNotNull(attachmentHashes, (String)"attachmentHashes");
        Object object = this.getProperties().get(SerializationSchemeKt.getAttachmentsClassLoaderEnabledPropertyName());
        if (!(object instanceof Boolean)) {
            object = null;
        }
        Boolean bl = (Boolean)object;
        if (!(bl != null ? bl : false)) {
            return this;
        }
        Object object2 = this.getProperties().get(SerializeAsTokenContextImplKt.getSerializationContextKey());
        if (!(object2 instanceof SerializeAsTokenContextImpl)) {
            object2 = null;
        }
        SerializeAsTokenContextImpl serializeAsTokenContextImpl = (SerializeAsTokenContextImpl)object2;
        if (serializeAsTokenContextImpl == null) {
            return this;
        }
        SerializeAsTokenContextImpl serializationContext = serializeAsTokenContextImpl;
        try {
            Object object3 = this.cache.get(attachmentHashes, (Callable)new Callable<AttachmentsClassLoader>(this, attachmentHashes, serializationContext){
                final /* synthetic */ SerializationContextImpl this$0;
                final /* synthetic */ List $attachmentHashes;
                final /* synthetic */ SerializeAsTokenContextImpl $serializationContext;

                @NotNull
                public final AttachmentsClassLoader call() {
                    ArrayList<E> missing = new ArrayList<E>();
                    ArrayList<E> attachments = new ArrayList<E>();
                    Iterable $receiver$iv = this.$attachmentHashes;
                    for (T element$iv : $receiver$iv) {
                        Collection collection;
                        Object object;
                        SecureHash id = (SecureHash)element$iv;
                        if (this.$serializationContext.getServiceHub().getAttachments().openAttachment(id) != null) {
                            Attachment it = object;
                            collection = attachments;
                            collection.add(it);
                            continue;
                        }
                        Object $receiver = object = this.this$0;
                        collection = missing;
                        SecureHash secureHash = id;
                        collection.add(secureHash);
                    }
                    Collection collection = missing;
                    if (!collection.isEmpty()) {
                        throw (Throwable)new MissingAttachmentsException((List)missing);
                    }
                    return new AttachmentsClassLoader((List<? extends Attachment>)attachments, this.this$0.getDeserializationClassLoader());
                }
                {
                    this.this$0 = serializationContextImpl;
                    this.$attachmentHashes = list;
                    this.$serializationContext = serializeAsTokenContextImpl;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"cache.get(attachmentHash\u2026lassLoader)\n            }");
            return this.withClassLoader((ClassLoader)object3);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            throw throwable;
        }
    }

    @NotNull
    public SerializationContext withProperty(@NotNull Object property, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return SerializationContextImpl.copy$default(this, null, null, null, MapsKt.plus(this.getProperties(), (Pair)TuplesKt.to((Object)property, (Object)value)), false, null, 55, null);
    }

    @NotNull
    public SerializationContext withoutReferences() {
        return SerializationContextImpl.copy$default(this, null, null, null, null, false, null, 47, null);
    }

    @NotNull
    public SerializationContext withClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        return SerializationContextImpl.copy$default(this, null, classLoader, null, null, false, null, 61, null);
    }

    @NotNull
    public SerializationContext withWhitelisted(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return SerializationContextImpl.copy$default(this, null, null, new ClassWhitelist(this, clazz){
            final /* synthetic */ SerializationContextImpl this$0;
            final /* synthetic */ Class $clazz;

            public boolean hasListed(@NotNull Class<?> type) {
                Intrinsics.checkParameterIsNotNull(type, (String)"type");
                return this.this$0.getWhitelist().hasListed(type) || Intrinsics.areEqual((Object)type.getName(), (Object)this.$clazz.getName());
            }
            {
                this.this$0 = $outer;
                this.$clazz = $captured_local_variable$1;
            }
        }, null, false, null, 59, null);
    }

    @NotNull
    public SerializationContextImpl withPreferredSerializationVersion(@NotNull ByteSequence versionHeader) {
        Intrinsics.checkParameterIsNotNull((Object)versionHeader, (String)"versionHeader");
        return SerializationContextImpl.copy$default(this, versionHeader, null, null, null, false, null, 62, null);
    }

    @NotNull
    public ByteSequence getPreferredSerializationVersion() {
        return this.preferredSerializationVersion;
    }

    @NotNull
    public ClassLoader getDeserializationClassLoader() {
        return this.deserializationClassLoader;
    }

    @NotNull
    public ClassWhitelist getWhitelist() {
        return this.whitelist;
    }

    @NotNull
    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public boolean getObjectReferencesEnabled() {
        return this.objectReferencesEnabled;
    }

    @NotNull
    public SerializationContext.UseCase getUseCase() {
        return this.useCase;
    }

    public SerializationContextImpl(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase) {
        Intrinsics.checkParameterIsNotNull((Object)preferredSerializationVersion, (String)"preferredSerializationVersion");
        Intrinsics.checkParameterIsNotNull((Object)deserializationClassLoader, (String)"deserializationClassLoader");
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        this.preferredSerializationVersion = preferredSerializationVersion;
        this.deserializationClassLoader = deserializationClassLoader;
        this.whitelist = whitelist;
        this.properties = properties;
        this.objectReferencesEnabled = objectReferencesEnabled;
        this.useCase = useCase;
        Cache cache = CacheBuilder.newBuilder().weakValues().maximumSize(1024L).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache, (String)"CacheBuilder.newBuilder(\u2026maximumSize(1024).build()");
        this.cache = cache;
    }

    @NotNull
    public final ByteSequence component1() {
        return this.getPreferredSerializationVersion();
    }

    @NotNull
    public final ClassLoader component2() {
        return this.getDeserializationClassLoader();
    }

    @NotNull
    public final ClassWhitelist component3() {
        return this.getWhitelist();
    }

    @NotNull
    public final Map<Object, Object> component4() {
        return this.getProperties();
    }

    public final boolean component5() {
        return this.getObjectReferencesEnabled();
    }

    @NotNull
    public final SerializationContext.UseCase component6() {
        return this.getUseCase();
    }

    @NotNull
    public final SerializationContextImpl copy(@NotNull ByteSequence preferredSerializationVersion, @NotNull ClassLoader deserializationClassLoader, @NotNull ClassWhitelist whitelist, @NotNull Map<Object, ? extends Object> properties, boolean objectReferencesEnabled, @NotNull SerializationContext.UseCase useCase) {
        Intrinsics.checkParameterIsNotNull((Object)preferredSerializationVersion, (String)"preferredSerializationVersion");
        Intrinsics.checkParameterIsNotNull((Object)deserializationClassLoader, (String)"deserializationClassLoader");
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)useCase, (String)"useCase");
        return new SerializationContextImpl(preferredSerializationVersion, deserializationClassLoader, whitelist, properties, objectReferencesEnabled, useCase);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SerializationContextImpl copy$default(SerializationContextImpl serializationContextImpl, ByteSequence byteSequence, ClassLoader classLoader, ClassWhitelist classWhitelist, Map map, boolean bl, SerializationContext.UseCase useCase, int n, Object object) {
        if ((n & 1) != 0) {
            byteSequence = serializationContextImpl.getPreferredSerializationVersion();
        }
        if ((n & 2) != 0) {
            classLoader = serializationContextImpl.getDeserializationClassLoader();
        }
        if ((n & 4) != 0) {
            classWhitelist = serializationContextImpl.getWhitelist();
        }
        if ((n & 8) != 0) {
            map = serializationContextImpl.getProperties();
        }
        if ((n & 0x10) != 0) {
            bl = serializationContextImpl.getObjectReferencesEnabled();
        }
        if ((n & 0x20) != 0) {
            useCase = serializationContextImpl.getUseCase();
        }
        return serializationContextImpl.copy(byteSequence, classLoader, classWhitelist, map, bl, useCase);
    }

    public String toString() {
        return "SerializationContextImpl(preferredSerializationVersion=" + this.getPreferredSerializationVersion() + ", deserializationClassLoader=" + this.getDeserializationClassLoader() + ", whitelist=" + this.getWhitelist() + ", properties=" + this.getProperties() + ", objectReferencesEnabled=" + this.getObjectReferencesEnabled() + ", useCase=" + this.getUseCase() + ")";
    }

    public int hashCode() {
        ByteSequence byteSequence = this.getPreferredSerializationVersion();
        ClassLoader classLoader = this.getDeserializationClassLoader();
        ClassWhitelist classWhitelist = this.getWhitelist();
        Map<Object, Object> map = this.getProperties();
        int n = ((((byteSequence != null ? byteSequence.hashCode() : 0) * 31 + (classLoader != null ? classLoader.hashCode() : 0)) * 31 + (classWhitelist != null ? classWhitelist.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31;
        int n2 = this.getObjectReferencesEnabled() ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        SerializationContext.UseCase useCase = this.getUseCase();
        return (n + n2) * 31 + (useCase != null ? useCase.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SerializationContextImpl)) break block3;
                SerializationContextImpl serializationContextImpl = (SerializationContextImpl)object;
                if (!Intrinsics.areEqual((Object)this.getPreferredSerializationVersion(), (Object)serializationContextImpl.getPreferredSerializationVersion()) || !Intrinsics.areEqual((Object)this.getDeserializationClassLoader(), (Object)serializationContextImpl.getDeserializationClassLoader()) || !Intrinsics.areEqual((Object)this.getWhitelist(), (Object)serializationContextImpl.getWhitelist()) || !Intrinsics.areEqual(this.getProperties(), serializationContextImpl.getProperties()) || !(this.getObjectReferencesEnabled() == serializationContextImpl.getObjectReferencesEnabled()) || !Intrinsics.areEqual((Object)this.getUseCase(), (Object)serializationContextImpl.getUseCase())) break block3;
            }
            return true;
        }
        return false;
    }
}

