/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.core.internal.InternalUtilsKt;
import net.corda.core.serialization.SerializationToken;
import net.corda.core.serialization.SerializeAsToken;
import net.corda.core.serialization.SerializeAsTokenContext;
import net.corda.nodeapi.internal.serialization.KryoKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lnet/corda/nodeapi/internal/serialization/SerializeAsTokenSerializer;", "T", "Lnet/corda/core/serialization/SerializeAsToken;", "Lcom/esotericsoftware/kryo/Serializer;", "()V", "read", "kryo", "Lcom/esotericsoftware/kryo/Kryo;", "input", "Lcom/esotericsoftware/kryo/io/Input;", "type", "Ljava/lang/Class;", "(Lcom/esotericsoftware/kryo/Kryo;Lcom/esotericsoftware/kryo/io/Input;Ljava/lang/Class;)Lnet/corda/core/serialization/SerializeAsToken;", "write", "", "output", "Lcom/esotericsoftware/kryo/io/Output;", "obj", "(Lcom/esotericsoftware/kryo/Kryo;Lcom/esotericsoftware/kryo/io/Output;Lnet/corda/core/serialization/SerializeAsToken;)V", "node-api_main"})
public final class SerializeAsTokenSerializer<T extends SerializeAsToken>
extends Serializer<T> {
    public void write(@NotNull Kryo kryo, @NotNull Output output, @NotNull T obj) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        SerializeAsTokenContext serializeAsTokenContext = KryoKt.serializationContext(kryo);
        if (serializeAsTokenContext == null) {
            throw (Throwable)new KryoException("Attempt to write a " + Reflection.getOrCreateKotlinClass(SerializeAsToken.class).getSimpleName() + " instance of " + obj.getClass().getName() + " without initialising a context");
        }
        kryo.writeClassAndObject(output, (Object)obj.toToken(serializeAsTokenContext));
    }

    @NotNull
    public T read(@NotNull Kryo kryo, @NotNull Input input, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)kryo, (String)"kryo");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Object object = kryo.readClassAndObject(input);
        if (!(object instanceof SerializationToken)) {
            object = null;
        }
        SerializationToken serializationToken = (SerializationToken)object;
        if (serializationToken == null) {
            throw (Throwable)new KryoException("Non-token read for tokenized type: " + type.getName());
        }
        SerializationToken token = serializationToken;
        SerializeAsTokenContext serializeAsTokenContext = KryoKt.serializationContext(kryo);
        if (serializeAsTokenContext == null) {
            throw (Throwable)new KryoException("Attempt to read a token for a " + Reflection.getOrCreateKotlinClass(SerializeAsToken.class).getSimpleName() + " instance of " + type.getName() + " without initialising a context");
        }
        Object fromToken = token.fromToken(serializeAsTokenContext);
        SerializeAsToken serializeAsToken = (SerializeAsToken)InternalUtilsKt.castIfPossible(type, (Object)fromToken);
        if (serializeAsToken == null) {
            throw (Throwable)new KryoException("Token read (" + token + ") did not return expected tokenized type: " + type.getName());
        }
        return (T)serializeAsToken;
    }
}

