/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization;

import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationDefaults;
import net.corda.core.utilities.ByteSequence;
import net.corda.nodeapi.internal.serialization.AllButBlacklisted;
import net.corda.nodeapi.internal.serialization.BuiltInExceptionsWhitelist;
import net.corda.nodeapi.internal.serialization.GlobalTransientClassWhiteList;
import net.corda.nodeapi.internal.serialization.QuasarWhitelist;
import net.corda.nodeapi.internal.serialization.SerializationContextImpl;
import net.corda.nodeapi.internal.serialization.SerializationSchemeKt;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\u00a8\u0006\n"}, d2={"AMQP_STORAGE_CONTEXT", "Lnet/corda/nodeapi/internal/serialization/SerializationContextImpl;", "getAMQP_STORAGE_CONTEXT", "()Lnet/corda/nodeapi/internal/serialization/SerializationContextImpl;", "KRYO_CHECKPOINT_CONTEXT", "getKRYO_CHECKPOINT_CONTEXT", "KRYO_RPC_SERVER_CONTEXT", "getKRYO_RPC_SERVER_CONTEXT", "KRYO_STORAGE_CONTEXT", "getKRYO_STORAGE_CONTEXT", "node-api_main"})
@JvmName(name="ServerContexts")
public final class ServerContexts {
    @NotNull
    private static final SerializationContextImpl KRYO_RPC_SERVER_CONTEXT;
    @NotNull
    private static final SerializationContextImpl KRYO_STORAGE_CONTEXT;
    @NotNull
    private static final SerializationContextImpl KRYO_CHECKPOINT_CONTEXT;
    @NotNull
    private static final SerializationContextImpl AMQP_STORAGE_CONTEXT;

    @NotNull
    public static final SerializationContextImpl getKRYO_RPC_SERVER_CONTEXT() {
        return KRYO_RPC_SERVER_CONTEXT;
    }

    @NotNull
    public static final SerializationContextImpl getKRYO_STORAGE_CONTEXT() {
        return KRYO_STORAGE_CONTEXT;
    }

    @NotNull
    public static final SerializationContextImpl getKRYO_CHECKPOINT_CONTEXT() {
        return KRYO_CHECKPOINT_CONTEXT;
    }

    @NotNull
    public static final SerializationContextImpl getAMQP_STORAGE_CONTEXT() {
        return AMQP_STORAGE_CONTEXT;
    }

    static {
        ByteSequence byteSequence = (ByteSequence)SerializationSchemeKt.getKryoHeaderV0_1();
        ClassLoader classLoader = SerializationDefaults.INSTANCE.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"SerializationDefaults.javaClass.classLoader");
        KRYO_RPC_SERVER_CONTEXT = new SerializationContextImpl(byteSequence, classLoader, new GlobalTransientClassWhiteList(new BuiltInExceptionsWhitelist()), MapsKt.emptyMap(), true, SerializationContext.UseCase.RPCServer);
        ByteSequence byteSequence2 = (ByteSequence)SerializationSchemeKt.getKryoHeaderV0_1();
        ClassLoader classLoader2 = SerializationDefaults.INSTANCE.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"SerializationDefaults.javaClass.classLoader");
        KRYO_STORAGE_CONTEXT = new SerializationContextImpl(byteSequence2, classLoader2, AllButBlacklisted.INSTANCE, MapsKt.emptyMap(), true, SerializationContext.UseCase.Storage);
        ByteSequence byteSequence3 = (ByteSequence)SerializationSchemeKt.getKryoHeaderV0_1();
        ClassLoader classLoader3 = SerializationDefaults.INSTANCE.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader3, (String)"SerializationDefaults.javaClass.classLoader");
        KRYO_CHECKPOINT_CONTEXT = new SerializationContextImpl(byteSequence3, classLoader3, QuasarWhitelist.INSTANCE, MapsKt.emptyMap(), true, SerializationContext.UseCase.Checkpoint);
        ByteSequence byteSequence4 = (ByteSequence)SchemaKt.getAmqpHeaderV1_0();
        ClassLoader classLoader4 = SerializationDefaults.INSTANCE.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)classLoader4, (String)"SerializationDefaults.javaClass.classLoader");
        AMQP_STORAGE_CONTEXT = new SerializationContextImpl(byteSequence4, classLoader4, AllButBlacklisted.INSTANCE, MapsKt.emptyMap(), true, SerializationContext.UseCase.Storage);
    }
}

