/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.InternalUtilsKt;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import net.corda.nodeapi.internal.serialization.amqp.AMQPSerializer;
import net.corda.nodeapi.internal.serialization.amqp.Envelope;
import net.corda.nodeapi.internal.serialization.amqp.ObjectAndEnvelope;
import net.corda.nodeapi.internal.serialization.amqp.ReferencedObject;
import net.corda.nodeapi.internal.serialization.amqp.Schema;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationHelperKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0003\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u0002H\u000f\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0087\b\u00a2\u0006\u0002\u0010\u0012J-\u0010\u000e\u001a\u0002H\u000f\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0018\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0081\b\u00a2\u0006\u0002\b\u0019J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0018\"\b\b\u0000\u0010\u000f*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0015H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0013H\u0003J%\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J)\u0010#\u001a\u0004\u0018\u00010\u00012\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b$J\u0014\u0010%\u001a\u00020&*\u00020!2\u0006\u0010'\u001a\u00020!H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/DeserializationInput;", "", "serializerFactory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "objectHistory", "", "getSerializerFactory$node_api_main", "()Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "des", "R", "generator", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "deserialize", "T", "bytes", "Lnet/corda/core/serialization/SerializedBytes;", "(Lnet/corda/core/serialization/SerializedBytes;)Ljava/lang/Object;", "Lnet/corda/core/utilities/ByteSequence;", "clazz", "Ljava/lang/Class;", "(Lnet/corda/core/utilities/ByteSequence;Ljava/lang/Class;)Ljava/lang/Object;", "deserializeAndReturnEnvelope", "Lnet/corda/nodeapi/internal/serialization/amqp/ObjectAndEnvelope;", "deserializeAndReturnEnvelope$node_api_main", "getEnvelope", "Lnet/corda/nodeapi/internal/serialization/amqp/Envelope;", "readObject", "obj", "schema", "Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "type", "Ljava/lang/reflect/Type;", "readObject$node_api_main", "readObjectOrNull", "readObjectOrNull$node_api_main", "materiallyEquivalentTo", "", "that", "Companion", "node-api_main"})
public final class DeserializationInput {
    private final List<Object> objectHistory;
    @NotNull
    private final SerializerFactory serializerFactory;
    private static final int BYTES_NEEDED_TO_PEEK = 23;
    public static final Companion Companion = new Companion(null);

    private final <T> T deserialize(SerializedBytes<T> bytes) throws NotSerializableException {
        ByteSequence byteSequence = (ByteSequence)bytes;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.deserialize(byteSequence, Object.class);
    }

    private final <T> ObjectAndEnvelope<T> deserializeAndReturnEnvelope$node_api_main(SerializedBytes<T> bytes) throws NotSerializableException {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.deserializeAndReturnEnvelope(bytes, Object.class);
    }

    private final Envelope getEnvelope(ByteSequence bytes) throws NotSerializableException {
        int headerSize = SchemaKt.getAmqpHeaderV1_0().getSize();
        if (Intrinsics.areEqual((Object)bytes.take(headerSize), (Object)SchemaKt.getAmqpHeaderV1_0()) ^ true) {
            throw (Throwable)new NotSerializableException("Serialization header does not match.");
        }
        Data data = Data.Factory.create();
        long size = data.decode(ByteBuffer.wrap(bytes.getBytes(), bytes.getOffset() + headerSize, bytes.getSize() - headerSize));
        if ((int)size != bytes.getSize() - headerSize) {
            throw (Throwable)new NotSerializableException("Unexpected size of data");
        }
        Data data2 = data;
        Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"data");
        return Envelope.Companion.get(data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R des(Function0<? extends R> generator) throws NotSerializableException {
        try {
            Object object = generator.invoke();
            return (R)object;
        }
        catch (NotSerializableException nse) {
            throw (Throwable)nse;
        }
        catch (Throwable t) {
            throw (Throwable)new NotSerializableException("Unexpected throwable: " + t.getMessage() + ' ' + InternalUtilsKt.getStackTraceAsString((Throwable)t));
        }
        finally {
            this.objectHistory.clear();
        }
    }

    @NotNull
    public final <T> T deserialize(@NotNull ByteSequence bytes, @NotNull Class<T> clazz) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Object r = this.des((Function0)new Function0<T>(this, bytes, clazz){
            final /* synthetic */ DeserializationInput this$0;
            final /* synthetic */ ByteSequence $bytes;
            final /* synthetic */ Class $clazz;

            public final T invoke() {
                Envelope envelope = DeserializationInput.access$getEnvelope(this.this$0, this.$bytes);
                T t = this.$clazz.cast(this.this$0.readObjectOrNull$node_api_main(envelope.getObj(), envelope.getSchema(), this.$clazz));
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"clazz.cast(readObjectOrN\u2026 envelope.schema, clazz))");
                return t;
            }
            {
                this.this$0 = deserializationInput;
                this.$bytes = byteSequence;
                this.$clazz = clazz;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(r, (String)"des {\n        val envelo\u2026ope.schema, clazz))\n    }");
        return (T)r;
    }

    @NotNull
    public final <T> ObjectAndEnvelope<T> deserializeAndReturnEnvelope(@NotNull SerializedBytes<T> bytes, @NotNull Class<T> clazz) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull(bytes, (String)"bytes");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return (ObjectAndEnvelope)this.des((Function0)new Function0<ObjectAndEnvelope<? extends T>>(this, bytes, clazz){
            final /* synthetic */ DeserializationInput this$0;
            final /* synthetic */ SerializedBytes $bytes;
            final /* synthetic */ Class $clazz;

            @NotNull
            public final ObjectAndEnvelope<T> invoke() {
                Envelope envelope = DeserializationInput.access$getEnvelope(this.this$0, (ByteSequence)this.$bytes);
                return new ObjectAndEnvelope<T>(this.$clazz.cast(this.this$0.readObjectOrNull$node_api_main(envelope.getObj(), envelope.getSchema(), this.$clazz)), envelope);
            }
            {
                this.this$0 = deserializationInput;
                this.$bytes = serializedBytes;
                this.$clazz = clazz;
                super(0);
            }
        });
    }

    @Nullable
    public final Object readObjectOrNull$node_api_main(@Nullable Object obj, @NotNull Schema schema, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return obj == null ? null : this.readObject$node_api_main(obj, schema, type);
    }

    @NotNull
    public final Object readObject$node_api_main(@NotNull Object obj, @NotNull Schema schema, @NotNull Type type) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (obj instanceof DescribedType && Intrinsics.areEqual((Object)ReferencedObject.Companion.getDESCRIPTOR(), (Object)((DescribedType)obj).getDescriptor())) {
            Object object2 = ((DescribedType)obj).getDescribed();
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.apache.qpid.proton.amqp.UnsignedInteger");
            }
            int objectIndex = ((UnsignedInteger)object2).intValue();
            int n = objectIndex;
            if (0 > n || n > this.objectHistory.size()) {
                throw (Throwable)new NotSerializableException("Retrieval of existing reference failed. Requested index " + objectIndex + ' ' + "is outside of the bounds for the list of size: " + this.objectHistory.size());
            }
            Object objectRetrieved = this.objectHistory.get(objectIndex);
            Type type2 = objectRetrieved.getClass();
            Class<?> clazz = SerializationHelperKt.asClass(type);
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            if (!SerializationHelperKt.isSubClassOf(type2, clazz)) {
                throw (Throwable)new NotSerializableException("Existing reference type mismatch. Expected: '" + type + "', found: '" + objectRetrieved.getClass() + '\'');
            }
            object = objectRetrieved;
        } else {
            Object objectRead;
            Object object3;
            Object object4 = obj;
            if (object4 instanceof DescribedType) {
                Type type3;
                Type $receiver;
                Object object5 = ((DescribedType)obj).getDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"obj.descriptor");
                AMQPSerializer<Object> serializer2 = this.serializerFactory.get(object5, schema);
                if (Intrinsics.areEqual((Object)SerializerFactory.AnyType.INSTANCE, (Object)type) ^ true && Intrinsics.areEqual((Object)serializer2.getType(), (Object)type) ^ true && !SerializationHelperKt.isSubClassOf($receiver = (type3 = serializer2.getType()), type) && !this.materiallyEquivalentTo($receiver, type)) {
                    throw (Throwable)new NotSerializableException("Described type with descriptor " + ((DescribedType)obj).getDescriptor() + " was " + "expected to be of type " + type + " but was " + serializer2.getType());
                }
                Object object6 = ((DescribedType)obj).getDescribed();
                Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"obj.described");
                object3 = serializer2.readObject(object6, schema, this);
            } else {
                object3 = objectRead = object4 instanceof Binary ? (Object)((Binary)obj).getArray() : obj;
            }
            if (SerializationHelperKt.suitableForObjectReference(objectRead.getClass())) {
                Object object7 = objectRead;
                Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"objectRead");
                this.objectHistory.add(object7);
            }
            object = objectRead;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"if (obj is DescribedType\u2026 objectRead\n            }");
        return object;
    }

    private final boolean materiallyEquivalentTo(@NotNull Type $receiver, Type that) {
        return Intrinsics.areEqual(SerializationHelperKt.asClass($receiver), SerializationHelperKt.asClass(that)) && that instanceof ParameterizedType;
    }

    @NotNull
    public final SerializerFactory getSerializerFactory$node_api_main() {
        return this.serializerFactory;
    }

    public DeserializationInput(@NotNull SerializerFactory serializerFactory) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)serializerFactory, (String)"serializerFactory");
        this.serializerFactory = serializerFactory;
        DeserializationInput deserializationInput = this;
        deserializationInput.objectHistory = list = (List)new ArrayList();
    }

    static {
        BYTES_NEEDED_TO_PEEK = 23;
    }

    @NotNull
    public static final /* synthetic */ Envelope access$getEnvelope(DeserializationInput $this, @NotNull ByteSequence bytes) {
        return $this.getEnvelope(bytes);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/DeserializationInput$Companion;", "", "()V", "BYTES_NEEDED_TO_PEEK", "", "getBYTES_NEEDED_TO_PEEK", "()I", "peekSize", "bytes", "", "node-api_main"})
    public static final class Companion {
        private final int getBYTES_NEEDED_TO_PEEK() {
            return BYTES_NEEDED_TO_PEEK;
        }

        public final int peekSize(@NotNull byte[] bytes) {
            boolean $i$a$2$check;
            boolean $i$a$1$check;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            byte eighth = bytes[8];
            boolean bl2 = bl = eighth == 0;
            if (!bl) {
                String string = "Expected to find a descriptor in the AMQP stream";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int ninth = UnsignedByte.valueOf((byte)bytes[9]).intValue();
            boolean bl3 = $i$a$1$check = ninth == 128;
            if (!$i$a$1$check) {
                String string = "Expected to find a ulong in the AMQP stream";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int eighteenth = UnsignedByte.valueOf((byte)bytes[18]).intValue();
            boolean bl4 = $i$a$2$check = eighteenth == 208 || eighteenth == 192;
            if (!$i$a$2$check) {
                String string = "Expected to find a list8 or list32 in the AMQP stream";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int size = eighteenth == 192 ? UnsignedByte.valueOf((byte)bytes[19]).intValue() - 3 : (UnsignedByte.valueOf((byte)bytes[19]).intValue() << 24) + (UnsignedByte.valueOf((byte)bytes[20]).intValue() << 16) + (UnsignedByte.valueOf((byte)bytes[21]).intValue() << 8) + UnsignedByte.valueOf((byte)bytes[22]).intValue();
            return size + this.getBYTES_NEEDED_TO_PEEK();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

