/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.corda.nodeapi.internal.serialization.amqp.AMQPSerializer;
import net.corda.nodeapi.internal.serialization.amqp.Choice;
import net.corda.nodeapi.internal.serialization.amqp.Descriptor;
import net.corda.nodeapi.internal.serialization.amqp.DeserializationInput;
import net.corda.nodeapi.internal.serialization.amqp.EnumSerializer;
import net.corda.nodeapi.internal.serialization.amqp.RestrictedType;
import net.corda.nodeapi.internal.serialization.amqp.Schema;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationHelperKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationOutput;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.TypeNotation;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\n\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/EnumSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/AMQPSerializer;", "", "declaredType", "Ljava/lang/reflect/Type;", "declaredClass", "Ljava/lang/Class;", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Ljava/lang/reflect/Type;Ljava/lang/Class;Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "type", "getType", "()Ljava/lang/reflect/Type;", "typeDescriptor", "Lorg/apache/qpid/proton/amqp/Symbol;", "getTypeDescriptor", "()Lorg/apache/qpid/proton/amqp/Symbol;", "typeNotation", "Lnet/corda/nodeapi/internal/serialization/amqp/TypeNotation;", "readObject", "obj", "schema", "Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "input", "Lnet/corda/nodeapi/internal/serialization/amqp/DeserializationInput;", "writeClassInfo", "", "output", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializationOutput;", "writeObject", "data", "Lorg/apache/qpid/proton/codec/Data;", "node-api_main"})
public final class EnumSerializer
implements AMQPSerializer<Object> {
    @NotNull
    private final Type type;
    @NotNull
    private final Symbol typeDescriptor;
    private final TypeNotation typeNotation;

    @Override
    @NotNull
    public Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Symbol getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    public void writeClassInfo(@NotNull SerializationOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        output.writeTypeNotations$node_api_main(this.typeNotation);
    }

    @Override
    @NotNull
    public Object readObject(@NotNull Object obj, @NotNull Schema schema, @NotNull DeserializationInput input) {
        Object fromOrd;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Object e = ((List)obj).get(0);
        if (e == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String enumName = (String)e;
        Object e2 = ((List)obj).get(1);
        if (e2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int enumOrd = (Integer)e2;
        Class<?> clazz = SerializationHelperKt.asClass(this.getType());
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Object obj2 = fromOrd = clazz.getEnumConstants()[enumOrd];
        if (Intrinsics.areEqual((Object)enumName, (Object)(obj2 != null ? obj2.toString() : null)) ^ true) {
            throw (Throwable)new NotSerializableException("Deserializing obj as enum " + this.getType() + " with value " + enumName + '.' + enumOrd + " but " + "ordinality has changed");
        }
        return fromOrd;
    }

    @Override
    public void writeObject(@NotNull Object obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (!(obj instanceof Enum)) {
            throw (Throwable)new NotSerializableException("Serializing " + obj + " as enum when it isn't");
        }
        SerializationHelperKt.withDescribed(data, this.typeNotation.getDescriptor(), (Function1<? super Data, Unit>)((Function1)new Function1<Data, Unit>(data, obj){
            final /* synthetic */ Data $data;
            final /* synthetic */ Object $obj;

            public final void invoke(@NotNull Data $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                SerializationHelperKt.withList($receiver, (Function1<? super Data, Unit>)((Function1)new Function1<Data, Unit>(this){
                    final /* synthetic */ writeObject.1 this$0;

                    public final void invoke(@NotNull Data $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        this.this$0.$data.putString(((Enum)this.this$0.$obj).name());
                        this.this$0.$data.putInt(((Enum)this.this$0.$obj).ordinal());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$data = data;
                this.$obj = object;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public EnumSerializer(@NotNull Type declaredType, @NotNull Class<?> declaredClass, @NotNull SerializerFactory factory) {
        Collection<Choice> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        RestrictedType restrictedType;
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        Intrinsics.checkParameterIsNotNull(declaredClass, (String)"declaredClass");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        this.type = declaredType;
        Symbol symbol = Symbol.valueOf((String)("net.corda:" + SchemaKt.fingerprintForType(this.getType(), factory)));
        if (symbol == null) {
            Intrinsics.throwNpe();
        }
        this.typeDescriptor = symbol;
        Iterable iterable = ArraysKt.zip((Object[])declaredClass.getEnumConstants(), (Iterable)((Iterable)new IntRange(0, declaredClass.getEnumConstants().length)));
        Descriptor descriptor = new Descriptor(this.getTypeDescriptor(), null, 2, null);
        String string = "list";
        List list = CollectionsKt.emptyList();
        String string2 = null;
        String string3 = SerializerFactory.Companion.nameForType(declaredType);
        RestrictedType restrictedType2 = restrictedType;
        RestrictedType restrictedType3 = restrictedType;
        EnumSerializer enumSerializer = this;
        void var5_13 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            Choice choice = new Choice(it.getFirst().toString(), String.valueOf(((Number)it.getSecond()).intValue()));
            collection.add(choice);
        }
        collection = (List)destination$iv$iv;
        restrictedType2(string3, string2, list, string, descriptor, (List<Choice>)collection);
        enumSerializer.typeNotation = restrictedType3;
    }
}

