/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.NotSerializableException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import net.corda.core.utilities.EncodingUtils;
import net.corda.core.utilities.OpaqueBytes;
import net.corda.nodeapi.internal.serialization.amqp.AMQPSerializer;
import net.corda.nodeapi.internal.serialization.amqp.PropertySerializer;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationHelperKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0016\u001a\u00020\u00012\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0018\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002\u001a8\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u0018\u0010$\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u0014\u0010%\u001a\u00020&2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030'H\u0002\u001a6\u0010(\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010*\u001a\u00020\u001d2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0,H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"ALREADY_SEEN_HASH", "", "ANY_TYPE_HASH", "ARRAY_HASH", "AmqpHeaderV1_0", "Lnet/corda/core/utilities/OpaqueBytes;", "getAmqpHeaderV1_0", "()Lnet/corda/core/utilities/OpaqueBytes;", "DESCRIPTOR_DOMAIN", "DESCRIPTOR_TOP_32BITS", "", "ENUM_HASH", "NOT_NULLABLE_HASH", "NULLABLE_HASH", "TYPE_VARIABLE_HASH", "WILDCARD_TYPE_HASH", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "fingerprintForDescriptors", "typeDescriptors", "", "([Ljava/lang/String;)Ljava/lang/String;", "fingerprintForObject", "Lcom/google/common/hash/Hasher;", "type", "Ljava/lang/reflect/Type;", "contextType", "alreadySeen", "", "hasher", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "fingerprintForType", "isCollectionOrMap", "", "Ljava/lang/Class;", "fingerprintWithCustomSerializerOrElse", "clazz", "declaredType", "block", "Lkotlin/Function0;", "node-api_main"})
public final class SchemaKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final long DESCRIPTOR_TOP_32BITS = 3235512320L;
    @NotNull
    public static final String DESCRIPTOR_DOMAIN = "net.corda";
    @NotNull
    private static final OpaqueBytes AmqpHeaderV1_0;
    private static final String ARRAY_HASH = "Array = true";
    private static final String ENUM_HASH = "Enum = true";
    private static final String ALREADY_SEEN_HASH = "Already seen = true";
    private static final String NULLABLE_HASH = "Nullable = true";
    private static final String NOT_NULLABLE_HASH = "Nullable = false";
    private static final String ANY_TYPE_HASH = "Any type = true";
    private static final String TYPE_VARIABLE_HASH = "Type variable = true";
    private static final String WILDCARD_TYPE_HASH = "Wild card = true";
    private static final Lazy logger$delegate;

    static {
        OpaqueBytes opaqueBytes;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(SchemaKt.class, (String)"node-api_main"), "logger", "getLogger()Lorg/slf4j/Logger;"))};
        String string = "corda\u0001\u0000\u0000";
        OpaqueBytes opaqueBytes2 = opaqueBytes;
        OpaqueBytes opaqueBytes3 = opaqueBytes;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        opaqueBytes2(byArray2);
        AmqpHeaderV1_0 = opaqueBytes3;
        ARRAY_HASH = ARRAY_HASH;
        ENUM_HASH = ENUM_HASH;
        ALREADY_SEEN_HASH = ALREADY_SEEN_HASH;
        NULLABLE_HASH = NULLABLE_HASH;
        NOT_NULLABLE_HASH = NOT_NULLABLE_HASH;
        ANY_TYPE_HASH = ANY_TYPE_HASH;
        TYPE_VARIABLE_HASH = TYPE_VARIABLE_HASH;
        WILDCARD_TYPE_HASH = WILDCARD_TYPE_HASH;
        logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    }

    @NotNull
    public static final OpaqueBytes getAmqpHeaderV1_0() {
        return AmqpHeaderV1_0;
    }

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (Logger)lazy.getValue();
    }

    @NotNull
    public static final String fingerprintForType(@NotNull Type type, @NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Set set = new HashSet();
        Hasher hasher = Hashing.murmur3_128().newHasher();
        Intrinsics.checkExpressionValueIsNotNull((Object)hasher, (String)"Hashing.murmur3_128().newHasher()");
        return EncodingUtils.toBase64((byte[])SchemaKt.fingerprintForType(type, null, set, hasher, factory).hash().asBytes());
    }

    @NotNull
    public static final String fingerprintForDescriptors(String ... typeDescriptors) {
        Intrinsics.checkParameterIsNotNull((Object)typeDescriptors, (String)"typeDescriptors");
        Hasher hasher = Hashing.murmur3_128().newHasher();
        for (int i = 0; i < typeDescriptors.length; ++i) {
            String typeDescriptor2 = typeDescriptors[i];
            hasher.putUnencodedChars((CharSequence)typeDescriptor2);
        }
        return EncodingUtils.toBase64((byte[])hasher.hash().asBytes());
    }

    private static final Hasher fingerprintWithCustomSerializerOrElse(@NotNull Hasher $receiver, SerializerFactory factory, Class<?> clazz, Type declaredType, Function0<? extends Hasher> block) {
        Hasher hasher;
        AMQPSerializer<Object> customSerializer = factory.findCustomSerializer$node_api_main(clazz, declaredType);
        if (customSerializer != null) {
            Hasher hasher2 = $receiver.putUnencodedChars((CharSequence)customSerializer.getTypeDescriptor());
            hasher = hasher2;
            Intrinsics.checkExpressionValueIsNotNull((Object)hasher2, (String)"putUnencodedChars(customSerializer.typeDescriptor)");
        } else {
            hasher = (Hasher)block.invoke();
        }
        return hasher;
    }

    /*
     * WARNING - void declaration
     */
    private static final Hasher fingerprintForType(Type type, Type contextType, Set<Type> alreadySeen, Hasher hasher, SerializerFactory factory) {
        Object object;
        if (alreadySeen.contains(type)) {
            Hasher hasher2 = hasher.putUnencodedChars((CharSequence)ALREADY_SEEN_HASH);
            object = hasher2;
            Intrinsics.checkExpressionValueIsNotNull((Object)hasher2, (String)"hasher.putUnencodedChars(ALREADY_SEEN_HASH)");
        } else {
            Object object2 = alreadySeen;
            object2.add(type);
            try {
                Object[] $receiver$iv;
                Hasher hasher3;
                object2 = type;
                if (object2 instanceof SerializerFactory.AnyType) {
                    hasher3 = hasher.putUnencodedChars((CharSequence)ANY_TYPE_HASH);
                } else if (object2 instanceof Class) {
                    if (((Class)type).isArray()) {
                        Class<?> clazz = ((Class)type).getComponentType();
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.componentType");
                        hasher3 = SchemaKt.fingerprintForType(clazz, contextType, alreadySeen, hasher, factory).putUnencodedChars((CharSequence)ARRAY_HASH);
                    } else if (SerializerFactory.Companion.isPrimitive(type)) {
                        hasher3 = hasher.putUnencodedChars((CharSequence)((Class)type).getName());
                    } else if (SchemaKt.isCollectionOrMap((Class)type)) {
                        hasher3 = hasher.putUnencodedChars((CharSequence)((Class)type).getName());
                    } else if (((Class)type).isEnum()) {
                        Hasher hasher4;
                        Hasher $receiver = hasher4 = hasher;
                        $receiver$iv = ((Class)type).getEnumConstants();
                        for (int i = 0; i < $receiver$iv.length; ++i) {
                            Object element$iv;
                            Object it = element$iv = $receiver$iv[i];
                            $receiver.putUnencodedChars((CharSequence)it.toString());
                        }
                        hasher3 = hasher4.putUnencodedChars((CharSequence)((Class)type).getName()).putUnencodedChars((CharSequence)ENUM_HASH);
                    } else {
                        hasher3 = SchemaKt.fingerprintWithCustomSerializerOrElse(hasher, factory, (Class)type, type, (Function0<? extends Hasher>)((Function0)new Function0<Hasher>(type, hasher, alreadySeen, factory){
                            final /* synthetic */ Type $type;
                            final /* synthetic */ Hasher $hasher;
                            final /* synthetic */ Set $alreadySeen;
                            final /* synthetic */ SerializerFactory $factory;

                            @NotNull
                            public final Hasher invoke() {
                                Hasher hasher;
                                if (JvmClassMappingKt.getKotlinClass((Class)((Class)this.$type)).getObjectInstance() != null) {
                                    Hasher hasher2 = this.$hasher.putUnencodedChars((CharSequence)((Class)this.$type).getName());
                                    hasher = hasher2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)hasher2, (String)"hasher.putUnencodedChars(type.name)");
                                } else {
                                    hasher = SchemaKt.access$fingerprintForObject(this.$type, this.$type, this.$alreadySeen, this.$hasher, this.$factory);
                                }
                                return hasher;
                            }
                            {
                                this.$type = type;
                                this.$hasher = hasher;
                                this.$alreadySeen = set;
                                this.$factory = serializerFactory;
                                super(0);
                            }
                        }));
                    }
                } else if (object2 instanceof ParameterizedType) {
                    Type type2 = ((ParameterizedType)type).getRawType();
                    if (type2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    Class clazz = (Class)type2;
                    Hasher startingHash2 = SchemaKt.isCollectionOrMap(clazz) ? hasher.putUnencodedChars((CharSequence)clazz.getName()) : SchemaKt.fingerprintWithCustomSerializerOrElse(hasher, factory, clazz, type, (Function0<? extends Hasher>)((Function0)new Function0<Hasher>(type, alreadySeen, hasher, factory){
                        final /* synthetic */ Type $type;
                        final /* synthetic */ Set $alreadySeen;
                        final /* synthetic */ Hasher $hasher;
                        final /* synthetic */ SerializerFactory $factory;

                        @NotNull
                        public final Hasher invoke() {
                            return SchemaKt.access$fingerprintForObject(this.$type, this.$type, this.$alreadySeen, this.$hasher, this.$factory);
                        }
                        {
                            this.$type = type;
                            this.$alreadySeen = set;
                            this.$hasher = hasher;
                            this.$factory = serializerFactory;
                            super(0);
                        }
                    }));
                    $receiver$iv = ((ParameterizedType)type).getActualTypeArguments();
                    Hasher accumulator$iv = startingHash2;
                    for (int i = 0; i < $receiver$iv.length; ++i) {
                        void paramType;
                        Object element$iv = $receiver$iv[i];
                        Type $i$a$1$forEach = (Type)element$iv;
                        Hasher orig = accumulator$iv;
                        void v5 = paramType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"paramType");
                        Hasher hasher5 = orig;
                        Intrinsics.checkExpressionValueIsNotNull((Object)hasher5, (String)"orig");
                        accumulator$iv = SchemaKt.fingerprintForType((Type)v5, type, alreadySeen, hasher5, factory);
                    }
                    hasher3 = accumulator$iv;
                } else if (object2 instanceof GenericArrayType) {
                    Type type3 = ((GenericArrayType)type).getGenericComponentType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.genericComponentType");
                    hasher3 = SchemaKt.fingerprintForType(type3, contextType, alreadySeen, hasher, factory).putUnencodedChars((CharSequence)ARRAY_HASH);
                } else if (object2 instanceof TypeVariable) {
                    hasher3 = hasher.putUnencodedChars((CharSequence)((TypeVariable)type).getName()).putUnencodedChars((CharSequence)TYPE_VARIABLE_HASH);
                } else if (object2 instanceof WildcardType) {
                    hasher3 = hasher.putUnencodedChars((CharSequence)((WildcardType)type).getTypeName()).putUnencodedChars((CharSequence)WILDCARD_TYPE_HASH);
                } else {
                    throw (Throwable)new NotSerializableException("Don't know how to hash");
                }
                object2 = hasher3;
            }
            catch (NotSerializableException e) {
                String msg = "" + e.getMessage() + " -> " + type;
                SchemaKt.getLogger().error(msg, (Throwable)e);
                throw (Throwable)new NotSerializableException(msg);
            }
            Object object3 = object2;
            object = object3;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"try {\n            when (\u2026eException(msg)\n        }");
        }
        return object;
    }

    private static final boolean isCollectionOrMap(Class<?> type) {
        return (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) && !EnumSet.class.isAssignableFrom(type);
    }

    /*
     * WARNING - void declaration
     */
    private static final Hasher fingerprintForObject(Type type, Type contextType, Set<Type> alreadySeen, Hasher hasher, SerializerFactory factory) {
        void $receiver$iv$iv;
        Type prop;
        Iterable $receiver$iv;
        Object initial$iv;
        Class<?> clazz = SerializationHelperKt.asClass(type);
        if (clazz == null || (clazz = clazz.getName()) == null) {
            throw (Throwable)new NotSerializableException("Expected only Class or ParameterizedType but found " + type);
        }
        Class<?> name = clazz;
        KFunction<Object> kFunction = SerializationHelperKt.constructorForDeserialization(type);
        Type type2 = contextType;
        if (type2 == null) {
            type2 = type;
        }
        Iterable iterable = SerializationHelperKt.propertiesForSerialization(kFunction, type2, factory);
        Hasher accumulator$iv = initial$iv = hasher.putUnencodedChars((CharSequence)((Object)name));
        for (Object element$iv : $receiver$iv) {
            PropertySerializer propertySerializer = (PropertySerializer)element$iv;
            Hasher orig = accumulator$iv;
            Type type3 = ((PropertySerializer)((Object)prop)).getResolvedType();
            Hasher hasher2 = orig;
            Intrinsics.checkExpressionValueIsNotNull((Object)hasher2, (String)"orig");
            accumulator$iv = SchemaKt.fingerprintForType(type3, type, alreadySeen, hasher2, factory).putUnencodedChars((CharSequence)((PropertySerializer)((Object)prop)).getName()).putUnencodedChars((CharSequence)(((PropertySerializer)((Object)prop)).getMandatory() ? NOT_NULLABLE_HASH : NULLABLE_HASH));
        }
        $receiver$iv = SerializationHelperKt.interfacesForSerialization(type, factory);
        initial$iv = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            prop = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            Hasher hasher3 = SchemaKt.fingerprintForType((Type)it, type, alreadySeen, hasher, factory);
            collection.add(hasher3);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return hasher;
    }

    @NotNull
    public static final /* synthetic */ Hasher access$fingerprintForObject(@NotNull Type type, @Nullable Type contextType, @NotNull Set alreadySeen, @NotNull Hasher hasher, @NotNull SerializerFactory factory) {
        return SchemaKt.fingerprintForObject(type, contextType, alreadySeen, hasher, factory);
    }
}

