/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp;

import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.NotSerializableException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import net.corda.nodeapi.internal.serialization.amqp.ConstructorForDeserialization;
import net.corda.nodeapi.internal.serialization.amqp.Descriptor;
import net.corda.nodeapi.internal.serialization.amqp.DeserializedGenericArrayType;
import net.corda.nodeapi.internal.serialization.amqp.DeserializedParameterizedType;
import net.corda.nodeapi.internal.serialization.amqp.PropertySerializer;
import net.corda.nodeapi.internal.serialization.amqp.ReferencedObject;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000b\u001a\u00020\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0012\u0010\u0013\u001a\u00020\u00062\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015\u001a8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\"\b\b\u0000\u0010\u0019*\u00020\u00022\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0010H\u0000\u001a*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0010H\u0002\u001a6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\"\b\b\u0000\u0010\u0019*\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002\u001a\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0015*\u0006\u0012\u0002\b\u00030\u0015H\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0000\u001a\u0012\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015*\u00020\u0004H\u0000\u001a\u0010\u0010%\u001a\u00020&*\u0006\u0012\u0002\b\u00030\u0015H\u0000\u001a\f\u0010%\u001a\u00020&*\u00020\u0004H\u0000\u001a\f\u0010'\u001a\u00020\u0004*\u00020\u0004H\u0000\u001a\f\u0010(\u001a\u00020\u0006*\u00020\u0004H\u0000\u001a\u0014\u0010)\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a+\u0010*\u001a\u00020\f*\u00020+2\u0006\u0010,\u001a\u00020-2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\f0/\u00a2\u0006\u0002\b0\u001a#\u00101\u001a\u00020\f*\u00020+2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\f0/\u00a2\u0006\u0002\b0\u001a\u0012\u00102\u001a\u00020\f*\u00020+2\u0006\u00103\u001a\u000204\u00a8\u00065"}, d2={"constructorForDeserialization", "Lkotlin/reflect/KFunction;", "", "type", "Ljava/lang/reflect/Type;", "constructorParamTakesReturnTypeOfGetter", "", "getterReturnType", "rawGetterReturnType", "param", "Lkotlin/reflect/KParameter;", "exploreType", "", "interfaces", "", "serializerFactory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "interfacesForSerialization", "", "isConcrete", "clazz", "Ljava/lang/Class;", "propertiesForSerialization", "", "Lnet/corda/nodeapi/internal/serialization/amqp/PropertySerializer;", "T", "kotlinConstructor", "factory", "propertiesForSerializationFromAbstract", "propertiesForSerializationFromConstructor", "resolveTypeVariables", "actualType", "contextType", "suitableForObjectReference", "arrayClass", "asArray", "asClass", "asParameterizedType", "Ljava/lang/reflect/ParameterizedType;", "componentType", "isArray", "isSubClassOf", "withDescribed", "Lorg/apache/qpid/proton/codec/Data;", "descriptor", "Lnet/corda/nodeapi/internal/serialization/amqp/Descriptor;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withList", "writeReferencedObject", "refObject", "Lnet/corda/nodeapi/internal/serialization/amqp/ReferencedObject;", "node-api_main"})
public final class SerializationHelperKt {
    @Nullable
    public static final KFunction<Object> constructorForDeserialization(@NotNull Type type) {
        block12: {
            KFunction kFunction;
            block14: {
                Class<?> clazz;
                block13: {
                    KFunction kFunction2;
                    boolean bl;
                    Collection kotlinConstructors;
                    int annotatedCount;
                    KFunction preferredCandidate;
                    block10: {
                        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                        Class<?> clazz2 = SerializationHelperKt.asClass(type);
                        if (clazz2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!SerializationHelperKt.isConcrete(clazz = clazz2)) break block12;
                        preferredCandidate = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(clazz));
                        annotatedCount = 0;
                        kotlinConstructors = JvmClassMappingKt.getKotlinClass(clazz).getConstructors();
                        Iterable $receiver$iv = kotlinConstructors;
                        for (Object element$iv : $receiver$iv) {
                            KFunction it = (KFunction)element$iv;
                            if (!it.getParameters().isEmpty()) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                    boolean hasDefault = bl;
                    for (KFunction kotlinConstructor : kotlinConstructors) {
                        Object v2;
                        block11: {
                            Object element$iv;
                            if (preferredCandidate == null && kotlinConstructors.size() == 1) {
                                preferredCandidate = kotlinConstructor;
                                continue;
                            }
                            if (preferredCandidate == null && kotlinConstructors.size() == 2 && hasDefault && !(element$iv = (Collection)kotlinConstructor.getParameters()).isEmpty()) {
                                preferredCandidate = kotlinConstructor;
                                continue;
                            }
                            KAnnotatedElement $receiver$iv = (KAnnotatedElement)kotlinConstructor;
                            Iterable $receiver$iv$iv = $receiver$iv.getAnnotations();
                            for (Object element$iv$iv : $receiver$iv$iv) {
                                Annotation it$iv = (Annotation)element$iv$iv;
                                if (!(it$iv instanceof ConstructorForDeserialization)) continue;
                                v2 = element$iv$iv;
                                break block11;
                            }
                            v2 = null;
                        }
                        if ((ConstructorForDeserialization)v2 == null) continue;
                        if (annotatedCount++ > 0) {
                            throw (Throwable)new NotSerializableException("More than one constructor for " + clazz + " is annotated with @CordaConstructor.");
                        }
                        preferredCandidate = kotlinConstructor;
                    }
                    kFunction = preferredCandidate;
                    if (kFunction == null) break block13;
                    KFunction $receiver = kFunction2 = kFunction;
                    KCallablesJvm.setAccessible((KCallable)((KCallable)$receiver), (boolean)true);
                    kFunction = kFunction2;
                    if (kFunction != null) break block14;
                }
                throw (Throwable)new NotSerializableException("No constructor for deserialization found for " + clazz + '.');
            }
            return kFunction;
        }
        return null;
    }

    @NotNull
    public static final <T> Collection<PropertySerializer> propertiesForSerialization(@Nullable KFunction<? extends T> kotlinConstructor, @NotNull Type type, @NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Class<?> clazz = SerializationHelperKt.asClass(type);
        if (clazz == null) {
            Intrinsics.throwNpe();
        }
        Class<?> clazz2 = clazz;
        return kotlinConstructor != null ? SerializationHelperKt.propertiesForSerializationFromConstructor(kotlinConstructor, type, factory) : SerializationHelperKt.propertiesForSerializationFromAbstract(clazz2, type, factory);
    }

    public static final boolean isConcrete(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Collection<PropertySerializer> propertiesForSerializationFromConstructor(KFunction<? extends T> kotlinConstructor, Type type, SerializerFactory factory) {
        Object object;
        Object object2;
        Object value$iv$iv$iv;
        PropertyDescriptor it;
        Object element$iv$iv;
        Object $receiver$iv$iv;
        KClassifier kClassifier = kotlinConstructor.getReturnType().getClassifier();
        if (kClassifier == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<*>");
        }
        Class clazz = JvmClassMappingKt.getJavaObjectType((KClass)((KClass)kClassifier));
        Object $receiver$iv = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        Object[] objectArray = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            element$iv$iv = $receiver$iv$iv[i];
            it = (PropertyDescriptor)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"class") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator.next();
            it = (PropertyDescriptor)element$iv$iv;
            String key$iv$iv = it.getName();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            Map.Entry $i$a$2$groupBy = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv;
            object = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = object;
            Object object4 = object2;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)((List)it2.getValue()).get(0);
            object4.put(k, propertyDescriptor);
        }
        Object properties = destination$iv$iv;
        List rc = new ArrayList(kotlinConstructor.getParameters().size());
        for (KParameter param : kotlinConstructor.getParameters()) {
            Method getter;
            PropertyDescriptor matchingProperty;
            String name;
            if (param.getName() == null) {
                throw (Throwable)new NotSerializableException("Constructor parameter of " + clazz + " has no name.");
            }
            if ((PropertyDescriptor)properties.get(name) == null) {
                throw (Throwable)new NotSerializableException("No property matching constructor parameter named " + name + " of " + clazz + '.' + " If using Java, check that you have the -parameters option specified in the Java compiler.");
            }
            if (matchingProperty.getReadMethod() == null) {
                throw (Throwable)new NotSerializableException("Property has no getter method for " + name + " of " + clazz + '.' + " If using Java and the parameter name looks anonymous, check that you have the -parameters option specified in the Java compiler.");
            }
            Type type2 = getter.getGenericReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"getter.genericReturnType");
            Type returnType = SerializationHelperKt.resolveTypeVariables(type2, type);
            Type type3 = getter.getGenericReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"getter.genericReturnType");
            if (SerializationHelperKt.constructorParamTakesReturnTypeOfGetter(returnType, type3, param)) {
                object2 = rc;
                object = PropertySerializer.Companion.make(name, getter, returnType, factory);
                object2.add(object);
                continue;
            }
            throw (Throwable)new NotSerializableException("Property type " + returnType + " for " + name + " of " + clazz + " differs from constructor parameter type " + ReflectJvmMapping.getJavaType((KType)param.getType()));
        }
        return rc;
    }

    private static final boolean constructorParamTakesReturnTypeOfGetter(Type getterReturnType, Type rawGetterReturnType, KParameter param) {
        TypeToken typeToken = TypeToken.of((Type)ReflectJvmMapping.getJavaType((KType)param.getType()));
        return typeToken.isSupertypeOf(getterReturnType) || typeToken.isSupertypeOf(rawGetterReturnType);
    }

    private static final Collection<PropertySerializer> propertiesForSerializationFromAbstract(Class<?> clazz, Type type, SerializerFactory factory) {
        PropertyDescriptor it;
        Object element$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv;
        Object[] objectArray = $receiver$iv = (Object[])Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        Object destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            element$iv$iv = $receiver$iv$iv[i];
            it = (PropertyDescriptor)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"class") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                PropertyDescriptor it = (PropertyDescriptor)a;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (PropertyDescriptor)b;
                Comparable comparable2 = comparable;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        $receiver$iv = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterator $i$f$sortedBy = $receiver$iv$iv.iterator();
        while ($i$f$sortedBy.hasNext()) {
            element$iv$iv = $i$f$sortedBy.next();
            it = (PropertyDescriptor)element$iv$iv;
            if (it instanceof IndexedPropertyDescriptor) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        List rc = new ArrayList(properties.size());
        for (PropertyDescriptor property : properties) {
            Method getter;
            if (property.getReadMethod() == null) {
                throw (Throwable)new NotSerializableException("Property has no getter method for " + property.getName() + " of " + clazz + '.');
            }
            Type type2 = getter.getGenericReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"getter.genericReturnType");
            Type returnType = SerializationHelperKt.resolveTypeVariables(type2, type);
            Collection collection = rc;
            String string = property.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name");
            PropertySerializer propertySerializer = PropertySerializer.Companion.make(string, getter, returnType, factory);
            collection.add(propertySerializer);
        }
        return rc;
    }

    @NotNull
    public static final List<Type> interfacesForSerialization(@NotNull Type type, @NotNull SerializerFactory serializerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)serializerFactory, (String)"serializerFactory");
        LinkedHashSet interfaces = new LinkedHashSet();
        SerializationHelperKt.exploreType(type, interfaces, serializerFactory);
        return CollectionsKt.toList((Iterable)interfaces);
    }

    private static final void exploreType(Type type, Set<Type> interfaces, SerializerFactory serializerFactory) {
        Class<?> clazz;
        Type type2 = type;
        Class<Object> clazz2 = clazz = type2 != null ? SerializationHelperKt.asClass(type2) : null;
        if (clazz != null) {
            if (clazz.isInterface()) {
                if (serializerFactory.isNotWhitelisted$node_api_main(clazz)) {
                    return;
                }
                Collection collection = interfaces;
                collection.add(type);
            }
            Type[] typeArray = clazz.getGenericInterfaces();
            for (int i = 0; i < typeArray.length; ++i) {
                Type newInterface = typeArray[i];
                if (!(interfaces.contains(newInterface) ^ true)) continue;
                Type type3 = newInterface;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"newInterface");
                SerializationHelperKt.exploreType(SerializationHelperKt.resolveTypeVariables(type3, type), interfaces, serializerFactory);
            }
            Type type4 = clazz.getGenericSuperclass();
            if (type4 == null) {
                return;
            }
            Type superClass = type4;
            SerializationHelperKt.exploreType(SerializationHelperKt.resolveTypeVariables(superClass, type), interfaces, serializerFactory);
        }
    }

    public static final void withDescribed(@NotNull Data $receiver, @NotNull Descriptor descriptor, @NotNull Function1<? super Data, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.putDescribed();
        $receiver.enter();
        UnsignedLong unsignedLong = descriptor.getCode();
        if (unsignedLong == null) {
            unsignedLong = descriptor.getName();
        }
        $receiver.putObject((Object)unsignedLong);
        block.invoke((Object)$receiver);
        $receiver.exit();
    }

    public static final void withList(@NotNull Data $receiver, @NotNull Function1<? super Data, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $receiver.putList();
        $receiver.enter();
        block.invoke((Object)$receiver);
        $receiver.exit();
    }

    public static final void writeReferencedObject(@NotNull Data $receiver, @NotNull ReferencedObject refObject) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)refObject, (String)"refObject");
        $receiver.putDescribed();
        $receiver.enter();
        $receiver.putObject(refObject.getDescriptor());
        $receiver.putUnsignedInteger(refObject.getDescribed());
        $receiver.exit();
    }

    private static final Type resolveTypeVariables(Type actualType, Type contextType) {
        Type resolvedType;
        Type type = resolvedType = contextType != null ? TypeToken.of((Type)contextType).resolveType(actualType).getType() : actualType;
        if (resolvedType instanceof TypeVariable) {
            Type type2;
            Type[] bounds = ((TypeVariable)resolvedType).getBounds();
            Object[] objectArray = bounds;
            if (objectArray.length == 0) {
                type2 = SerializerFactory.AnyType.INSTANCE;
            } else if (((Object[])bounds).length == 1) {
                Type type3 = bounds[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"bounds[0]");
                type2 = SerializationHelperKt.resolveTypeVariables(type3, contextType);
            } else {
                throw (Throwable)new NotSerializableException("Got bounded type " + actualType + " but only support single bound.");
            }
            return type2;
        }
        Type type4 = resolvedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"resolvedType");
        return type4;
    }

    @Nullable
    public static final Class<?> asClass(@NotNull Type $receiver) {
        Class<Object> clazz;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof Class) {
            clazz = (Class<?>)$receiver;
        } else if ($receiver instanceof ParameterizedType) {
            clazz = SerializationHelperKt.asClass(((ParameterizedType)$receiver).getRawType());
        } else if ($receiver instanceof GenericArrayType) {
            Class<?> clazz2 = SerializationHelperKt.asClass(((GenericArrayType)$receiver).getGenericComponentType());
            clazz = clazz2 != null ? SerializationHelperKt.arrayClass(clazz2) : null;
        } else {
            clazz = null;
        }
        return clazz;
    }

    @Nullable
    public static final Type asArray(@NotNull Type $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof Class ? (Type)SerializationHelperKt.arrayClass((Class)$receiver) : ($receiver instanceof ParameterizedType ? (Type)new DeserializedGenericArrayType($receiver) : null);
    }

    @NotNull
    public static final Class<?> arrayClass(@NotNull Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return Array.newInstance($receiver, 0).getClass();
    }

    public static final boolean isArray(@NotNull Type $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof Class && ((Class)$receiver).isArray() || $receiver instanceof GenericArrayType;
    }

    @NotNull
    public static final Type componentType(@NotNull Type $receiver) {
        Type type;
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = SerializationHelperKt.isArray($receiver);
        if (!bl) {
            String string = "" + $receiver + " is not an array type.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Type type2 = $receiver;
        if (!(type2 instanceof Class)) {
            type2 = null;
        }
        if ((clazz = (Class<?>)type2) != null && (clazz = clazz.getComponentType()) != null) {
            type = clazz;
        } else {
            Type type3 = ((GenericArrayType)$receiver).getGenericComponentType();
            type = type3;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"(this as GenericArrayType).genericComponentType");
        }
        return type;
    }

    @NotNull
    public static final ParameterizedType asParameterizedType(@NotNull Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        TypeVariable<Class<?>>[] typeVariableArray = $receiver.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"this.typeParameters");
        return new DeserializedParameterizedType($receiver, typeVariableArray, null, 4, null);
    }

    @NotNull
    public static final ParameterizedType asParameterizedType(@NotNull Type $receiver) {
        ParameterizedType parameterizedType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Type type = $receiver;
        if (type instanceof Class) {
            parameterizedType = SerializationHelperKt.asParameterizedType((Class)$receiver);
        } else if (type instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)$receiver;
        } else {
            throw (Throwable)new NotSerializableException("Don't know how to convert to ParameterizedType");
        }
        return parameterizedType;
    }

    public static final boolean isSubClassOf(@NotNull Type $receiver, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return TypeToken.of((Type)$receiver).isSubtypeOf(type);
    }

    public static final boolean suitableForObjectReference(@NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Class<?> clazz = SerializationHelperKt.asClass(type);
        return Intrinsics.areEqual((Object)type, byte[].class) ^ true && clazz != null && !clazz.isPrimitive() && !Primitives.unwrap(clazz).isPrimitive();
    }
}

