/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp;

import java.io.NotSerializableException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.SerializedBytes;
import net.corda.nodeapi.internal.serialization.amqp.AMQPSerializer;
import net.corda.nodeapi.internal.serialization.amqp.Envelope;
import net.corda.nodeapi.internal.serialization.amqp.ReferencedObject;
import net.corda.nodeapi.internal.serialization.amqp.Schema;
import net.corda.nodeapi.internal.serialization.amqp.SchemaKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationHelperKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializationOutput;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.TypeNotation;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u0002H\u0013H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b\u001dJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u0002H\u0013H\u0007\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J%\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\"J'\u0010#\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b$J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!H\u0016J#\u0010(\u001a\u00020)2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0+\"\u00020\nH\u0010\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/SerializationOutput;", "", "serializerFactory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "objectHistory", "", "", "schemaHistory", "", "Lnet/corda/nodeapi/internal/serialization/amqp/TypeNotation;", "getSchemaHistory$node_api_main", "()Ljava/util/Set;", "getSerializerFactory$node_api_main", "()Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "serializerHistory", "Lnet/corda/nodeapi/internal/serialization/amqp/AMQPSerializer;", "_serialize", "Lnet/corda/core/serialization/SerializedBytes;", "T", "obj", "_serialize$node_api_main", "(Ljava/lang/Object;)Lnet/corda/core/serialization/SerializedBytes;", "andFinally", "", "andFinally$node_api_main", "requireSerializer", "type", "Ljava/lang/reflect/Type;", "requireSerializer$node_api_main", "serialize", "writeObject", "data", "Lorg/apache/qpid/proton/codec/Data;", "writeObject$node_api_main", "writeObjectOrNull", "writeObjectOrNull$node_api_main", "writeSchema", "schema", "Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "writeTypeNotations", "", "typeNotation", "", "writeTypeNotations$node_api_main", "([Lnet/corda/nodeapi/internal/serialization/amqp/TypeNotation;)Z", "node-api_main"})
public class SerializationOutput {
    private final Map<Object, Integer> objectHistory;
    private final Set<AMQPSerializer<?>> serializerHistory;
    @NotNull
    private final Set<TypeNotation> schemaHistory;
    @NotNull
    private final SerializerFactory serializerFactory;

    @NotNull
    public final Set<TypeNotation> getSchemaHistory$node_api_main() {
        return this.schemaHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> SerializedBytes<T> serialize(@NotNull T obj) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        try {
            SerializedBytes<T> serializedBytes = this._serialize$node_api_main(obj);
            return serializedBytes;
        }
        finally {
            this.andFinally$node_api_main();
        }
    }

    public final void andFinally$node_api_main() {
        this.objectHistory.clear();
        this.serializerHistory.clear();
        this.schemaHistory.clear();
    }

    @NotNull
    public final <T> SerializedBytes<T> _serialize$node_api_main(@NotNull T obj) {
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        Data data = Data.Factory.create();
        SerializationHelperKt.withDescribed(data, Envelope.Companion.getDESCRIPTOR_OBJECT(), (Function1<? super Data, Unit>)((Function1)new Function1<Data, Unit>(this, obj){
            final /* synthetic */ SerializationOutput this$0;
            final /* synthetic */ Object $obj;

            public final void invoke(@NotNull Data $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                SerializationHelperKt.withList($receiver, (Function1<? super Data, Unit>)((Function1)new Function1<Data, Unit>(this){
                    final /* synthetic */ _serialize.1 this$0;

                    public final void invoke(@NotNull Data $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        this.this$0.this$0.writeObject$node_api_main(this.this$0.$obj, $receiver);
                        this.this$0.this$0.writeSchema(new Schema(CollectionsKt.toList((Iterable)this.this$0.this$0.getSchemaHistory$node_api_main())), $receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = serializationOutput;
                this.$obj = object;
                super(1);
            }
        }));
        byte[] bytes = new byte[(int)data.encodedSize() + 8];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.put(SchemaKt.getAmqpHeaderV1_0().getBytes());
        data.encode(buf);
        return new SerializedBytes(bytes);
    }

    public final void writeObject$node_api_main(@NotNull Object obj, @NotNull Data data) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.writeObject$node_api_main(obj, data, obj.getClass());
    }

    public void writeSchema(@NotNull Schema schema, @NotNull Data data) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        data.putObject((Object)schema);
    }

    public final void writeObjectOrNull$node_api_main(@Nullable Object obj, @NotNull Data data, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (obj == null) {
            data.putNull();
        } else {
            this.writeObject$node_api_main(obj, data, Intrinsics.areEqual((Object)type, (Object)SerializerFactory.AnyType.INSTANCE) ? (Type)obj.getClass() : type);
        }
    }

    public final void writeObject$node_api_main(@NotNull Object obj, @NotNull Data data, @NotNull Type type) {
        Integer retrievedRefCount;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        AMQPSerializer<Object> serializer2 = this.serializerFactory.get(obj.getClass(), type);
        if (this.serializerHistory.contains(serializer2) ^ true) {
            this.serializerHistory.add(serializer2);
            serializer2.writeClassInfo(this);
        }
        if ((retrievedRefCount = this.objectHistory.get(obj)) == null) {
            serializer2.writeObject(obj, data, type, this);
            if (SerializationHelperKt.suitableForObjectReference(obj.getClass())) {
                this.objectHistory.put(obj, this.objectHistory.size());
            }
        } else {
            SerializationHelperKt.writeReferencedObject(data, new ReferencedObject(retrievedRefCount));
        }
    }

    public boolean writeTypeNotations$node_api_main(TypeNotation ... typeNotation2) {
        Intrinsics.checkParameterIsNotNull((Object)typeNotation2, (String)"typeNotation");
        return CollectionsKt.addAll((Collection)this.schemaHistory, (Object[])typeNotation2);
    }

    public void requireSerializer$node_api_main(@NotNull Type type) {
        AMQPSerializer<Object> serializer2;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, (Object)SerializerFactory.AnyType.INSTANCE) ^ true && Intrinsics.areEqual((Object)type, Object.class) ^ true && this.serializerHistory.contains(serializer2 = this.serializerFactory.get(null, type)) ^ true) {
            this.serializerHistory.add(serializer2);
            serializer2.writeClassInfo(this);
        }
    }

    @NotNull
    public final SerializerFactory getSerializerFactory$node_api_main() {
        return this.serializerFactory;
    }

    public SerializationOutput(@NotNull SerializerFactory serializerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)serializerFactory, (String)"serializerFactory");
        this.serializerFactory = serializerFactory;
        this.objectHistory = new IdentityHashMap();
        this.serializerHistory = new LinkedHashSet();
        this.schemaHistory = new LinkedHashSet();
    }
}

