/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp;

import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeResolver;
import java.io.NotSerializableException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.serialization.ClassWhitelist;
import net.corda.core.serialization.CordaSerializable;
import net.corda.nodeapi.internal.serialization.amqp.AMQPPrimitiveSerializer;
import net.corda.nodeapi.internal.serialization.amqp.AMQPSerializer;
import net.corda.nodeapi.internal.serialization.amqp.ArraySerializer;
import net.corda.nodeapi.internal.serialization.amqp.CollectionSerializer;
import net.corda.nodeapi.internal.serialization.amqp.CompositeType;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.DeserializedGenericArrayType;
import net.corda.nodeapi.internal.serialization.amqp.DeserializedParameterizedType;
import net.corda.nodeapi.internal.serialization.amqp.EnumSerializer;
import net.corda.nodeapi.internal.serialization.amqp.EvolutionSerializer;
import net.corda.nodeapi.internal.serialization.amqp.FactorySchemaAndDescriptor;
import net.corda.nodeapi.internal.serialization.amqp.MapSerializer;
import net.corda.nodeapi.internal.serialization.amqp.MapSerializerKt;
import net.corda.nodeapi.internal.serialization.amqp.ObjectSerializer;
import net.corda.nodeapi.internal.serialization.amqp.PrimArraySerializer;
import net.corda.nodeapi.internal.serialization.amqp.RestrictedType;
import net.corda.nodeapi.internal.serialization.amqp.Schema;
import net.corda.nodeapi.internal.serialization.amqp.SerializationHelperKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.SingletonSerializer;
import net.corda.nodeapi.internal.serialization.amqp.TypeNotation;
import net.corda.nodeapi.internal.serialization.carpenter.CarpenterMetaSchema;
import net.corda.nodeapi.internal.serialization.carpenter.ClassCarpenter;
import net.corda.nodeapi.internal.serialization.carpenter.MetaCarpenter;
import net.corda.nodeapi.internal.serialization.carpenter.SimpleFieldAccess;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 B2\u00020\u0001:\u0002ABB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001cJ.\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0007J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0007J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0002J\u0014\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J,\u0010.\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u000200H\u0002J,\u0010.\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0019\u00101\u001a\u00020,2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0000\u00a2\u0006\u0002\b2J*\u00103\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010-\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u001b\u001a\u000200H\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010(\u001a\u000206H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010(\u001a\u000208H\u0002J\u001a\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020,H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010>\u001a\u00020:2\u000e\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010J\u0010\u0010@\u001a\u00020:2\u0006\u0010-\u001a\u00020\u0015H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006C"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "", "whitelist", "Lnet/corda/core/serialization/ClassWhitelist;", "cl", "Ljava/lang/ClassLoader;", "(Lnet/corda/core/serialization/ClassWhitelist;Ljava/lang/ClassLoader;)V", "classCarpenter", "Lnet/corda/nodeapi/internal/serialization/carpenter/ClassCarpenter;", "getClassCarpenter", "()Lnet/corda/nodeapi/internal/serialization/carpenter/ClassCarpenter;", "classloader", "getClassloader", "()Ljava/lang/ClassLoader;", "customSerializers", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer;", "serializersByDescriptor", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/corda/nodeapi/internal/serialization/amqp/AMQPSerializer;", "serializersByType", "Ljava/lang/reflect/Type;", "getWhitelist", "()Lnet/corda/core/serialization/ClassWhitelist;", "findCustomSerializer", "clazz", "Ljava/lang/Class;", "declaredType", "findCustomSerializer$node_api_main", "findPathToDeclared", "", "startingType", "chain", "", "get", "actualClass", "typeDescriptor", "schema", "Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "getEvolutionSerializer", "typeNotation", "Lnet/corda/nodeapi/internal/serialization/amqp/TypeNotation;", "newSerializer", "hasAnnotationInHierarchy", "", "type", "inferTypeVariables", "declaredClass", "Ljava/lang/reflect/ParameterizedType;", "isNotWhitelisted", "isNotWhitelisted$node_api_main", "makeClassSerializer", "makeMapSerializer", "processCompositeType", "Lnet/corda/nodeapi/internal/serialization/amqp/CompositeType;", "processRestrictedType", "Lnet/corda/nodeapi/internal/serialization/amqp/RestrictedType;", "processSchema", "", "Lnet/corda/nodeapi/internal/serialization/amqp/FactorySchemaAndDescriptor;", "sentinel", "processSchemaEntry", "register", "customSerializer", "whitelisted", "AnyType", "Companion", "node-api_main"})
@ThreadSafe
public final class SerializerFactory {
    private final ConcurrentHashMap<Type, AMQPSerializer<Object>> serializersByType;
    private final ConcurrentHashMap<Object, AMQPSerializer<Object>> serializersByDescriptor;
    private final CopyOnWriteArrayList<CustomSerializer<? extends Object>> customSerializers;
    @NotNull
    private final ClassCarpenter classCarpenter;
    @NotNull
    private final ClassWhitelist whitelist;
    private static final Map<Class<?>, String> primitiveTypeNames;
    private static final Map<String, Class<?>> namesOfPrimitiveTypes;
    public static final Companion Companion;

    @NotNull
    public final ClassCarpenter getClassCarpenter() {
        return this.classCarpenter;
    }

    @NotNull
    public final ClassLoader getClassloader() {
        return this.classCarpenter.getClassloader();
    }

    private final AMQPSerializer<Object> getEvolutionSerializer(TypeNotation typeNotation2, AMQPSerializer<? extends Object> newSerializer) {
        Symbol symbol = typeNotation2.getDescriptor().getName();
        if (symbol == null) {
            Intrinsics.throwNpe();
        }
        AMQPSerializer<Object> aMQPSerializer = this.serializersByDescriptor.computeIfAbsent(symbol, (Function<Object, AMQPSerializer<Object>>)new Function<Object, AMQPSerializer<? extends Object>>(this, typeNotation2, newSerializer){
            final /* synthetic */ SerializerFactory this$0;
            final /* synthetic */ TypeNotation $typeNotation;
            final /* synthetic */ AMQPSerializer $newSerializer;

            @NotNull
            public final AMQPSerializer<Object> apply(@NotNull Object it) {
                AMQPSerializer aMQPSerializer;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                TypeNotation typeNotation2 = this.$typeNotation;
                if (typeNotation2 instanceof CompositeType) {
                    aMQPSerializer = this.$newSerializer;
                    if (aMQPSerializer == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.corda.nodeapi.internal.serialization.amqp.ObjectSerializer");
                    }
                } else {
                    if (typeNotation2 instanceof RestrictedType) {
                        throw (Throwable)new NotSerializableException("Enum evolution is not currently supported");
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return EvolutionSerializer.Companion.make((CompositeType)this.$typeNotation, (ObjectSerializer)aMQPSerializer, this.this$0);
            }
            {
                this.this$0 = serializerFactory;
                this.$typeNotation = typeNotation2;
                this.$newSerializer = aMQPSerializer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(aMQPSerializer, (String)"serializersByDescriptor.\u2026)\n            }\n        }");
        return aMQPSerializer;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final AMQPSerializer<Object> get(@Nullable Class<?> actualClass, @NotNull Type declaredType) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        v0 = SerializationHelperKt.asClass(declaredType);
        if (v0 == null) {
            throw (Throwable)new NotSerializableException("Declared types of " + declaredType + " are not supported.");
        }
        declaredClass = v0;
        v1 = this.inferTypeVariables(actualClass, declaredClass, declaredType);
        if (v1 == null) {
            v1 = actualType = declaredType;
        }
        if (!Collection.class.isAssignableFrom(declaredClass) && (actualClass == null || !Collection.class.isAssignableFrom(actualClass))) ** GOTO lbl-1000
        v2 = actualClass;
        if (v2 == null) {
            v2 = declaredClass;
        }
        if (!EnumSet.class.isAssignableFrom(v2)) {
            declaredTypeAmended = CollectionSerializer.Companion.deriveParameterizedType(declaredType, declaredClass, actualClass);
            v3 = this.serializersByType.computeIfAbsent(declaredTypeAmended, (Function<Type, AMQPSerializer<Object>>)new Function<Type, AMQPSerializer<? extends Object>>(this, declaredTypeAmended){
                final /* synthetic */ SerializerFactory this$0;
                final /* synthetic */ ParameterizedType $declaredTypeAmended;

                @NotNull
                public final CollectionSerializer apply(@NotNull Type it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return new CollectionSerializer(this.$declaredTypeAmended, this.this$0);
                }
                {
                    this.this$0 = serializerFactory;
                    this.$declaredTypeAmended = parameterizedType;
                }
            });
        } else if (Map.class.isAssignableFrom(declaredClass) || actualClass != null && Map.class.isAssignableFrom(actualClass)) {
            declaredTypeAmended = MapSerializer.Companion.deriveParameterizedType(declaredType, declaredClass, actualClass);
            v3 = this.serializersByType.computeIfAbsent(declaredTypeAmended, (Function<Type, AMQPSerializer<Object>>)new Function<Type, AMQPSerializer<? extends Object>>(this, declaredTypeAmended){
                final /* synthetic */ SerializerFactory this$0;
                final /* synthetic */ ParameterizedType $declaredTypeAmended;

                @NotNull
                public final AMQPSerializer<Object> apply(@NotNull Type it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SerializerFactory.access$makeMapSerializer(this.this$0, this.$declaredTypeAmended);
                }
                {
                    this.this$0 = serializerFactory;
                    this.$declaredTypeAmended = parameterizedType;
                }
            });
        } else {
            v4 = actualClass;
            if (v4 == null) {
                v4 = declaredClass;
            }
            if (Enum.class.isAssignableFrom(v4)) {
                v5 = actualClass;
                v3 = this.serializersByType.computeIfAbsent(v5 != null ? (Type)v5 : (Type)declaredClass, (Function<Type, AMQPSerializer<Object>>)new Function<Type, AMQPSerializer<? extends Object>>(this, actualType, actualClass, declaredClass){
                    final /* synthetic */ SerializerFactory this$0;
                    final /* synthetic */ Type $actualType;
                    final /* synthetic */ Class $actualClass;
                    final /* synthetic */ Class $declaredClass;

                    @NotNull
                    public final EnumSerializer apply(@NotNull Type it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Class clazz = this.$actualClass;
                        if (clazz == null) {
                            clazz = this.$declaredClass;
                        }
                        return new EnumSerializer(this.$actualType, clazz, this.this$0);
                    }
                    {
                        this.this$0 = serializerFactory;
                        this.$actualType = type;
                        this.$actualClass = clazz;
                        this.$declaredClass = clazz2;
                    }
                });
            } else {
                v6 = actualClass;
                if (v6 == null) {
                    v6 = declaredClass;
                }
                v3 = this.makeClassSerializer(v6, actualType, declaredType);
            }
        }
        serializer = v3;
        this.serializersByDescriptor.putIfAbsent(serializer.getTypeDescriptor(), serializer);
        v7 = serializer;
        Intrinsics.checkExpressionValueIsNotNull(v7, (String)"serializer");
        return v7;
    }

    private final Type inferTypeVariables(Class<?> actualClass, Class<?> declaredClass, Type declaredType) {
        Type type;
        Type type2 = declaredType;
        if (type2 instanceof ParameterizedType) {
            type = this.inferTypeVariables(actualClass, declaredClass, (ParameterizedType)declaredType);
        } else if (type2 instanceof Class) {
            type = actualClass;
        } else if (type2 instanceof GenericArrayType) {
            Type declaredComponent = ((GenericArrayType)declaredType).getGenericComponentType();
            Class<?> clazz = actualClass;
            Class<Object> clazz2 = clazz != null ? clazz.getComponentType() : null;
            Class<?> clazz3 = SerializationHelperKt.asClass(declaredComponent);
            if (clazz3 == null) {
                Intrinsics.throwNpe();
            }
            Type type3 = declaredComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"declaredComponent");
            Type type4 = this.inferTypeVariables(clazz2, clazz3, type3);
            type = type4 != null ? SerializationHelperKt.asArray(type4) : null;
        } else {
            type = null;
        }
        return type;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Type inferTypeVariables(Class<?> actualClass, Class<?> declaredClass, ParameterizedType declaredType) {
        Type type;
        if (actualClass == null || Intrinsics.areEqual(declaredClass, actualClass)) {
            return null;
        }
        if (!declaredClass.isAssignableFrom(actualClass)) throw (Throwable)new NotSerializableException("Found object of type " + actualClass + " in a property expecting " + declaredType);
        Object[] objectArray = actualClass.getTypeParameters();
        Object[] objectArray2 = objectArray;
        if (!(objectArray2.length == 0)) {
            Type resolvedType;
            void $receiver$iv;
            TypeResolver initial$iv;
            SerializerFactory serializerFactory = this;
            Type type2 = actualClass;
            Type type3 = declaredType;
            List list = new ArrayList();
            List<Type> implementationChain = serializerFactory.findPathToDeclared(type2, type3, list);
            if (implementationChain == null) throw (Throwable)new NotSerializableException("No inheritance path between actual " + actualClass + " and declared " + declaredType + '.');
            Type start = (Type)CollectionsKt.last(implementationChain);
            List rest = CollectionsKt.drop((Iterable)CollectionsKt.dropLast(implementationChain, (int)1), (int)1);
            Iterable iterable = CollectionsKt.reversed((Iterable)rest);
            TypeResolver accumulator$iv = initial$iv = new TypeResolver().where(start, (Type)declaredType);
            for (Object element$iv : $receiver$iv) {
                void chainEntry;
                Type type4 = (Type)element$iv;
                TypeResolver resolved = accumulator$iv;
                Type newResolved = resolved.resolveType((Type)chainEntry);
                accumulator$iv = new TypeResolver().where((Type)chainEntry, newResolved);
            }
            TypeResolver resolver = accumulator$iv;
            TypeVariable<Class<?>>[] typeVariableArray = actualClass.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(typeVariableArray, (String)"actualClass.typeParameters");
            DeserializedParameterizedType endType = new DeserializedParameterizedType(actualClass, typeVariableArray, null, 4, null);
            type = resolvedType = resolver.resolveType((Type)endType);
            return type;
        } else {
            type = actualClass;
        }
        return type;
    }

    private final List<Type> findPathToDeclared(Type startingType, Type declaredType, List<Type> chain) {
        List<Type> superClassChain;
        List<Type> list;
        Type superClass;
        chain.add(startingType);
        Type[] startingClass = SerializationHelperKt.asClass(startingType);
        if (Intrinsics.areEqual(startingClass, SerializationHelperKt.asClass(declaredType))) {
            return chain;
        }
        Type type = superClass = startingClass != null ? startingClass.getGenericSuperclass() : null;
        if (superClass != null) {
            Type resolved;
            Type type2 = resolved = new TypeResolver().where((Type)SerializationHelperKt.asParameterizedType(startingClass), (Type)SerializationHelperKt.asParameterizedType(startingType)).resolveType(superClass);
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"resolved");
            list = this.findPathToDeclared(type2, declaredType, new ArrayList(chain));
        } else {
            list = superClassChain = null;
        }
        if (superClassChain != null) {
            return superClassChain;
        }
        Type[] typeArray = startingClass;
        if (startingClass == null || (typeArray = typeArray.getGenericInterfaces()) == null) {
            typeArray = new Type[]{};
        }
        Type[] typeArray2 = typeArray;
        for (int i = 0; i < typeArray2.length; ++i) {
            Type resolved;
            Type iface = typeArray2[i];
            TypeResolver typeResolver = new TypeResolver();
            if (startingClass == null) {
                Intrinsics.throwNpe();
            }
            Type type3 = resolved = typeResolver.where((Type)SerializationHelperKt.asParameterizedType(startingClass), (Type)SerializationHelperKt.asParameterizedType(startingType)).resolveType(iface);
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"resolved");
            List<Type> list2 = this.findPathToDeclared(type3, declaredType, new ArrayList(chain));
            if (list2 == null) {
                continue;
            }
            return list2;
        }
        return null;
    }

    @NotNull
    public final AMQPSerializer<Object> get(@NotNull Object typeDescriptor2, @NotNull Schema schema) throws NotSerializableException {
        Intrinsics.checkParameterIsNotNull((Object)typeDescriptor2, (String)"typeDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        AMQPSerializer aMQPSerializer = this.serializersByDescriptor.get(typeDescriptor2);
        if (aMQPSerializer == null) {
            Object object = ((Function0)new Function0<AMQPSerializer<? extends Object>>(this, schema, typeDescriptor2){
                final /* synthetic */ SerializerFactory this$0;
                final /* synthetic */ Schema $schema;
                final /* synthetic */ Object $typeDescriptor;

                @NotNull
                public final AMQPSerializer<Object> invoke() {
                    SerializerFactory.processSchema$default(this.this$0, new FactorySchemaAndDescriptor(this.$schema, this.$typeDescriptor), false, 2, null);
                    AMQPSerializer aMQPSerializer = (AMQPSerializer)SerializerFactory.access$getSerializersByDescriptor$p(this.this$0).get(this.$typeDescriptor);
                    if (aMQPSerializer == null) {
                        throw (Throwable)new NotSerializableException("Could not find type matching descriptor " + this.$typeDescriptor + '.');
                    }
                    return aMQPSerializer;
                }
                {
                    this.this$0 = serializerFactory;
                    this.$schema = schema;
                    this.$typeDescriptor = object;
                    super(0);
                }
            }).invoke();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"{\n            processSch\u2026Descriptor.\")\n        }()");
            aMQPSerializer = (AMQPSerializer)object;
        }
        return aMQPSerializer;
    }

    public final void register(@NotNull CustomSerializer<? extends Object> customSerializer) {
        Intrinsics.checkParameterIsNotNull(customSerializer, (String)"customSerializer");
        if (!this.serializersByDescriptor.containsKey(customSerializer.getTypeDescriptor())) {
            Collection object = this.customSerializers;
            object.add(customSerializer);
            Map map = this.serializersByDescriptor;
            Symbol symbol = customSerializer.getTypeDescriptor();
            CustomSerializer<? extends Object> customSerializer2 = customSerializer;
            map.put(symbol, customSerializer2);
            for (CustomSerializer customSerializer3 : customSerializer.getAdditionalSerializers()) {
                this.register(customSerializer3);
            }
        }
    }

    private final void processSchema(FactorySchemaAndDescriptor schema, boolean sentinel) {
        CarpenterMetaSchema metaSchema = CarpenterMetaSchema.CarpenterSchemaConstructor.newInstance();
        for (TypeNotation typeNotation2 : schema.getSchema().getTypes()) {
            try {
                AMQPSerializer<Object> serialiser = this.processSchemaEntry(typeNotation2);
                if (!(Intrinsics.areEqual((Object)serialiser.getTypeDescriptor(), (Object)typeNotation2.getDescriptor().getName()) ^ true)) continue;
                this.getEvolutionSerializer(typeNotation2, serialiser);
            }
            catch (ClassNotFoundException e) {
                if (sentinel) {
                    throw (Throwable)e;
                }
                metaSchema.buildFor(typeNotation2, this.getClassloader());
            }
        }
        if (metaSchema.isNotEmpty()) {
            MetaCarpenter mc = new MetaCarpenter(metaSchema, this.classCarpenter);
            mc.build();
            this.processSchema(schema, true);
        }
    }

    static /* bridge */ /* synthetic */ void processSchema$default(SerializerFactory serializerFactory, FactorySchemaAndDescriptor factorySchemaAndDescriptor, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        serializerFactory.processSchema(factorySchemaAndDescriptor, bl);
    }

    private final AMQPSerializer<Object> processSchemaEntry(TypeNotation typeNotation2) {
        AMQPSerializer<Object> aMQPSerializer;
        TypeNotation typeNotation3 = typeNotation2;
        if (typeNotation3 instanceof CompositeType) {
            aMQPSerializer = this.processCompositeType((CompositeType)typeNotation2);
        } else if (typeNotation3 instanceof RestrictedType) {
            aMQPSerializer = this.processRestrictedType((RestrictedType)typeNotation2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return aMQPSerializer;
    }

    private final AMQPSerializer<Object> processRestrictedType(RestrictedType typeNotation2) {
        return this.get(null, SerializerFactory.Companion.typeForName(typeNotation2.getName(), this.getClassloader()));
    }

    private final AMQPSerializer<Object> processCompositeType(CompositeType typeNotation2) {
        Type type = SerializerFactory.Companion.typeForName(typeNotation2.getName(), this.getClassloader());
        Class<?> clazz = SerializationHelperKt.asClass(type);
        if (clazz == null) {
            throw (Throwable)new NotSerializableException("Unable to build composite type for " + type);
        }
        return this.get(clazz, type);
    }

    private final AMQPSerializer<Object> makeClassSerializer(Class<?> clazz, Type type, Type declaredType) {
        AMQPSerializer<Object> aMQPSerializer = this.serializersByType.computeIfAbsent(type, (Function<Type, AMQPSerializer<Object>>)new Function<Type, AMQPSerializer<? extends Object>>(this, clazz, declaredType, type){
            final /* synthetic */ SerializerFactory this$0;
            final /* synthetic */ Class $clazz;
            final /* synthetic */ Type $declaredType;
            final /* synthetic */ Type $type;

            @NotNull
            public final AMQPSerializer<Object> apply(@NotNull Type it) {
                AMQPSerializer aMQPSerializer;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (SerializerFactory.Companion.isPrimitive(this.$clazz)) {
                    aMQPSerializer = new AMQPPrimitiveSerializer(this.$clazz);
                } else {
                    aMQPSerializer = this.this$0.findCustomSerializer$node_api_main(this.$clazz, this.$declaredType);
                    if (aMQPSerializer == null) {
                        SerializerFactory serializerFactory;
                        SerializerFactory $receiver = serializerFactory = this.this$0;
                        if (SerializationHelperKt.isArray(this.$type)) {
                            aMQPSerializer = this.$clazz.getComponentType().isPrimitive() ? (ArraySerializer)PrimArraySerializer.Companion.make(this.$type, $receiver) : ArraySerializer.Companion.make(this.$type, $receiver);
                        } else if (JvmClassMappingKt.getKotlinClass((Class)this.$clazz).getObjectInstance() != null) {
                            SerializerFactory.access$whitelisted($receiver, this.$clazz);
                            Object object = JvmClassMappingKt.getKotlinClass((Class)this.$clazz).getObjectInstance();
                            if (object == null) {
                                Intrinsics.throwNpe();
                            }
                            aMQPSerializer = new SingletonSerializer(this.$clazz, object, $receiver);
                        } else {
                            SerializerFactory.access$whitelisted($receiver, this.$type);
                            aMQPSerializer = new ObjectSerializer(this.$type, $receiver);
                        }
                    }
                }
                return aMQPSerializer;
            }
            {
                this.this$0 = serializerFactory;
                this.$clazz = clazz;
                this.$declaredType = type;
                this.$type = type2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(aMQPSerializer, (String)"serializersByType.comput\u2026        }\n        }\n    }");
        return aMQPSerializer;
    }

    @Nullable
    public final AMQPSerializer<Object> findCustomSerializer$node_api_main(@NotNull Class<?> clazz, @NotNull Type declaredType) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)declaredType, (String)"declaredType");
        for (CustomSerializer<? extends Object> customSerializer : this.customSerializers) {
            Class<?> declaredSuperClass;
            if (!customSerializer.isSerializerFor(clazz)) continue;
            Class<?> clazz2 = SerializationHelperKt.asClass(declaredType);
            Class<Object> clazz3 = declaredSuperClass = clazz2 != null ? clazz2.getSuperclass() : null;
            if (declaredSuperClass == null || !customSerializer.isSerializerFor(declaredSuperClass) || !customSerializer.getRevealSubclassesInSchema()) {
                return customSerializer;
            }
            CustomSerializer<? extends Object> customSerializer2 = customSerializer;
            if (customSerializer2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.nodeapi.internal.serialization.amqp.CustomSerializer<kotlin.Any>");
            }
            return new CustomSerializer.SubClass<Object>(clazz, customSerializer2);
        }
        return null;
    }

    private final void whitelisted(Type type) {
        Class<?> clazz;
        Class<?> clazz2 = SerializationHelperKt.asClass(type);
        if (clazz2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.isNotWhitelisted$node_api_main(clazz = clazz2)) {
            throw (Throwable)new NotSerializableException("Class " + type + " is not on the whitelist or annotated with @CordaSerializable.");
        }
    }

    public final boolean isNotWhitelisted$node_api_main(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return Intrinsics.areEqual(clazz, SimpleFieldAccess.class) || !this.whitelist.hasListed(clazz) && !this.hasAnnotationInHierarchy(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasAnnotationInHierarchy(Class<?> type) {
        if (type.isAnnotationPresent(CordaSerializable.class)) return true;
        Object[] $receiver$iv = type.getInterfaces();
        for (int i = 0; i < $receiver$iv.length; ++i) {
            Class it;
            Object element$iv = $receiver$iv[i];
            Class clazz = it = (Class)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"it");
            if (!this.hasAnnotationInHierarchy(clazz)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (type.getSuperclass() == null) return false;
        Class<?> clazz = type.getSuperclass();
        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.superclass");
        if (!this.hasAnnotationInHierarchy(clazz)) return false;
        return true;
    }

    private final AMQPSerializer<Object> makeMapSerializer(ParameterizedType declaredType) {
        Type type = declaredType.getRawType();
        if (type == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        Class rawType = (Class)type;
        MapSerializerKt.checkSupportedMapType(rawType);
        return new MapSerializer(declaredType, this);
    }

    @NotNull
    public final ClassWhitelist getWhitelist() {
        return this.whitelist;
    }

    public SerializerFactory(@NotNull ClassWhitelist whitelist, @NotNull ClassLoader cl) {
        Intrinsics.checkParameterIsNotNull((Object)whitelist, (String)"whitelist");
        Intrinsics.checkParameterIsNotNull((Object)cl, (String)"cl");
        this.whitelist = whitelist;
        this.serializersByType = new ConcurrentHashMap();
        this.serializersByDescriptor = new ConcurrentHashMap();
        this.customSerializers = new CopyOnWriteArrayList();
        this.classCarpenter = new ClassCarpenter(cl);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Map $receiver$iv;
        Companion = new Companion(null);
        primitiveTypeNames = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(Character.class, (Object)"char"), TuplesKt.to(Character.TYPE, (Object)"char"), TuplesKt.to(Boolean.TYPE, (Object)"boolean"), TuplesKt.to(Byte.TYPE, (Object)"byte"), TuplesKt.to(UnsignedByte.class, (Object)"ubyte"), TuplesKt.to(Short.TYPE, (Object)"short"), TuplesKt.to(UnsignedShort.class, (Object)"ushort"), TuplesKt.to(Integer.TYPE, (Object)"int"), TuplesKt.to(UnsignedInteger.class, (Object)"uint"), TuplesKt.to(Long.TYPE, (Object)"long"), TuplesKt.to(UnsignedLong.class, (Object)"ulong"), TuplesKt.to(Float.TYPE, (Object)"float"), TuplesKt.to(Double.TYPE, (Object)"double"), TuplesKt.to(Decimal32.class, (Object)"decimal32"), TuplesKt.to(Decimal64.class, (Object)"decimal62"), TuplesKt.to(Decimal128.class, (Object)"decimal128"), TuplesKt.to(Date.class, (Object)"timestamp"), TuplesKt.to(UUID.class, (Object)"uuid"), TuplesKt.to(byte[].class, (Object)"binary"), TuplesKt.to(String.class, (Object)"string"), TuplesKt.to(Symbol.class, (Object)"symbol")});
        Map map = $receiver$iv = SerializerFactory.Companion.getPrimitiveTypeNames();
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var3_3 = $receiver$iv$iv;
        Iterator iterator = var3_3.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to(it.getValue(), it.getKey());
            collection.add(pair);
        }
        namesOfPrimitiveTypes = MapsKt.toMap((Iterable)((List)var2_2));
    }

    @NotNull
    public static final /* synthetic */ AMQPSerializer access$makeMapSerializer(SerializerFactory $this, @NotNull ParameterizedType declaredType) {
        return $this.makeMapSerializer(declaredType);
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getSerializersByDescriptor$p(SerializerFactory $this) {
        return $this.serializersByDescriptor;
    }

    public static final /* synthetic */ void access$whitelisted(SerializerFactory $this, @NotNull Type type) {
        $this.whitelisted(type);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory$AnyType;", "Ljava/lang/reflect/WildcardType;", "()V", "getLowerBounds", "", "Ljava/lang/reflect/Type;", "()[Ljava/lang/reflect/Type;", "getUpperBounds", "toString", "", "node-api_main"})
    public static final class AnyType
    implements WildcardType {
        public static final AnyType INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Type[] getUpperBounds() {
            void var1_1;
            Object[] elements$iv = new Type[]{(Type)((Object)Object.class)};
            return (Type[])var1_1;
        }

        @Override
        @NotNull
        public Type[] getLowerBounds() {
            return new Type[0];
        }

        @NotNull
        public String toString() {
            return "?";
        }

        private AnyType() {
            INSTANCE = this;
        }

        static {
            new AnyType();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory$Companion;", "", "()V", "namesOfPrimitiveTypes", "", "", "Ljava/lang/Class;", "getNamesOfPrimitiveTypes", "()Ljava/util/Map;", "primitiveTypeNames", "getPrimitiveTypeNames", "isPrimitive", "", "type", "Ljava/lang/reflect/Type;", "nameForType", "primitiveType", "primitiveTypeName", "typeForName", "name", "classloader", "Ljava/lang/ClassLoader;", "node-api_main"})
    public static final class Companion {
        public final boolean isPrimitive(@NotNull Type type) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return this.primitiveTypeName(type) != null;
        }

        @Nullable
        public final String primitiveTypeName(@NotNull Type type) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Type type2 = type;
            if (!(type2 instanceof Class)) {
                type2 = null;
            }
            Class clazz = (Class)type2;
            if (clazz == null) {
                return null;
            }
            Class clazz2 = clazz;
            return this.getPrimitiveTypeNames().get(Primitives.unwrap((Class)clazz2));
        }

        @Nullable
        public final Class<?> primitiveType(@NotNull String type) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return this.getNamesOfPrimitiveTypes().get(type);
        }

        private final Map<Class<?>, String> getPrimitiveTypeNames() {
            return primitiveTypeNames;
        }

        private final Map<String, Class<?>> getNamesOfPrimitiveTypes() {
            return namesOfPrimitiveTypes;
        }

        @NotNull
        public final String nameForType(@NotNull Type type) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Type type2 = type;
            if (type2 instanceof Class) {
                string = this.primitiveTypeName(type);
                if (string == null) {
                    String string2;
                    if (((Class)type).isArray()) {
                        StringBuilder stringBuilder = new StringBuilder().append("");
                        Class<?> clazz = ((Class)type).getComponentType();
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.componentType");
                        string2 = stringBuilder.append(this.nameForType(clazz)).append("").append(((Class)type).getComponentType().isPrimitive() ? "[p]" : "[]").toString();
                    } else {
                        string2 = ((Class)type).getName();
                    }
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"if (type.isArray) {\n    \u2026         } else type.name");
                }
            } else if (type2 instanceof ParameterizedType) {
                StringBuilder stringBuilder = new StringBuilder().append("");
                Type type3 = ((ParameterizedType)type).getRawType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                string = stringBuilder.append(this.nameForType(type3)).append('<').append(ArraysKt.joinToString$default((Object[])((ParameterizedType)type).getActualTypeArguments(), null, null, null, (int)0, null, (Function1)nameForType.1.INSTANCE, (int)31, null)).append('>').toString();
            } else if (type2 instanceof GenericArrayType) {
                StringBuilder stringBuilder = new StringBuilder().append("");
                Type type4 = ((GenericArrayType)type).getGenericComponentType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"type.genericComponentType");
                string = stringBuilder.append(this.nameForType(type4)).append("[]").toString();
            } else if (type2 instanceof WildcardType) {
                string = "?";
            } else if (type2 instanceof TypeVariable) {
                string = "?";
            } else {
                throw (Throwable)new NotSerializableException("Unable to render type " + type + " to a string.");
            }
            return string;
        }

        private final Type typeForName(String name, ClassLoader classloader) {
            Type type;
            if (StringsKt.endsWith$default((String)name, (String)"[]", (boolean)false, (int)2, null)) {
                String string = name;
                int n = 0;
                int n2 = StringsKt.getLastIndex((CharSequence)name) - 1;
                Companion companion = this;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string3;
                Type elementType2 = companion.typeForName(string4, classloader);
                if (elementType2 instanceof ParameterizedType || elementType2 instanceof GenericArrayType) {
                    type = new DeserializedGenericArrayType(elementType2);
                } else {
                    if (!(elementType2 instanceof Class)) {
                        throw (Throwable)new NotSerializableException("Not able to deserialize array type: " + name);
                    }
                    type = Array.newInstance((Class)elementType2, 0).getClass();
                }
            } else if (StringsKt.endsWith$default((String)name, (String)"[p]", (boolean)false, (int)2, null)) {
                Class clazz;
                switch (name) {
                    case "int[p]": {
                        clazz = int[].class;
                        break;
                    }
                    case "char[p]": {
                        clazz = char[].class;
                        break;
                    }
                    case "boolean[p]": {
                        clazz = boolean[].class;
                        break;
                    }
                    case "float[p]": {
                        clazz = float[].class;
                        break;
                    }
                    case "double[p]": {
                        clazz = double[].class;
                        break;
                    }
                    case "short[p]": {
                        clazz = short[].class;
                        break;
                    }
                    case "long[p]": {
                        clazz = long[].class;
                        break;
                    }
                    default: {
                        throw (Throwable)new NotSerializableException("Not able to deserialize array type: " + name);
                    }
                }
                type = (Type)((Object)clazz);
            } else {
                type = DeserializedParameterizedType.Companion.make(name, classloader);
            }
            return type;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

