/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/DurationSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Proxy;", "Ljava/time/Duration;", "Lnet/corda/nodeapi/internal/serialization/amqp/custom/DurationSerializer$DurationProxy;", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "DurationProxy", "node-api_main"})
public final class DurationSerializer
extends CustomSerializer.Proxy<Duration, DurationProxy> {
    @Override
    @NotNull
    protected DurationProxy toProxy(@NotNull Duration obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return new DurationProxy(obj.getSeconds(), obj.getNano());
    }

    @Override
    @NotNull
    protected Duration fromProxy(@NotNull DurationProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Duration duration = Duration.ofSeconds(proxy.getSeconds(), proxy.getNanos());
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(proxy\u2026ds, proxy.nanos.toLong())");
        return duration;
    }

    public DurationSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(Duration.class, DurationProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/DurationSerializer$DurationProxy;", "", "seconds", "", "nanos", "", "(JI)V", "getNanos", "()I", "getSeconds", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "node-api_main"})
    public static final class DurationProxy {
        private final long seconds;
        private final int nanos;

        public final long getSeconds() {
            return this.seconds;
        }

        public final int getNanos() {
            return this.nanos;
        }

        public DurationProxy(long seconds, int nanos) {
            this.seconds = seconds;
            this.nanos = nanos;
        }

        public final long component1() {
            return this.seconds;
        }

        public final int component2() {
            return this.nanos;
        }

        @NotNull
        public final DurationProxy copy(long seconds, int nanos) {
            return new DurationProxy(seconds, nanos);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DurationProxy copy$default(DurationProxy durationProxy, long l, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = durationProxy.seconds;
            }
            if ((n2 & 2) != 0) {
                n = durationProxy.nanos;
            }
            return durationProxy.copy(l, n);
        }

        public String toString() {
            return "DurationProxy(seconds=" + this.seconds + ", nanos=" + this.nanos + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.seconds) * 31 + Integer.hashCode(this.nanos);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DurationProxy)) break block3;
                    DurationProxy durationProxy = (DurationProxy)object;
                    if (!(this.seconds == durationProxy.seconds) || !(this.nanos == durationProxy.nanos)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

