/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.DeserializationInput;
import net.corda.nodeapi.internal.serialization.amqp.RestrictedType;
import net.corda.nodeapi.internal.serialization.amqp.Schema;
import net.corda.nodeapi.internal.serialization.amqp.SerializationOutput;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/InputStreamSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Implements;", "Ljava/io/InputStream;", "()V", "revealSubclassesInSchema", "", "getRevealSubclassesInSchema", "()Z", "schemaForDocumentation", "Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "getSchemaForDocumentation", "()Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "readObject", "obj", "", "schema", "input", "Lnet/corda/nodeapi/internal/serialization/amqp/DeserializationInput;", "writeDescribedObject", "", "data", "Lorg/apache/qpid/proton/codec/Data;", "type", "Ljava/lang/reflect/Type;", "output", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializationOutput;", "node-api_main"})
public final class InputStreamSerializer
extends CustomSerializer.Implements<InputStream> {
    private static final boolean revealSubclassesInSchema = true;
    @NotNull
    private static final Schema schemaForDocumentation;
    public static final InputStreamSerializer INSTANCE;

    @Override
    public boolean getRevealSubclassesInSchema() {
        return revealSubclassesInSchema;
    }

    @Override
    @NotNull
    public Schema getSchemaForDocumentation() {
        return schemaForDocumentation;
    }

    @Override
    public void writeDescribedObject(@NotNull InputStream obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationOutput output) {
        int numberOfBytesRead;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        int n = 4096;
        int n2 = obj.available() + 1;
        int startingSize = Math.max(n, n2);
        byte[] buffer = new byte[startingSize];
        int pos = 0;
        while ((numberOfBytesRead = obj.read(buffer, pos, buffer.length - pos)) != -1) {
            if ((pos += numberOfBytesRead) != buffer.length) continue;
            byte[] byArray = buffer;
            int n3 = 4096;
            int n4 = obj.available() + 1;
            int n5 = buffer.length;
            int n6 = Math.max(n3, n4);
            n3 = n5 + n6;
            Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(byArray, n3), (String)"java.util.Arrays.copyOf(this, newSize)");
        }
        data.putBinary(new Binary(buffer, 0, pos));
    }

    @Override
    @NotNull
    public InputStream readObject(@NotNull Object obj, @NotNull Schema schema, @NotNull DeserializationInput input) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Object object = input.readObject$node_api_main(obj, schema, (Type)((Object)byte[].class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        byte[] bits = (byte[])object;
        return new ByteArrayInputStream(bits);
    }

    private InputStreamSerializer() {
        super(InputStream.class);
        INSTANCE = this;
        revealSubclassesInSchema = true;
        String string = this.getType().toString();
        List list = CollectionsKt.listOf((Object)this.getType().toString());
        String string2 = SerializerFactory.Companion.primitiveTypeName((Type)((Object)byte[].class));
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        schemaForDocumentation = new Schema(CollectionsKt.listOf((Object)new RestrictedType(string, "", list, string2, this.getDescriptor(), CollectionsKt.emptyList())));
    }

    static {
        new InputStreamSerializer();
    }
}

