/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.custom.LocalDateSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.LocalTimeSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0014R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/LocalDateTimeSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Proxy;", "Ljava/time/LocalDateTime;", "Lnet/corda/nodeapi/internal/serialization/amqp/custom/LocalDateTimeSerializer$LocalDateTimeProxy;", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "additionalSerializers", "", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer;", "", "getAdditionalSerializers", "()Ljava/lang/Iterable;", "fromProxy", "proxy", "toProxy", "obj", "LocalDateTimeProxy", "node-api_main"})
public final class LocalDateTimeSerializer
extends CustomSerializer.Proxy<LocalDateTime, LocalDateTimeProxy> {
    @NotNull
    private final Iterable<CustomSerializer<? extends Object>> additionalSerializers;

    @Override
    @NotNull
    public Iterable<CustomSerializer<? extends Object>> getAdditionalSerializers() {
        return this.additionalSerializers;
    }

    @Override
    @NotNull
    protected LocalDateTimeProxy toProxy(@NotNull LocalDateTime obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        LocalDate localDate = obj.toLocalDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"obj.toLocalDate()");
        LocalTime localTime = obj.toLocalTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"obj.toLocalTime()");
        return new LocalDateTimeProxy(localDate, localTime);
    }

    @Override
    @NotNull
    protected LocalDateTime fromProxy(@NotNull LocalDateTimeProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        LocalDateTime localDateTime = LocalDateTime.of(proxy.getDate(), proxy.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.of(proxy.date, proxy.time)");
        return localDateTime;
    }

    public LocalDateTimeSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(LocalDateTime.class, LocalDateTimeProxy.class, factory, false, 8, null);
        this.additionalSerializers = CollectionsKt.listOf((Object[])new CustomSerializer.Proxy[]{new LocalDateSerializer(factory), new LocalTimeSerializer(factory)});
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/LocalDateTimeSerializer$LocalDateTimeProxy;", "", "date", "Ljava/time/LocalDate;", "time", "Ljava/time/LocalTime;", "(Ljava/time/LocalDate;Ljava/time/LocalTime;)V", "getDate", "()Ljava/time/LocalDate;", "getTime", "()Ljava/time/LocalTime;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "node-api_main"})
    public static final class LocalDateTimeProxy {
        @NotNull
        private final LocalDate date;
        @NotNull
        private final LocalTime time;

        @NotNull
        public final LocalDate getDate() {
            return this.date;
        }

        @NotNull
        public final LocalTime getTime() {
            return this.time;
        }

        public LocalDateTimeProxy(@NotNull LocalDate date, @NotNull LocalTime time) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
            this.date = date;
            this.time = time;
        }

        @NotNull
        public final LocalDate component1() {
            return this.date;
        }

        @NotNull
        public final LocalTime component2() {
            return this.time;
        }

        @NotNull
        public final LocalDateTimeProxy copy(@NotNull LocalDate date, @NotNull LocalTime time) {
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
            return new LocalDateTimeProxy(date, time);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LocalDateTimeProxy copy$default(LocalDateTimeProxy localDateTimeProxy, LocalDate localDate, LocalTime localTime, int n, Object object) {
            if ((n & 1) != 0) {
                localDate = localDateTimeProxy.date;
            }
            if ((n & 2) != 0) {
                localTime = localDateTimeProxy.time;
            }
            return localDateTimeProxy.copy(localDate, localTime);
        }

        public String toString() {
            return "LocalDateTimeProxy(date=" + this.date + ", time=" + this.time + ")";
        }

        public int hashCode() {
            LocalDate localDate = this.date;
            LocalTime localTime = this.time;
            return (localDate != null ? ((Object)localDate).hashCode() : 0) * 31 + (localTime != null ? ((Object)localTime).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LocalDateTimeProxy)) break block3;
                    LocalDateTimeProxy localDateTimeProxy = (LocalDateTimeProxy)object;
                    if (!Intrinsics.areEqual((Object)this.date, (Object)localDateTimeProxy.date) || !Intrinsics.areEqual((Object)this.time, (Object)localDateTimeProxy.time)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

