/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.custom.LocalDateTimeSerializer;
import net.corda.nodeapi.internal.serialization.amqp.custom.ZoneIdSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0014R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/OffsetDateTimeSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Proxy;", "Ljava/time/OffsetDateTime;", "Lnet/corda/nodeapi/internal/serialization/amqp/custom/OffsetDateTimeSerializer$OffsetDateTimeProxy;", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "additionalSerializers", "", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer;", "", "getAdditionalSerializers", "()Ljava/lang/Iterable;", "fromProxy", "proxy", "toProxy", "obj", "OffsetDateTimeProxy", "node-api_main"})
public final class OffsetDateTimeSerializer
extends CustomSerializer.Proxy<OffsetDateTime, OffsetDateTimeProxy> {
    @NotNull
    private final Iterable<CustomSerializer<? extends Object>> additionalSerializers;

    @Override
    @NotNull
    public Iterable<CustomSerializer<? extends Object>> getAdditionalSerializers() {
        return this.additionalSerializers;
    }

    @Override
    @NotNull
    protected OffsetDateTimeProxy toProxy(@NotNull OffsetDateTime obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        LocalDateTime localDateTime = obj.toLocalDateTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"obj.toLocalDateTime()");
        ZoneOffset zoneOffset = obj.getOffset();
        Intrinsics.checkExpressionValueIsNotNull((Object)zoneOffset, (String)"obj.offset");
        return new OffsetDateTimeProxy(localDateTime, zoneOffset);
    }

    @Override
    @NotNull
    protected OffsetDateTime fromProxy(@NotNull OffsetDateTimeProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        OffsetDateTime offsetDateTime = OffsetDateTime.of(proxy.getDateTime(), proxy.getOffset());
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetDateTime, (String)"OffsetDateTime.of(proxy.dateTime, proxy.offset)");
        return offsetDateTime;
    }

    public OffsetDateTimeSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(OffsetDateTime.class, OffsetDateTimeProxy.class, factory, false, 8, null);
        this.additionalSerializers = CollectionsKt.listOf((Object[])new CustomSerializer.Proxy[]{new LocalDateTimeSerializer(factory), new ZoneIdSerializer(factory)});
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/OffsetDateTimeSerializer$OffsetDateTimeProxy;", "", "dateTime", "Ljava/time/LocalDateTime;", "offset", "Ljava/time/ZoneOffset;", "(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)V", "getDateTime", "()Ljava/time/LocalDateTime;", "getOffset", "()Ljava/time/ZoneOffset;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "node-api_main"})
    public static final class OffsetDateTimeProxy {
        @NotNull
        private final LocalDateTime dateTime;
        @NotNull
        private final ZoneOffset offset;

        @NotNull
        public final LocalDateTime getDateTime() {
            return this.dateTime;
        }

        @NotNull
        public final ZoneOffset getOffset() {
            return this.offset;
        }

        public OffsetDateTimeProxy(@NotNull LocalDateTime dateTime, @NotNull ZoneOffset offset) {
            Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
            Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
            this.dateTime = dateTime;
            this.offset = offset;
        }

        @NotNull
        public final LocalDateTime component1() {
            return this.dateTime;
        }

        @NotNull
        public final ZoneOffset component2() {
            return this.offset;
        }

        @NotNull
        public final OffsetDateTimeProxy copy(@NotNull LocalDateTime dateTime, @NotNull ZoneOffset offset) {
            Intrinsics.checkParameterIsNotNull((Object)dateTime, (String)"dateTime");
            Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
            return new OffsetDateTimeProxy(dateTime, offset);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ OffsetDateTimeProxy copy$default(OffsetDateTimeProxy offsetDateTimeProxy, LocalDateTime localDateTime, ZoneOffset zoneOffset, int n, Object object) {
            if ((n & 1) != 0) {
                localDateTime = offsetDateTimeProxy.dateTime;
            }
            if ((n & 2) != 0) {
                zoneOffset = offsetDateTimeProxy.offset;
            }
            return offsetDateTimeProxy.copy(localDateTime, zoneOffset);
        }

        public String toString() {
            return "OffsetDateTimeProxy(dateTime=" + this.dateTime + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            LocalDateTime localDateTime = this.dateTime;
            ZoneOffset zoneOffset = this.offset;
            return (localDateTime != null ? ((Object)localDateTime).hashCode() : 0) * 31 + (zoneOffset != null ? ((Object)zoneOffset).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OffsetDateTimeProxy)) break block3;
                    OffsetDateTimeProxy offsetDateTimeProxy = (OffsetDateTimeProxy)object;
                    if (!Intrinsics.areEqual((Object)this.dateTime, (Object)offsetDateTimeProxy.dateTime) || !Intrinsics.areEqual((Object)this.offset, (Object)offsetDateTimeProxy.offset)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

