/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\f"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/PartyAndCertificateSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Proxy;", "Lnet/corda/core/identity/PartyAndCertificate;", "Lnet/corda/nodeapi/internal/serialization/amqp/custom/PartyAndCertificateSerializer$PartyAndCertificateProxy;", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "fromProxy", "proxy", "toProxy", "obj", "PartyAndCertificateProxy", "node-api_main"})
public final class PartyAndCertificateSerializer
extends CustomSerializer.Proxy<PartyAndCertificate, PartyAndCertificateProxy> {
    @Override
    @NotNull
    protected PartyAndCertificateProxy toProxy(@NotNull PartyAndCertificate obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = obj.getCertPath().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.certPath.type");
        byte[] byArray = obj.getCertPath().getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"obj.certPath.encoded");
        return new PartyAndCertificateProxy(string, byArray);
    }

    @Override
    @NotNull
    protected PartyAndCertificate fromProxy(@NotNull PartyAndCertificateProxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        try {
            CertificateFactory cf = CertificateFactory.getInstance(proxy.getType());
            CertPath certPath = cf.generateCertPath(new ByteArrayInputStream(proxy.getEncoded()));
            Intrinsics.checkExpressionValueIsNotNull((Object)certPath, (String)"cf.generateCertPath(Byte\u2026putStream(proxy.encoded))");
            return new PartyAndCertificate(certPath);
        }
        catch (CertificateException ce) {
            NotSerializableException nse = new NotSerializableException("java.security.cert.CertPath: " + this.getType());
            nse.initCause(ce);
            throw (Throwable)nse;
        }
    }

    public PartyAndCertificateSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(PartyAndCertificate.class, PartyAndCertificateProxy.class, factory, false, 8, null);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/PartyAndCertificateSerializer$PartyAndCertificateProxy;", "", "type", "", "encoded", "", "(Ljava/lang/String;[B)V", "getEncoded", "()[B", "getType", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "node-api_main"})
    public static final class PartyAndCertificateProxy {
        @NotNull
        private final String type;
        @NotNull
        private final byte[] encoded;

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final byte[] getEncoded() {
            return this.encoded;
        }

        public PartyAndCertificateProxy(@NotNull String type, @NotNull byte[] encoded) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            this.type = type;
            this.encoded = encoded;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final byte[] component2() {
            return this.encoded;
        }

        @NotNull
        public final PartyAndCertificateProxy copy(@NotNull String type, @NotNull byte[] encoded) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)encoded, (String)"encoded");
            return new PartyAndCertificateProxy(type, encoded);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PartyAndCertificateProxy copy$default(PartyAndCertificateProxy partyAndCertificateProxy, String string, byte[] byArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = partyAndCertificateProxy.type;
            }
            if ((n & 2) != 0) {
                byArray = partyAndCertificateProxy.encoded;
            }
            return partyAndCertificateProxy.copy(string, byArray);
        }

        public String toString() {
            return "PartyAndCertificateProxy(type=" + this.type + ", encoded=" + Arrays.toString(this.encoded) + ")";
        }

        public int hashCode() {
            String string = this.type;
            return (string != null ? string.hashCode() : 0) * 31 + (this.encoded != null ? Arrays.hashCode(this.encoded) : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PartyAndCertificateProxy)) break block3;
                    PartyAndCertificateProxy partyAndCertificateProxy = (PartyAndCertificateProxy)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)partyAndCertificateProxy.type) || !Intrinsics.areEqual((Object)this.encoded, (Object)partyAndCertificateProxy.encoded)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

