/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.lang.reflect.Type;
import java.security.PublicKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.Crypto;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.DeserializationInput;
import net.corda.nodeapi.internal.serialization.amqp.RestrictedType;
import net.corda.nodeapi.internal.serialization.amqp.Schema;
import net.corda.nodeapi.internal.serialization.amqp.SerializationOutput;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import org.apache.qpid.proton.codec.Data;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/PublicKeySerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Implements;", "Ljava/security/PublicKey;", "()V", "schemaForDocumentation", "Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "getSchemaForDocumentation", "()Lnet/corda/nodeapi/internal/serialization/amqp/Schema;", "readObject", "obj", "", "schema", "input", "Lnet/corda/nodeapi/internal/serialization/amqp/DeserializationInput;", "writeDescribedObject", "", "data", "Lorg/apache/qpid/proton/codec/Data;", "type", "Ljava/lang/reflect/Type;", "output", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializationOutput;", "node-api_main"})
public final class PublicKeySerializer
extends CustomSerializer.Implements<PublicKey> {
    @NotNull
    private static final Schema schemaForDocumentation;
    public static final PublicKeySerializer INSTANCE;

    @Override
    @NotNull
    public Schema getSchemaForDocumentation() {
        return schemaForDocumentation;
    }

    @Override
    public void writeDescribedObject(@NotNull PublicKey obj, @NotNull Data data, @NotNull Type type, @NotNull SerializationOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        byte[] byArray = obj.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"obj.encoded");
        output.writeObject$node_api_main(byArray, data, this.getClazz());
    }

    @Override
    @NotNull
    public PublicKey readObject(@NotNull Object obj, @NotNull Schema schema, @NotNull DeserializationInput input) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Object object = input.readObject$node_api_main(obj, schema, (Type)((Object)byte[].class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        byte[] bits = (byte[])object;
        return Crypto.decodePublicKey((byte[])bits);
    }

    private PublicKeySerializer() {
        super(PublicKey.class);
        INSTANCE = this;
        String string = this.getType().toString();
        List list = CollectionsKt.listOf((Object)this.getType().toString());
        String string2 = SerializerFactory.Companion.primitiveTypeName((Type)((Object)byte[].class));
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        schemaForDocumentation = new Schema(CollectionsKt.listOf((Object)new RestrictedType(string, "", list, string2, this.getDescriptor(), CollectionsKt.emptyList())));
    }

    static {
        new PublicKeySerializer();
    }
}

