/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.amqp.custom;

import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import net.corda.core.CordaRuntimeException;
import net.corda.core.CordaThrowable;
import net.corda.core.serialization.SerializationFactory;
import net.corda.nodeapi.internal.serialization.amqp.CommonPropertyNames;
import net.corda.nodeapi.internal.serialization.amqp.CustomSerializer;
import net.corda.nodeapi.internal.serialization.amqp.PropertySerializer;
import net.corda.nodeapi.internal.serialization.amqp.SerializationHelperKt;
import net.corda.nodeapi.internal.serialization.amqp.SerializerFactory;
import net.corda.nodeapi.internal.serialization.amqp.custom.StackTraceElementSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u00162\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0014R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/ThrowableSerializer;", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer$Proxy;", "", "Lnet/corda/nodeapi/internal/serialization/amqp/custom/ThrowableSerializer$ThrowableProxy;", "factory", "Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;", "(Lnet/corda/nodeapi/internal/serialization/amqp/SerializerFactory;)V", "additionalSerializers", "", "Lnet/corda/nodeapi/internal/serialization/amqp/CustomSerializer;", "", "getAdditionalSerializers", "()Ljava/lang/Iterable;", "revealSubclassesInSchema", "", "getRevealSubclassesInSchema", "()Z", "fromProxy", "proxy", "shouldIncludeInternalInfo", "toProxy", "obj", "Companion", "ThrowableProxy", "node-api_main"})
public final class ThrowableSerializer
extends CustomSerializer.Proxy<Throwable, ThrowableProxy> {
    private final boolean revealSubclassesInSchema = true;
    @NotNull
    private final Iterable<CustomSerializer<? extends Object>> additionalSerializers;
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    public boolean getRevealSubclassesInSchema() {
        return this.revealSubclassesInSchema;
    }

    @Override
    @NotNull
    public Iterable<CustomSerializer<? extends Object>> getAdditionalSerializers() {
        return this.additionalSerializers;
    }

    @Override
    @NotNull
    protected ThrowableProxy toProxy(@NotNull Throwable obj) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Map extraProperties = new LinkedHashMap();
        if (obj instanceof CordaThrowable) {
            try {
                KFunction<Object> constructor = SerializationHelperKt.constructorForDeserialization(obj.getClass());
                Collection<PropertySerializer> props = SerializationHelperKt.propertiesForSerialization(constructor, obj.getClass(), this.getFactory());
                for (PropertySerializer prop : props) {
                    Map map = extraProperties;
                    String string2 = prop.getName();
                    Method method = prop.getReadMethod();
                    if (method == null) {
                        Intrinsics.throwNpe();
                    }
                    Object object = method.invoke((Object)obj, new Object[0]);
                    map.put(string2, object);
                }
            }
            catch (NotSerializableException e) {
                ThrowableSerializer.Companion.getLogger().warn("Unexpected exception", (Throwable)e);
            }
            string = ((CordaThrowable)obj).getOriginalMessage();
        } else {
            string = obj.getMessage();
        }
        String message = string;
        StackTraceElement[] stackTraceToInclude = this.shouldIncludeInternalInfo() ? obj.getStackTrace() : new StackTraceElement[]{};
        String string3 = obj.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"obj.javaClass.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceToInclude, (String)"stackTraceToInclude");
        Throwable throwable = obj.getCause();
        Throwable[] throwableArray = obj.getSuppressed();
        Intrinsics.checkExpressionValueIsNotNull((Object)throwableArray, (String)"obj.suppressed");
        return new ThrowableProxy(string3, message, stackTraceToInclude, throwable, throwableArray, extraProperties);
    }

    private final boolean shouldIncludeInternalInfo() {
        SerializationFactory serializationFactory = SerializationFactory.Companion.getCurrentFactory();
        Object currentContext = serializationFactory != null ? serializationFactory.getCurrentContext() : null;
        Object object = currentContext;
        Object includeInternalInfo = object != null && (object = object.getProperties()) != null ? object.get((Object)CommonPropertyNames.IncludeInternalInfo) : null;
        return Intrinsics.areEqual((Object)true, includeInternalInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Throwable fromProxy(@NotNull ThrowableProxy proxy) {
        CordaRuntimeException cordaRuntimeException;
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        try {
            Class<?> clazz = Class.forName(proxy.getExceptionClass(), false, this.getFactory().getClassloader());
            if (CordaThrowable.class.isAssignableFrom(clazz) && Throwable.class.isAssignableFrom(clazz)) {
                Object throwable;
                Collection<Pair> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Class<?> clazz2 = clazz;
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"clazz");
                KFunction<Object> kFunction = SerializationHelperKt.constructorForDeserialization(clazz2);
                if (kFunction == null) {
                    Intrinsics.throwNpe();
                }
                KFunction<Object> constructor = kFunction;
                Object object = constructor.getParameters();
                KFunction<Object> kFunction2 = constructor;
                void var6_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KParameter kParameter = (KParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    Map<String, Object> map = proxy.getAdditionalProperties();
                    String string = it.getName();
                    void var13_15 = it;
                    Map<String, Object> map2 = map;
                    if (map2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                    }
                    Object object2 = map2.get(string);
                    Pair pair = TuplesKt.to((Object)var13_15, (Object)object2);
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                Object object3 = throwable = kFunction2.callBy(MapsKt.toMap((Iterable)collection));
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.core.CordaThrowable");
                }
                object = (CordaThrowable)object3;
                Object $receiver = object;
                if (Intrinsics.areEqual((Object)$receiver.getClass().getName(), (Object)proxy.getExceptionClass()) ^ true) {
                    $receiver.setOriginalExceptionClassName(proxy.getExceptionClass());
                }
                $receiver.setMessage(proxy.getMessage());
                $receiver.setCause(proxy.getCause());
                $receiver.addSuppressed(proxy.getSuppressed());
                $receiver = object = (Throwable)throwable;
                ((Throwable)$receiver).setStackTrace(proxy.getStackTrace());
                return object;
            }
        }
        catch (Exception e) {
            ThrowableSerializer.Companion.getLogger().warn("Unexpected exception de-serializing throwable: " + proxy.getExceptionClass() + ". Converting to CordaRuntimeException.", (Throwable)e);
        }
        CordaRuntimeException $receiver = cordaRuntimeException = new CordaRuntimeException(proxy.getExceptionClass(), null, null);
        $receiver.setMessage(proxy.getMessage());
        $receiver.setCause(proxy.getCause());
        $receiver.setStackTrace(proxy.getStackTrace());
        $receiver.addSuppressed(proxy.getSuppressed());
        return (Throwable)cordaRuntimeException;
    }

    public ThrowableSerializer(@NotNull SerializerFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(Throwable.class, ThrowableProxy.class, factory, false, 8, null);
        this.revealSubclassesInSchema = true;
        this.additionalSerializers = CollectionsKt.listOf((Object)new StackTraceElementSerializer(factory));
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = LoggerFactory.getLogger(ThrowableSerializer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LoggerFactory.getLogger(T::class.java)");
        logger = logger2;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000f\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f\u00a2\u0006\u0002\u0010\rR\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/ThrowableSerializer$ThrowableProxy;", "", "exceptionClass", "", "message", "stackTrace", "", "Ljava/lang/StackTraceElement;", "cause", "", "suppressed", "additionalProperties", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/StackTraceElement;Ljava/lang/Throwable;[Ljava/lang/Throwable;Ljava/util/Map;)V", "getAdditionalProperties", "()Ljava/util/Map;", "getCause", "()Ljava/lang/Throwable;", "getExceptionClass", "()Ljava/lang/String;", "getMessage", "getStackTrace", "()[Ljava/lang/StackTraceElement;", "[Ljava/lang/StackTraceElement;", "getSuppressed", "()[Ljava/lang/Throwable;", "[Ljava/lang/Throwable;", "node-api_main"})
    public static final class ThrowableProxy {
        @NotNull
        private final String exceptionClass;
        @Nullable
        private final String message;
        @NotNull
        private final StackTraceElement[] stackTrace;
        @Nullable
        private final Throwable cause;
        @NotNull
        private final Throwable[] suppressed;
        @NotNull
        private final Map<String, Object> additionalProperties;

        @NotNull
        public final String getExceptionClass() {
            return this.exceptionClass;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        @Nullable
        public final Throwable getCause() {
            return this.cause;
        }

        @NotNull
        public final Throwable[] getSuppressed() {
            return this.suppressed;
        }

        @NotNull
        public final Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        public ThrowableProxy(@NotNull String exceptionClass, @Nullable String message, @NotNull StackTraceElement[] stackTrace, @Nullable Throwable cause, @NotNull Throwable[] suppressed, @NotNull Map<String, ? extends Object> additionalProperties) {
            Intrinsics.checkParameterIsNotNull((Object)exceptionClass, (String)"exceptionClass");
            Intrinsics.checkParameterIsNotNull((Object)stackTrace, (String)"stackTrace");
            Intrinsics.checkParameterIsNotNull((Object)suppressed, (String)"suppressed");
            Intrinsics.checkParameterIsNotNull(additionalProperties, (String)"additionalProperties");
            this.exceptionClass = exceptionClass;
            this.message = message;
            this.stackTrace = stackTrace;
            this.cause = cause;
            this.suppressed = suppressed;
            this.additionalProperties = additionalProperties;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/serialization/amqp/custom/ThrowableSerializer$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "node-api_main"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

