/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.serialization.carpenter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.nodeapi.internal.serialization.amqp.CompositeType;
import net.corda.nodeapi.internal.serialization.amqp.TypeNotation;
import net.corda.nodeapi.internal.serialization.carpenter.AMQPSchemaExtensions;
import net.corda.nodeapi.internal.serialization.carpenter.CarpenterMetaSchema;
import net.corda.nodeapi.internal.serialization.carpenter.ClassCarpenter;
import net.corda.nodeapi.internal.serialization.carpenter.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H&J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lnet/corda/nodeapi/internal/serialization/carpenter/MetaCarpenterBase;", "", "schemas", "Lnet/corda/nodeapi/internal/serialization/carpenter/CarpenterMetaSchema;", "cc", "Lnet/corda/nodeapi/internal/serialization/carpenter/ClassCarpenter;", "(Lnet/corda/nodeapi/internal/serialization/carpenter/CarpenterMetaSchema;Lnet/corda/nodeapi/internal/serialization/carpenter/ClassCarpenter;)V", "getCc", "()Lnet/corda/nodeapi/internal/serialization/carpenter/ClassCarpenter;", "classloader", "Ljava/lang/ClassLoader;", "getClassloader", "()Ljava/lang/ClassLoader;", "objects", "", "", "Ljava/lang/Class;", "getObjects", "()Ljava/util/Map;", "getSchemas", "()Lnet/corda/nodeapi/internal/serialization/carpenter/CarpenterMetaSchema;", "build", "", "step", "newObject", "Lnet/corda/nodeapi/internal/serialization/carpenter/Schema;", "node-api_main"})
public abstract class MetaCarpenterBase {
    @NotNull
    private final Map<String, Class<?>> objects;
    @NotNull
    private final CarpenterMetaSchema schemas;
    @NotNull
    private final ClassCarpenter cc;

    @NotNull
    public final Map<String, Class<?>> getObjects() {
        return this.objects;
    }

    public final void step(@NotNull Schema newObject) {
        Intrinsics.checkParameterIsNotNull((Object)newObject, (String)"newObject");
        Map<String, Class<?>> map = this.objects;
        String string = newObject.getName();
        Class<?> clazz = this.cc.build(newObject);
        map.put(string, clazz);
        List<String> list = this.schemas.getDependsOn().remove(newObject.getName());
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Object object;
                String dependent = (String)element$iv;
                Pair<TypeNotation, List<String>> pair = this.schemas.getDependencies().get(dependent);
                if (pair == null) {
                    Intrinsics.throwNpe();
                }
                boolean bl = ((List)pair.getSecond()).contains(newObject.getName());
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                Object object2 = this.schemas.getDependencies().get(dependent);
                if (object2 != null && (object2 = (List)object2.getSecond()) != null) {
                    object2.remove(newObject.getName());
                }
                if ((object = this.schemas.getDependencies().get(dependent)) == null || (object = (List)object.getSecond()) == null) continue;
                if (!object.isEmpty()) continue;
                Pair<TypeNotation, List<String>> pair2 = this.schemas.getDependencies().remove(dependent);
                TypeNotation typeNotation2 = pair2 != null ? (TypeNotation)pair2.getFirst() : null;
                if (typeNotation2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.corda.nodeapi.internal.serialization.amqp.CompositeType");
                }
                AMQPSchemaExtensions.carpenterSchema$default((CompositeType)typeNotation2, this.cc.getClassloader(), this.schemas, false, 4, null);
            }
        }
    }

    public abstract void build();

    @NotNull
    public final ClassLoader getClassloader() {
        return this.cc.getClassloader();
    }

    @NotNull
    public final CarpenterMetaSchema getSchemas() {
        return this.schemas;
    }

    @NotNull
    public final ClassCarpenter getCc() {
        return this.cc;
    }

    public MetaCarpenterBase(@NotNull CarpenterMetaSchema schemas, @NotNull ClassCarpenter cc) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)schemas, (String)"schemas");
        Intrinsics.checkParameterIsNotNull((Object)cc, (String)"cc");
        this.schemas = schemas;
        this.cc = cc;
        MetaCarpenterBase metaCarpenterBase = this;
        metaCarpenterBase.objects = map = (Map)new LinkedHashMap();
    }

    public /* synthetic */ MetaCarpenterBase(CarpenterMetaSchema carpenterMetaSchema, ClassCarpenter classCarpenter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            classCarpenter = new ClassCarpenter(null, 1, null);
        }
        this(carpenterMetaSchema, classCarpenter);
    }
}

