/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.security.PublicKey;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.identity.Party;
import net.corda.core.messaging.MessageRecipientGroup;
import net.corda.core.messaging.MessageRecipients;
import net.corda.core.messaging.SingleMessageRecipient;
import net.corda.core.serialization.CordaSerializable;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00052\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\t"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent;", "", "()V", "ArtemisAddress", "ArtemisPeerAddress", "Companion", "NodeAddress", "RemoteInboxAddress", "ServiceAddress", "node-api"})
public final class ArtemisMessagingComponent {
    @NotNull
    public static final String NODE_P2P_USER = "SystemUsers/Node";
    @NotNull
    public static final String NODE_RPC_USER = "SystemUsers/NodeRPC";
    @NotNull
    public static final String PEER_USER = "SystemUsers/Peer";
    @NotNull
    public static final String INTERNAL_SHELL_USER = "internalShell";
    @NotNull
    public static final String INTERNAL_PREFIX = "internal.";
    @NotNull
    public static final String PEERS_PREFIX = "internal.peers.";
    @NotNull
    public static final String P2P_PREFIX = "p2p.inbound.";
    @NotNull
    public static final String BRIDGE_CONTROL = "internal.bridge.control";
    @NotNull
    public static final String BRIDGE_NOTIFY = "internal.bridge.notify";
    @NotNull
    public static final String NOTIFICATIONS_ADDRESS = "internal.activemq.notifications";
    public static final int JOURNAL_HEADER_SIZE = 1024;
    public static final Companion Companion = new Companion(null);

    static {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/MessageRecipients;", "queueName", "", "getQueueName", "()Ljava/lang/String;", "node-api"})
    public static interface ArtemisAddress
    extends MessageRecipients {
        @NotNull
        public String getQueueName();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ArtemisPeerAddress;", "Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/SingleMessageRecipient;", "node-api"})
    public static interface ArtemisPeerAddress
    extends ArtemisAddress,
    SingleMessageRecipient {
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$NodeAddress;", "Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ArtemisPeerAddress;", "peerIdentity", "Ljava/security/PublicKey;", "(Ljava/security/PublicKey;)V", "queueName", "", "(Ljava/lang/String;)V", "getQueueName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "node-api"})
    public static final class NodeAddress
    implements ArtemisPeerAddress {
        @NotNull
        private final String queueName;

        @Override
        @NotNull
        public String getQueueName() {
            return this.queueName;
        }

        public NodeAddress(@NotNull String queueName) {
            Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
            this.queueName = queueName;
        }

        public NodeAddress(@NotNull PublicKey peerIdentity) {
            Intrinsics.checkParameterIsNotNull((Object)peerIdentity, (String)"peerIdentity");
            this(ArtemisMessagingComponent.PEERS_PREFIX + CryptoUtils.toStringShort((PublicKey)peerIdentity));
        }

        @NotNull
        public final String component1() {
            return this.getQueueName();
        }

        @NotNull
        public final NodeAddress copy(@NotNull String queueName) {
            Intrinsics.checkParameterIsNotNull((Object)queueName, (String)"queueName");
            return new NodeAddress(queueName);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ NodeAddress copy$default(NodeAddress nodeAddress, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = nodeAddress.getQueueName();
            }
            return nodeAddress.copy(string);
        }

        @NotNull
        public String toString() {
            return "NodeAddress(queueName=" + this.getQueueName() + ")";
        }

        public int hashCode() {
            String string = this.getQueueName();
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NodeAddress)) break block3;
                    NodeAddress nodeAddress = (NodeAddress)object;
                    if (!Intrinsics.areEqual((Object)this.getQueueName(), (Object)nodeAddress.getQueueName())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ServiceAddress;", "Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/MessageRecipientGroup;", "identity", "Ljava/security/PublicKey;", "(Ljava/security/PublicKey;)V", "getIdentity", "()Ljava/security/PublicKey;", "queueName", "", "getQueueName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "node-api"})
    public static final class ServiceAddress
    implements ArtemisAddress,
    MessageRecipientGroup {
        @NotNull
        private final String queueName;
        @NotNull
        private final PublicKey identity;

        @Override
        @NotNull
        public String getQueueName() {
            return this.queueName;
        }

        @NotNull
        public final PublicKey getIdentity() {
            return this.identity;
        }

        public ServiceAddress(@NotNull PublicKey identity) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            this.identity = identity;
            this.queueName = ArtemisMessagingComponent.PEERS_PREFIX + CryptoUtils.toStringShort((PublicKey)this.identity);
        }

        @NotNull
        public final PublicKey component1() {
            return this.identity;
        }

        @NotNull
        public final ServiceAddress copy(@NotNull PublicKey identity) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            return new ServiceAddress(identity);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ServiceAddress copy$default(ServiceAddress serviceAddress, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                publicKey = serviceAddress.identity;
            }
            return serviceAddress.copy(publicKey);
        }

        @NotNull
        public String toString() {
            return "ServiceAddress(identity=" + this.identity + ")";
        }

        public int hashCode() {
            PublicKey publicKey = this.identity;
            return publicKey != null ? publicKey.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ServiceAddress)) break block3;
                    ServiceAddress serviceAddress = (ServiceAddress)object;
                    if (!Intrinsics.areEqual((Object)this.identity, (Object)serviceAddress.identity)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$RemoteInboxAddress;", "Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$ArtemisAddress;", "Lnet/corda/core/messaging/SingleMessageRecipient;", "party", "Lnet/corda/core/identity/Party;", "(Lnet/corda/core/identity/Party;)V", "identity", "Ljava/security/PublicKey;", "(Ljava/security/PublicKey;)V", "getIdentity", "()Ljava/security/PublicKey;", "queueName", "", "getQueueName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "node-api"})
    public static final class RemoteInboxAddress
    implements ArtemisAddress,
    SingleMessageRecipient {
        @NotNull
        private final String queueName;
        @NotNull
        private final PublicKey identity;
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String getQueueName() {
            return this.queueName;
        }

        @NotNull
        public final PublicKey getIdentity() {
            return this.identity;
        }

        public RemoteInboxAddress(@NotNull PublicKey identity) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            this.identity = identity;
            this.queueName = ArtemisMessagingComponent.P2P_PREFIX + CryptoUtils.toStringShort((PublicKey)this.identity);
        }

        public RemoteInboxAddress(@NotNull Party party) {
            Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
            this(party.getOwningKey());
        }

        @NotNull
        public final PublicKey component1() {
            return this.identity;
        }

        @NotNull
        public final RemoteInboxAddress copy(@NotNull PublicKey identity) {
            Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
            return new RemoteInboxAddress(identity);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ RemoteInboxAddress copy$default(RemoteInboxAddress remoteInboxAddress, PublicKey publicKey, int n, Object object) {
            if ((n & 1) != 0) {
                publicKey = remoteInboxAddress.identity;
            }
            return remoteInboxAddress.copy(publicKey);
        }

        @NotNull
        public String toString() {
            return "RemoteInboxAddress(identity=" + this.identity + ")";
        }

        public int hashCode() {
            PublicKey publicKey = this.identity;
            return publicKey != null ? publicKey.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RemoteInboxAddress)) break block3;
                    RemoteInboxAddress remoteInboxAddress = (RemoteInboxAddress)object;
                    if (!Intrinsics.areEqual((Object)this.identity, (Object)remoteInboxAddress.identity)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$RemoteInboxAddress$Companion;", "", "()V", "translateLocalQueueToInboxAddress", "", "address", "node-api"})
        public static final class Companion {
            @NotNull
            public final String translateLocalQueueToInboxAddress(@NotNull String address) {
                Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
                boolean bl = StringsKt.startsWith$default((String)address, (String)ArtemisMessagingComponent.PEERS_PREFIX, (boolean)false, (int)2, null);
                if (!bl) {
                    String string = "Failed to map address: " + address + " to a remote topic as it is not in the internal.peers. namespace";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                String string = address;
                int n = ArtemisMessagingComponent.PEERS_PREFIX.length();
                StringBuilder stringBuilder = new StringBuilder().append(ArtemisMessagingComponent.P2P_PREFIX);
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                String string3 = string2;
                return stringBuilder.append(string3).toString();
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$Companion;", "", "()V", "BRIDGE_CONTROL", "", "BRIDGE_NOTIFY", "INTERNAL_PREFIX", "INTERNAL_SHELL_USER", "JOURNAL_HEADER_SIZE", "", "NODE_P2P_USER", "NODE_RPC_USER", "NOTIFICATIONS_ADDRESS", "P2P_PREFIX", "PEERS_PREFIX", "PEER_USER", "P2PMessagingHeaders", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$Companion$P2PMessagingHeaders;", "", "()V", "bridgedCertificateSubject", "Lorg/apache/activemq/artemis/api/core/SimpleString;", "getBridgedCertificateSubject", "()Lorg/apache/activemq/artemis/api/core/SimpleString;", "cordaVendorProperty", "getCordaVendorProperty", "platformVersionProperty", "getPlatformVersionProperty", "releaseVersionProperty", "getReleaseVersionProperty", "senderSeqNo", "getSenderSeqNo", "senderUUID", "getSenderUUID", "topicProperty", "getTopicProperty", "whitelistedHeaders", "", "", "getWhitelistedHeaders", "()Ljava/util/Set;", "Type", "node-api"})
        public static final class P2PMessagingHeaders {
            @NotNull
            private static final SimpleString topicProperty;
            @NotNull
            private static final SimpleString cordaVendorProperty;
            @NotNull
            private static final SimpleString releaseVersionProperty;
            @NotNull
            private static final SimpleString platformVersionProperty;
            @NotNull
            private static final SimpleString senderUUID;
            @NotNull
            private static final SimpleString senderSeqNo;
            @NotNull
            private static final SimpleString bridgedCertificateSubject;
            @NotNull
            private static final Set<String> whitelistedHeaders;
            public static final P2PMessagingHeaders INSTANCE;

            @NotNull
            public final SimpleString getTopicProperty() {
                return topicProperty;
            }

            @NotNull
            public final SimpleString getCordaVendorProperty() {
                return cordaVendorProperty;
            }

            @NotNull
            public final SimpleString getReleaseVersionProperty() {
                return releaseVersionProperty;
            }

            @NotNull
            public final SimpleString getPlatformVersionProperty() {
                return platformVersionProperty;
            }

            @NotNull
            public final SimpleString getSenderUUID() {
                return senderUUID;
            }

            @NotNull
            public final SimpleString getSenderSeqNo() {
                return senderSeqNo;
            }

            @NotNull
            public final SimpleString getBridgedCertificateSubject() {
                return bridgedCertificateSubject;
            }

            @NotNull
            public final Set<String> getWhitelistedHeaders() {
                return whitelistedHeaders;
            }

            private P2PMessagingHeaders() {
            }

            static {
                P2PMessagingHeaders p2PMessagingHeaders;
                INSTANCE = p2PMessagingHeaders = new P2PMessagingHeaders();
                topicProperty = new SimpleString("platform-topic");
                cordaVendorProperty = new SimpleString("corda-vendor");
                releaseVersionProperty = new SimpleString("release-version");
                platformVersionProperty = new SimpleString("platform-version");
                senderUUID = new SimpleString("sender-uuid");
                senderSeqNo = new SimpleString("send-seq-no");
                bridgedCertificateSubject = new SimpleString("sender-subject-name");
                whitelistedHeaders = SetsKt.setOf((Object[])new String[]{topicProperty.toString(), cordaVendorProperty.toString(), releaseVersionProperty.toString(), platformVersionProperty.toString(), senderUUID.toString(), senderSeqNo.toString(), bridgedCertificateSubject.toString(), "corda_p2p_message_type", Message.HDR_DUPLICATE_DETECTION_ID.toString(), Message.HDR_VALIDATED_USER.toString()});
            }

            @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/corda/nodeapi/internal/ArtemisMessagingComponent$Companion$P2PMessagingHeaders$Type;", "", "()V", "KEY", "", "SESSION_INIT_VALUE", "node-api"})
            public static final class Type {
                @NotNull
                public static final String KEY = "corda_p2p_message_type";
                @NotNull
                public static final String SESSION_INIT_VALUE = "session_init";
                public static final Type INSTANCE;

                private Type() {
                }

                static {
                    Type type;
                    INSTANCE = type = new Type();
                }
            }
        }
    }
}

