/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.messaging.ClientRpcSslOptions;
import net.corda.core.serialization.internal.SerializationEnvironmentKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.BrokerRpcSslOptions;
import net.corda.nodeapi.internal.ArtemisUtils;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.config.CertificateStoreSupplier;
import net.corda.nodeapi.internal.config.FileBasedCertificateStoreSupplier;
import net.corda.nodeapi.internal.config.MutualSslConfiguration;
import net.corda.nodeapi.internal.config.SslConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lnet/corda/nodeapi/internal/ArtemisTcpTransport;", "", "()V", "Companion", "node-api"})
public final class ArtemisTcpTransport {
    @NotNull
    private static final List<String> CIPHER_SUITES;
    @NotNull
    private static final List<String> TLS_VERSIONS;
    @NotNull
    private static final Map<String, String> defaultSSLOptions;
    @NotNull
    private static final String acceptorFactoryClassName = "org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory";
    private static final String connectorFactoryClassName;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        CIPHER_SUITES = CollectionsKt.listOf((Object[])new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"});
        TLS_VERSIONS = CollectionsKt.listOf((Object)"TLSv1.2");
        defaultSSLOptions = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"enabledCipherSuites", (Object)CollectionsKt.joinToString$default((Iterable)CIPHER_SUITES, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)), TuplesKt.to((Object)"enabledProtocols", (Object)CollectionsKt.joinToString$default((Iterable)TLS_VERSIONS, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))});
        acceptorFactoryClassName = acceptorFactoryClassName;
        connectorFactoryClassName = NettyConnectorFactory.class.getName();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ,\u0010!\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\"\u0010!\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\"\u0010\"\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\"\u0010$\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ.\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010(\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020)J0\u0010+\u001a\u00020,*\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010/H\u0002J$\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u0011*\u0002022\u0006\u00103\u001a\u000204H\u0002J\u001c\u00105\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u0011*\u00020%H\u0002J\u001c\u00105\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u0011*\u00020#H\u0002J\u0018\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0011*\u00020)H\u0002J$\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u0003010\u0011*\u0002022\u0006\u00103\u001a\u000204H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00067"}, d2={"Lnet/corda/nodeapi/internal/ArtemisTcpTransport$Companion;", "", "()V", "CIPHER_SUITES", "", "", "getCIPHER_SUITES", "()Ljava/util/List;", "TLS_VERSIONS", "getTLS_VERSIONS", "acceptorFactoryClassName", "getAcceptorFactoryClassName$node_api", "()Ljava/lang/String;", "connectorFactoryClassName", "kotlin.jvm.PlatformType", "getConnectorFactoryClassName$node_api", "defaultSSLOptions", "", "getDefaultSSLOptions$node_api", "()Ljava/util/Map;", "defaultArtemisOptions", "hostAndPort", "Lnet/corda/core/utilities/NetworkHostAndPort;", "defaultArtemisOptions$node_api", "p2pAcceptorTcpTransport", "Lorg/apache/activemq/artemis/api/core/TransportConfiguration;", "keyStore", "Lnet/corda/nodeapi/internal/config/FileBasedCertificateStoreSupplier;", "trustStore", "enableSSL", "", "config", "Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;", "p2pConnectorTcpTransport", "rpcAcceptorTcpTransport", "Lnet/corda/nodeapi/BrokerRpcSslOptions;", "rpcConnectorTcpTransport", "Lnet/corda/core/messaging/ClientRpcSslOptions;", "rpcConnectorTcpTransportsFromList", "hostAndPortList", "rpcInternalAcceptorTcpTransport", "Lnet/corda/nodeapi/internal/config/SslConfiguration;", "rpcInternalClientTcpTransport", "addToTransportOptions", "", "Lkotlin/Pair;", "options", "", "toKeyStoreTransportOptions", "", "Lnet/corda/nodeapi/internal/config/CertificateStore;", "path", "Ljava/nio/file/Path;", "toTransportOptions", "toTrustStoreTransportOptions", "node-api"})
    public static final class Companion {
        @NotNull
        public final List<String> getCIPHER_SUITES() {
            return CIPHER_SUITES;
        }

        @NotNull
        public final List<String> getTLS_VERSIONS() {
            return TLS_VERSIONS;
        }

        @NotNull
        public final Map<String, Object> defaultArtemisOptions$node_api(@NotNull NetworkHostAndPort hostAndPort) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"host", (Object)hostAndPort.getHost()), TuplesKt.to((Object)"port", (Object)hostAndPort.getPort()), TuplesKt.to((Object)"protocols", (Object)"CORE,AMQP"), TuplesKt.to((Object)"useGlobalWorkerPool", (Object)(SerializationEnvironmentKt.getNodeSerializationEnv() != null ? 1 : 0)), TuplesKt.to((Object)"remotingThreads", (Object)(SerializationEnvironmentKt.getNodeSerializationEnv() != null ? -1 : 1)), TuplesKt.to((Object)"directDeliver", (Object)false)});
        }

        @NotNull
        public final Map<String, String> getDefaultSSLOptions$node_api() {
            return defaultSSLOptions;
        }

        private final Map<String, Object> toTransportOptions(@NotNull SslConfiguration $receiver) {
            Map options = new LinkedHashMap();
            this.addToTransportOptions((Pair<FileBasedCertificateStoreSupplier, FileBasedCertificateStoreSupplier>)TuplesKt.to((Object)$receiver.getKeyStore(), (Object)$receiver.getTrustStore()), options);
            return options;
        }

        private final void addToTransportOptions(@NotNull Pair<FileBasedCertificateStoreSupplier, FileBasedCertificateStoreSupplier> $receiver, Map<String, Object> options) {
            block1: {
                FileBasedCertificateStoreSupplier $receiver2;
                FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier;
                FileBasedCertificateStoreSupplier it;
                FileBasedCertificateStoreSupplier keyStore = (FileBasedCertificateStoreSupplier)$receiver.getFirst();
                FileBasedCertificateStoreSupplier trustStore = (FileBasedCertificateStoreSupplier)$receiver.getSecond();
                FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier2 = keyStore;
                if (fileBasedCertificateStoreSupplier2 != null) {
                    $receiver2 = it = (fileBasedCertificateStoreSupplier = fileBasedCertificateStoreSupplier2);
                    ArtemisUtils.requireOnDefaultFileSystem($receiver2.getPath());
                    options.putAll(Companion.toKeyStoreTransportOptions(CertificateStoreSupplier.DefaultImpls.get$default($receiver2, false, 1, null), $receiver2.getPath()));
                }
                FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier3 = trustStore;
                if (fileBasedCertificateStoreSupplier3 == null) break block1;
                $receiver2 = it = (fileBasedCertificateStoreSupplier = fileBasedCertificateStoreSupplier3);
                ArtemisUtils.requireOnDefaultFileSystem($receiver2.getPath());
                options.putAll(Companion.toTrustStoreTransportOptions(CertificateStoreSupplier.DefaultImpls.get$default($receiver2, false, 1, null), $receiver2.getPath()));
            }
        }

        private final Map<String, Comparable<?>> toKeyStoreTransportOptions(@NotNull CertificateStore $receiver, Path path) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sslEnabled", (Object)true), TuplesKt.to((Object)"keyStoreProvider", (Object)"JKS"), TuplesKt.to((Object)"keyStorePath", (Object)path), TuplesKt.to((Object)"keyStorePassword", (Object)$receiver.getPassword()), TuplesKt.to((Object)"needClientAuth", (Object)true)});
        }

        private final Map<String, Comparable<?>> toTrustStoreTransportOptions(@NotNull CertificateStore $receiver, Path path) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sslEnabled", (Object)true), TuplesKt.to((Object)"trustStoreProvider", (Object)"JKS"), TuplesKt.to((Object)"trustStorePath", (Object)path), TuplesKt.to((Object)"trustStorePassword", (Object)$receiver.getPassword()), TuplesKt.to((Object)"needClientAuth", (Object)true)});
        }

        private final Map<String, Comparable<?>> toTransportOptions(@NotNull ClientRpcSslOptions $receiver) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sslEnabled", (Object)true), TuplesKt.to((Object)"trustStoreProvider", (Object)$receiver.getTrustStoreProvider()), TuplesKt.to((Object)"trustStorePath", (Object)$receiver.getTrustStorePath()), TuplesKt.to((Object)"trustStorePassword", (Object)$receiver.getTrustStorePassword())});
        }

        private final Map<String, Comparable<?>> toTransportOptions(@NotNull BrokerRpcSslOptions $receiver) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sslEnabled", (Object)true), TuplesKt.to((Object)"keyStoreProvider", (Object)"JKS"), TuplesKt.to((Object)"keyStorePath", (Object)$receiver.getKeyStorePath()), TuplesKt.to((Object)"keyStorePassword", (Object)$receiver.getKeyStorePassword()), TuplesKt.to((Object)"needClientAuth", (Object)false)});
        }

        @NotNull
        public final String getAcceptorFactoryClassName$node_api() {
            return acceptorFactoryClassName;
        }

        public final String getConnectorFactoryClassName$node_api() {
            return connectorFactoryClassName;
        }

        @NotNull
        public final TransportConfiguration p2pAcceptorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @Nullable MutualSslConfiguration config, boolean enableSSL) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            MutualSslConfiguration mutualSslConfiguration = config;
            MutualSslConfiguration mutualSslConfiguration2 = config;
            return this.p2pAcceptorTcpTransport(hostAndPort, mutualSslConfiguration != null ? mutualSslConfiguration.getKeyStore() : null, mutualSslConfiguration2 != null ? mutualSslConfiguration2.getTrustStore() : null, enableSSL);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration p2pAcceptorTcpTransport$default(Companion companion, NetworkHostAndPort networkHostAndPort, MutualSslConfiguration mutualSslConfiguration, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.p2pAcceptorTcpTransport(networkHostAndPort, mutualSslConfiguration, bl);
        }

        @NotNull
        public final TransportConfiguration p2pConnectorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @Nullable MutualSslConfiguration config, boolean enableSSL) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            MutualSslConfiguration mutualSslConfiguration = config;
            MutualSslConfiguration mutualSslConfiguration2 = config;
            return this.p2pConnectorTcpTransport(hostAndPort, mutualSslConfiguration != null ? mutualSslConfiguration.getKeyStore() : null, mutualSslConfiguration2 != null ? mutualSslConfiguration2.getTrustStore() : null, enableSSL);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration p2pConnectorTcpTransport$default(Companion companion, NetworkHostAndPort networkHostAndPort, MutualSslConfiguration mutualSslConfiguration, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.p2pConnectorTcpTransport(networkHostAndPort, mutualSslConfiguration, bl);
        }

        @NotNull
        public final TransportConfiguration p2pAcceptorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @Nullable FileBasedCertificateStoreSupplier keyStore, @Nullable FileBasedCertificateStoreSupplier trustStore, boolean enableSSL) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Map options = MapsKt.toMutableMap(this.defaultArtemisOptions$node_api(hostAndPort));
            if (enableSSL) {
                options.putAll(this.getDefaultSSLOptions$node_api());
                this.addToTransportOptions((Pair<FileBasedCertificateStoreSupplier, FileBasedCertificateStoreSupplier>)TuplesKt.to((Object)keyStore, (Object)trustStore), options);
            }
            Map map = options;
            String string = "handshake-timeout";
            Integer n = 0;
            map.put(string, n);
            return new TransportConfiguration(this.getAcceptorFactoryClassName$node_api(), options);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration p2pAcceptorTcpTransport$default(Companion companion, NetworkHostAndPort networkHostAndPort, FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier, FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.p2pAcceptorTcpTransport(networkHostAndPort, fileBasedCertificateStoreSupplier, fileBasedCertificateStoreSupplier2, bl);
        }

        @NotNull
        public final TransportConfiguration p2pConnectorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @Nullable FileBasedCertificateStoreSupplier keyStore, @Nullable FileBasedCertificateStoreSupplier trustStore, boolean enableSSL) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Map options = MapsKt.toMutableMap(this.defaultArtemisOptions$node_api(hostAndPort));
            if (enableSSL) {
                options.putAll(this.getDefaultSSLOptions$node_api());
                this.addToTransportOptions((Pair<FileBasedCertificateStoreSupplier, FileBasedCertificateStoreSupplier>)TuplesKt.to((Object)keyStore, (Object)trustStore), options);
            }
            return new TransportConfiguration(this.getConnectorFactoryClassName$node_api(), options);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration p2pConnectorTcpTransport$default(Companion companion, NetworkHostAndPort networkHostAndPort, FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier, FileBasedCertificateStoreSupplier fileBasedCertificateStoreSupplier2, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.p2pConnectorTcpTransport(networkHostAndPort, fileBasedCertificateStoreSupplier, fileBasedCertificateStoreSupplier2, bl);
        }

        @NotNull
        public final TransportConfiguration rpcAcceptorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @Nullable BrokerRpcSslOptions config, boolean enableSSL) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Map options = MapsKt.toMutableMap(this.defaultArtemisOptions$node_api(hostAndPort));
            if (config != null && enableSSL) {
                ArtemisUtils.requireOnDefaultFileSystem(config.getKeyStorePath());
                options.putAll(this.toTransportOptions(config));
                options.putAll(this.getDefaultSSLOptions$node_api());
            }
            Map map = options;
            String string = "handshake-timeout";
            Integer n = 0;
            map.put(string, n);
            return new TransportConfiguration(this.getAcceptorFactoryClassName$node_api(), options);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration rpcAcceptorTcpTransport$default(Companion companion, NetworkHostAndPort networkHostAndPort, BrokerRpcSslOptions brokerRpcSslOptions, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.rpcAcceptorTcpTransport(networkHostAndPort, brokerRpcSslOptions, bl);
        }

        @NotNull
        public final TransportConfiguration rpcConnectorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @Nullable ClientRpcSslOptions config, boolean enableSSL) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Map options = MapsKt.toMutableMap(this.defaultArtemisOptions$node_api(hostAndPort));
            if (config != null && enableSSL) {
                ArtemisUtils.requireOnDefaultFileSystem(config.getTrustStorePath());
                options.putAll(this.toTransportOptions(config));
                options.putAll(this.getDefaultSSLOptions$node_api());
            }
            return new TransportConfiguration(this.getConnectorFactoryClassName$node_api(), options);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ TransportConfiguration rpcConnectorTcpTransport$default(Companion companion, NetworkHostAndPort networkHostAndPort, ClientRpcSslOptions clientRpcSslOptions, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.rpcConnectorTcpTransport(networkHostAndPort, clientRpcSslOptions, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<TransportConfiguration> rpcConnectorTcpTransportsFromList(@NotNull List<NetworkHostAndPort> hostAndPortList, @Nullable ClientRpcSslOptions config, boolean enableSSL) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(hostAndPortList, (String)"hostAndPortList");
            Iterable iterable = $receiver$iv = (Iterable)hostAndPortList;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                NetworkHostAndPort networkHostAndPort = (NetworkHostAndPort)item$iv$iv;
                Collection collection = destination$iv$iv;
                TransportConfiguration transportConfiguration = Companion.rpcConnectorTcpTransport((NetworkHostAndPort)it, config, enableSSL);
                collection.add(transportConfiguration);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ List rpcConnectorTcpTransportsFromList$default(Companion companion, List list2, ClientRpcSslOptions clientRpcSslOptions, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.rpcConnectorTcpTransportsFromList(list2, clientRpcSslOptions, bl);
        }

        @NotNull
        public final TransportConfiguration rpcInternalClientTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @NotNull SslConfiguration config) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            return new TransportConfiguration(this.getConnectorFactoryClassName$node_api(), MapsKt.plus((Map)MapsKt.plus(this.defaultArtemisOptions$node_api(hostAndPort), this.getDefaultSSLOptions$node_api()), this.toTransportOptions(config)));
        }

        @NotNull
        public final TransportConfiguration rpcInternalAcceptorTcpTransport(@NotNull NetworkHostAndPort hostAndPort, @NotNull SslConfiguration config) {
            Intrinsics.checkParameterIsNotNull((Object)hostAndPort, (String)"hostAndPort");
            Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
            return new TransportConfiguration(this.getAcceptorFactoryClassName$node_api(), MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.plus(this.defaultArtemisOptions$node_api(hostAndPort), this.getDefaultSSLOptions$node_api()), this.toTransportOptions(config)), (Pair)TuplesKt.to((Object)"handshake-timeout", (Object)0)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

