/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.internal.NamedCacheFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/corda/nodeapi/internal/DeduplicationChecker;", "", "cacheExpiry", "Ljava/time/Duration;", "name", "", "cacheFactory", "Lnet/corda/core/internal/NamedCacheFactory;", "(Ljava/time/Duration;Ljava/lang/String;Lnet/corda/core/internal/NamedCacheFactory;)V", "watermarkCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Ljava/util/concurrent/atomic/AtomicLong;", "checkDuplicateMessageId", "", "identity", "sequenceNumber", "", "WatermarkCacheLoader", "node-api"})
public final class DeduplicationChecker {
    private final LoadingCache<Object, AtomicLong> watermarkCache;

    public final boolean checkDuplicateMessageId(@NotNull Object identity, long sequenceNumber) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        Object object = this.watermarkCache.get(identity);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return ((AtomicLong)object).getAndUpdate(new LongUnaryOperator(sequenceNumber){
            final /* synthetic */ long $sequenceNumber;

            public final long applyAsLong(long it) {
                long l = this.$sequenceNumber;
                return Math.max(l, it);
            }
            {
                this.$sequenceNumber = l;
            }
        }) >= sequenceNumber;
    }

    public DeduplicationChecker(@NotNull Duration cacheExpiry, @NotNull String name, @NotNull NamedCacheFactory cacheFactory) {
        Intrinsics.checkParameterIsNotNull((Object)cacheExpiry, (String)"cacheExpiry");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)cacheFactory, (String)"cacheFactory");
        Caffeine caffeine = Caffeine.newBuilder().expireAfterAccess(cacheExpiry.toNanos(), TimeUnit.NANOSECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)caffeine, (String)"Caffeine.newBuilder()\n  \u2026(), TimeUnit.NANOSECONDS)");
        this.watermarkCache = cacheFactory.buildNamed(caffeine, name + "_watermark", (CacheLoader)WatermarkCacheLoader.INSTANCE);
    }

    public /* synthetic */ DeduplicationChecker(Duration duration, String string, NamedCacheFactory namedCacheFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "DeduplicationChecker";
        }
        this(duration, string, namedCacheFactory);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/corda/nodeapi/internal/DeduplicationChecker$WatermarkCacheLoader;", "Lcom/github/benmanes/caffeine/cache/CacheLoader;", "", "Ljava/util/concurrent/atomic/AtomicLong;", "()V", "load", "key", "node-api"})
    private static final class WatermarkCacheLoader
    implements CacheLoader<Object, AtomicLong> {
        public static final WatermarkCacheLoader INSTANCE;

        @NotNull
        public AtomicLong load(@NotNull Object key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return new AtomicLong(-1L);
        }

        private WatermarkCacheLoader() {
        }

        static {
            WatermarkCacheLoader watermarkCacheLoader;
            INSTANCE = watermarkCacheLoader = new WatermarkCacheLoader();
        }
    }
}

