/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.identity.CordaX500Name;
import net.corda.core.identity.Party;
import net.corda.core.identity.PartyAndCertificate;
import net.corda.core.internal.PathUtilsKt;
import net.corda.nodeapi.internal.KeyStoreConfigHelpersKt;
import net.corda.nodeapi.internal.config.CertificateStore;
import net.corda.nodeapi.internal.config.FileBasedCertificateStoreSupplier;
import net.corda.nodeapi.internal.config.MutualSslConfiguration;
import net.corda.nodeapi.internal.config.SslConfiguration;
import net.corda.nodeapi.internal.crypto.CertificateType;
import net.corda.nodeapi.internal.crypto.X509KeyStore;
import net.corda.nodeapi.internal.crypto.X509Utilities;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0012J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/corda/nodeapi/internal/DevIdentityGenerator;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createCertificate", "Ljava/security/cert/X509Certificate;", "publicKey", "Ljava/security/PublicKey;", "principal", "Ljavax/security/auth/x500/X500Principal;", "generateDistributedNotaryCompositeIdentity", "Lnet/corda/core/identity/Party;", "dirs", "", "Ljava/nio/file/Path;", "notaryName", "Lnet/corda/core/identity/CordaX500Name;", "threshold", "", "generateDistributedNotarySingularIdentity", "getKeyStore", "Lnet/corda/nodeapi/internal/crypto/X509KeyStore;", "nodeDir", "installKeyStoreWithNodeIdentity", "legalName", "setCompositeKey", "", "keyStore", "compositeKey", "notaryPrincipal", "setPrivateKey", "keyPair", "Ljava/security/KeyPair;", "node-api"})
public final class DevIdentityGenerator {
    private static final Logger log;
    public static final DevIdentityGenerator INSTANCE;

    @NotNull
    public final Party installKeyStoreWithNodeIdentity(@NotNull Path nodeDir, @NotNull CordaX500Name legalName) {
        CertificateStore certificateStore;
        Intrinsics.checkParameterIsNotNull((Object)nodeDir, (String)"nodeDir");
        Intrinsics.checkParameterIsNotNull((Object)legalName, (String)"legalName");
        Path certificatesDirectory = PathUtilsKt.div((Path)nodeDir, (String)"certificates");
        FileBasedCertificateStoreSupplier signingCertStore = new FileBasedCertificateStoreSupplier(PathUtilsKt.div((Path)certificatesDirectory, (String)"nodekeystore.jks"), "cordacadevpass", "cordacadevpass");
        FileBasedCertificateStoreSupplier p2pKeyStore = new FileBasedCertificateStoreSupplier(PathUtilsKt.div((Path)certificatesDirectory, (String)"sslkeystore.jks"), "cordacadevpass", "cordacadevpass");
        FileBasedCertificateStoreSupplier p2pTrustStore = new FileBasedCertificateStoreSupplier(PathUtilsKt.div((Path)certificatesDirectory, (String)"truststore.jks"), "trustpass", "trustpasskeypass");
        MutualSslConfiguration p2pSslConfig = SslConfiguration.Companion.mutual(p2pKeyStore, p2pTrustStore);
        PathUtilsKt.createDirectories((Path)certificatesDirectory, (FileAttribute[])new FileAttribute[0]);
        CertificateStore it = certificateStore = signingCertStore.get(true);
        KeyStoreConfigHelpersKt.registerDevSigningCertificates$default(it, legalName, null, null, null, 14, null);
        CertificateStore nodeKeyStore = certificateStore;
        it = certificateStore = p2pSslConfig.getKeyStore().get(true);
        KeyStoreConfigHelpersKt.registerDevP2pCertificates$default(it, legalName, null, null, null, 14, null);
        PartyAndCertificate identity = KeyStoreConfigHelpersKt.storeLegalIdentity$default(nodeKeyStore, "identity-private-key", null, 2, null);
        return identity.getParty();
    }

    @NotNull
    public final Party generateDistributedNotarySingularIdentity(@NotNull List<? extends Path> dirs, @NotNull CordaX500Name notaryName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(dirs, (String)"dirs");
        Intrinsics.checkParameterIsNotNull((Object)notaryName, (String)"notaryName");
        Collection collection = dirs;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            String string = "At least one directory to generate identity for must be specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Logger logger = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        Logger $receiver$iv = logger;
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger2 = $receiver$iv;
            String string = "Generating singular identity \"" + notaryName + "\" for nodes: " + CollectionsKt.joinToString$default((Iterable)dirs, null, null, null, (int)0, null, null, (int)63, null);
            logger2.trace(string);
        }
        KeyPair keyPair = CryptoUtils.generateKeyPair();
        PublicKey notaryKey = keyPair.getPublic();
        Iterable $receiver$iv2 = dirs;
        for (Object element$iv : $receiver$iv2) {
            Path nodeDir = (Path)element$iv;
            X509KeyStore keyStore = INSTANCE.getKeyStore(nodeDir);
            INSTANCE.setPrivateKey(keyStore, keyPair, notaryName.getX500Principal());
        }
        PublicKey publicKey = notaryKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"notaryKey");
        return new Party(notaryName, publicKey);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Party generateDistributedNotaryCompositeIdentity(@NotNull List<? extends Path> dirs, @NotNull CordaX500Name notaryName, int threshold) {
        int n;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Object object;
        Object object2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(dirs, (String)"dirs");
        Intrinsics.checkParameterIsNotNull((Object)notaryName, (String)"notaryName");
        Collection collection = dirs;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            String string = "At least one directory to generate identity for must be specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Logger logger = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        Logger $receiver$iv3 = logger;
        if ($receiver$iv3.isTraceEnabled()) {
            object2 = $receiver$iv3;
            object = "Generating composite identity \"" + notaryName + "\" for nodes: " + CollectionsKt.joinToString$default((Iterable)dirs, null, null, null, (int)0, null, null, (int)63, null);
            object2.trace((String)object);
        }
        int $i$a$2$trace = 1;
        Iterable $i$f$trace = $receiver$iv2 = (Iterable)new IntRange($i$a$2$trace, dirs.size());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator2 = $receiver$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object2 = destination$iv$iv;
            object = CryptoUtils.generateKeyPair();
            object2.add(object);
        }
        List keyPairs = (List)destination$iv$iv;
        $receiver$iv$iv2 = keyPairs;
        object2 = new CompositeKey.Builder();
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KeyPair $i$a$1$map = (KeyPair)item$iv$iv;
            object = destination$iv$iv2;
            PublicKey publicKey = it.getPublic();
            object.add(publicKey);
        }
        object = (List)destination$iv$iv2;
        PublicKey notaryKey = object2.addKeys((List)object).build(Integer.valueOf(threshold));
        $receiver$iv = keyPairs;
        Iterator first$iv = $receiver$iv.iterator();
        Iterator second$iv = ((Iterable)dirs).iterator();
        int n3 = CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10);
        int n4 = CollectionsKt.collectionSizeOrDefault((Iterable)dirs, (int)10);
        int n5 = n = Math.min(n3, n4);
        ArrayList list$iv = new ArrayList(n5);
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void keyPair;
            void nodeDir;
            Path $i$f$map = (Path)second$iv.next();
            KeyPair keyPair2 = (KeyPair)first$iv.next();
            object2 = list$iv;
            X509KeyStore keyStore = INSTANCE.getKeyStore((Path)nodeDir);
            INSTANCE.setPrivateKey(keyStore, (KeyPair)keyPair, notaryName.getX500Principal());
            INSTANCE.setCompositeKey(keyStore, notaryKey, notaryName.getX500Principal());
            object = Unit.INSTANCE;
            ((ArrayList)object2).add(object);
        }
        return new Party(notaryName, notaryKey);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Party generateDistributedNotaryCompositeIdentity$default(DevIdentityGenerator devIdentityGenerator, List list2, CordaX500Name cordaX500Name, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return devIdentityGenerator.generateDistributedNotaryCompositeIdentity(list2, cordaX500Name, n);
    }

    private final X509KeyStore getKeyStore(Path nodeDir) {
        Path distServKeyStoreFile = PathUtilsKt.div((Path)nodeDir, (String)"certificates/distributedService.jks");
        return X509KeyStore.Companion.fromFile(distServKeyStoreFile, "cordacadevpass", true);
    }

    private final void setPrivateKey(X509KeyStore keyStore, KeyPair keyPair, X500Principal notaryPrincipal) {
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"keyPair.public");
        X509Certificate serviceKeyCert = this.createCertificate(publicKey, notaryPrincipal);
        PrivateKey privateKey = keyPair.getPrivate();
        Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"keyPair.private");
        keyStore.setPrivateKey("distributed-notary-private-key", privateKey, CollectionsKt.listOf((Object[])new X509Certificate[]{serviceKeyCert, KeyStoreConfigHelpersKt.getDEV_INTERMEDIATE_CA().getCertificate(), KeyStoreConfigHelpersKt.getDEV_ROOT_CA().getCertificate()}), "cordacadevpass");
    }

    private final void setCompositeKey(X509KeyStore keyStore, PublicKey compositeKey, X500Principal notaryPrincipal) {
        X509Certificate compositeKeyCert = this.createCertificate(compositeKey, notaryPrincipal);
        keyStore.setCertificate("distributed-notary-composite-key", compositeKeyCert);
    }

    private final X509Certificate createCertificate(PublicKey publicKey, X500Principal principal) {
        return X509Utilities.createCertificate$default(CertificateType.SERVICE_IDENTITY, KeyStoreConfigHelpersKt.getDEV_INTERMEDIATE_CA().getCertificate(), KeyStoreConfigHelpersKt.getDEV_INTERMEDIATE_CA().getKeyPair(), principal, publicKey, null, null, null, null, 480, null);
    }

    private DevIdentityGenerator() {
    }

    static {
        DevIdentityGenerator devIdentityGenerator;
        INSTANCE = devIdentityGenerator = new DevIdentityGenerator();
        log = LoggerFactory.getLogger(devIdentityGenerator.getClass());
    }
}

