/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.corda.core.schemas.MappedSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/corda/nodeapi/internal/MigrationHelpers;", "", "()V", "CHANGELOG_NAME", "", "DEFAULT_MIGRATION_EXTENSION", "MIGRATION_PREFIX", "possibleMigrationExtensions", "", "getMigrationResource", "schema", "Lnet/corda/core/schemas/MappedSchema;", "classLoader", "Ljava/lang/ClassLoader;", "migrationResourceNameForSchema", "node-api"})
public final class MigrationHelpers {
    private static final String MIGRATION_PREFIX = "migration";
    private static final String DEFAULT_MIGRATION_EXTENSION = "xml";
    private static final String CHANGELOG_NAME = "changelog-master";
    private static final List<String> possibleMigrationExtensions;
    public static final MigrationHelpers INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getMigrationResource(@NotNull MappedSchema schema, @NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        String declaredMigration = schema.getMigrationResource();
        if (declaredMigration == null) {
            Object v0;
            block3: {
                void $receiver$iv$iv;
                String resource = this.migrationResourceNameForSchema(schema);
                Iterable $receiver$iv = possibleMigrationExtensions;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string2 = resource + (String)it;
                    collection.add(string2);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!(classLoader.getResource(it) != null)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            return v0;
        }
        return "migration/" + declaredMigration + ".xml";
    }

    private final String migrationResourceNameForSchema(MappedSchema schema) {
        String string = Reflection.getOrCreateKotlinClass(schema.getClass()).getSimpleName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String name = string;
        String fileName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, name);
        return "migration/" + fileName + ".changelog-master";
    }

    private MigrationHelpers() {
    }

    static {
        MigrationHelpers migrationHelpers;
        INSTANCE = migrationHelpers = new MigrationHelpers();
        possibleMigrationExtensions = CollectionsKt.listOf((Object[])new String[]{".xml", ".sql", ".yml", ".json"});
    }
}

