/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal;

import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.crypto.CompositeKey;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.DigitalSignature;
import net.corda.core.identity.Party;
import net.corda.core.node.NodeInfo;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.serialization.SerializedBytes;
import net.corda.core.utilities.ByteSequence;
import org.jetbrains.annotations.NotNull;

@CordaSerializable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lnet/corda/nodeapi/internal/SignedNodeInfo;", "", "raw", "Lnet/corda/core/serialization/SerializedBytes;", "Lnet/corda/core/node/NodeInfo;", "signatures", "", "Lnet/corda/core/crypto/DigitalSignature;", "(Lnet/corda/core/serialization/SerializedBytes;Ljava/util/List;)V", "getRaw", "()Lnet/corda/core/serialization/SerializedBytes;", "getSignatures", "()Ljava/util/List;", "verified", "node-api"})
public final class SignedNodeInfo {
    @NotNull
    private final SerializedBytes<NodeInfo> raw;
    @NotNull
    private final List<DigitalSignature> signatures;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NodeInfo verified() {
        void $receiver$iv$iv;
        SerializedBytes<NodeInfo> $receiver$iv = this.raw;
        SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
        Object context$iv = serializationFactory$iv.getDefaultContext();
        NodeInfo nodeInfo = (NodeInfo)serializationFactory$iv.deserialize((ByteSequence)$receiver$iv, NodeInfo.class, context$iv);
        Iterable $receiver$iv2 = nodeInfo.getLegalIdentities();
        context$iv = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Party it = (Party)element$iv$iv;
            if (it.getOwningKey() instanceof CompositeKey) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List identities = (List)destination$iv$iv;
        $receiver$iv2 = identities;
        boolean bl = $receiver$iv2 = !$receiver$iv2.isEmpty();
        if (!$receiver$iv2) {
            String string = "At least one identity with a non-composite key needs to be specified.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (identities.size() < this.signatures.size()) {
            throw (Throwable)new SignatureException("Extra signatures. Found " + this.signatures.size() + " expected " + identities.size());
        }
        if (identities.size() > this.signatures.size()) {
            throw (Throwable)new SignatureException("Missing signatures. Found " + this.signatures.size() + " expected " + identities.size());
        }
        byte[] rawBytes = this.raw.getBytes();
        Iterable $receiver$iv3 = CollectionsKt.zip((Iterable)identities, (Iterable)this.signatures);
        for (Object element$iv : $receiver$iv3) {
            Pair $identity_signature = (Pair)element$iv;
            Party identity = (Party)$identity_signature.component1();
            DigitalSignature signature = (DigitalSignature)$identity_signature.component2();
            try {
                CryptoUtils.verify((PublicKey)identity.getOwningKey(), (byte[])rawBytes, (DigitalSignature)signature);
            }
            catch (SignatureException e) {
                throw (Throwable)new SignatureException(identity + ": " + e.getMessage());
            }
        }
        return nodeInfo;
    }

    @NotNull
    public final SerializedBytes<NodeInfo> getRaw() {
        return this.raw;
    }

    @NotNull
    public final List<DigitalSignature> getSignatures() {
        return this.signatures;
    }

    public SignedNodeInfo(@NotNull SerializedBytes<NodeInfo> raw, @NotNull List<? extends DigitalSignature> signatures) {
        Intrinsics.checkParameterIsNotNull(raw, (String)"raw");
        Intrinsics.checkParameterIsNotNull(signatures, (String)"signatures");
        this.raw = raw;
        this.signatures = signatures;
    }
}

