/*
 * Decompiled with CFR 0.152.
 */
package net.corda.nodeapi.internal.bridging;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.corda.core.serialization.SerializationAPIKt;
import net.corda.core.serialization.SerializationContext;
import net.corda.core.serialization.SerializationDefaults;
import net.corda.core.serialization.SerializationFactory;
import net.corda.core.utilities.ByteArrays;
import net.corda.core.utilities.ByteSequence;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NetworkHostAndPort;
import net.corda.nodeapi.internal.ArtemisMessagingClient;
import net.corda.nodeapi.internal.ArtemisSessionProvider;
import net.corda.nodeapi.internal.bridging.AMQPBridgeManager;
import net.corda.nodeapi.internal.bridging.BridgeControl;
import net.corda.nodeapi.internal.bridging.BridgeEntry;
import net.corda.nodeapi.internal.bridging.BridgeManager;
import net.corda.nodeapi.internal.bridging.BridgeMetricsService;
import net.corda.nodeapi.internal.config.MutualSslConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u001bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0002J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0011R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnet/corda/nodeapi/internal/bridging/BridgeControlListener;", "Ljava/lang/AutoCloseable;", "config", "Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;", "p2pAddress", "Lnet/corda/core/utilities/NetworkHostAndPort;", "maxMessageSize", "", "(Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;Lnet/corda/core/utilities/NetworkHostAndPort;I)V", "artemisMessageClientFactory", "Lkotlin/Function0;", "Lnet/corda/nodeapi/internal/ArtemisSessionProvider;", "bridgeMetricsService", "Lnet/corda/nodeapi/internal/bridging/BridgeMetricsService;", "(Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;ILkotlin/jvm/functions/Function0;Lnet/corda/nodeapi/internal/bridging/BridgeMetricsService;)V", "artemis", "bridgeId", "", "bridgeManager", "Lnet/corda/nodeapi/internal/bridging/BridgeManager;", "getConfig", "()Lnet/corda/nodeapi/internal/config/MutualSslConfiguration;", "controlConsumer", "Lorg/apache/activemq/artemis/api/core/client/ClientConsumer;", "validInboundQueues", "", "close", "", "processControlMessage", "msg", "Lorg/apache/activemq/artemis/api/core/client/ClientMessage;", "start", "stop", "validateBridgingQueueName", "", "queueName", "validateInboxQueueName", "validateReceiveTopic", "topic", "Companion", "node-api"})
public final class BridgeControlListener
implements AutoCloseable {
    private final String bridgeId;
    private final BridgeManager bridgeManager;
    private final Set<String> validInboundQueues;
    private ArtemisSessionProvider artemis;
    private ClientConsumer controlConsumer;
    @NotNull
    private final MutualSslConfiguration config;
    private final Function0<ArtemisSessionProvider> artemisMessageClientFactory;
    private static final Logger log;
    public static final Companion Companion;

    public final void start() {
        ClientConsumer control;
        ArtemisSessionProvider artemis;
        this.stop();
        this.bridgeManager.start();
        this.artemis = artemis = (ArtemisSessionProvider)this.artemisMessageClientFactory.invoke();
        artemis.start();
        ArtemisMessagingClient.Started started = artemis.getStarted();
        if (started == null) {
            Intrinsics.throwNpe();
        }
        ArtemisMessagingClient.Started artemisClient = started;
        ClientSession artemisSession = artemisClient.getSession();
        String bridgeControlQueue = "internal.bridge.control." + this.bridgeId;
        artemisSession.createTemporaryQueue("internal.bridge.control", RoutingType.MULTICAST, bridgeControlQueue);
        this.controlConsumer = control = artemisSession.createConsumer(bridgeControlQueue);
        control.setMessageHandler(new MessageHandler(this){
            final /* synthetic */ BridgeControlListener this$0;

            public final void onMessage(ClientMessage msg) {
                try {
                    ClientMessage clientMessage = msg;
                    Intrinsics.checkExpressionValueIsNotNull((Object)clientMessage, (String)"msg");
                    BridgeControlListener.access$processControlMessage(this.this$0, clientMessage);
                }
                catch (Exception ex) {
                    BridgeControlListener.access$getLog$cp().error("Unable to process bridge control message", (Throwable)ex);
                }
                msg.acknowledge();
            }
            {
                this.this$0 = bridgeControlListener;
            }
        });
        byte[] startupMessage = SerializationAPIKt.serialize$default((Object)new BridgeControl.BridgeToNodeSnapshotRequest(this.bridgeId), null, (SerializationContext)SerializationDefaults.INSTANCE.getP2P_CONTEXT(), (int)1, null).getBytes();
        ClientMessage bridgeRequest = artemisSession.createMessage(false);
        bridgeRequest.writeBodyBufferBytes(startupMessage);
        artemisClient.getProducer().send("internal.bridge.notify", (Message)bridgeRequest);
    }

    public final void stop() {
        this.validInboundQueues.clear();
        ClientConsumer clientConsumer = this.controlConsumer;
        if (clientConsumer != null) {
            clientConsumer.close();
        }
        this.controlConsumer = null;
        ArtemisSessionProvider artemisSessionProvider = this.artemis;
        if (artemisSessionProvider != null) {
            artemisSessionProvider.stop();
        }
        this.artemis = null;
        this.bridgeManager.stop();
    }

    @Override
    public void close() {
        this.stop();
    }

    public final boolean validateReceiveTopic(@NotNull String topic) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        return this.validInboundQueues.contains(topic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateInboxQueueName(String queueName) {
        if (!StringsKt.startsWith$default((String)queueName, (String)"p2p.inbound.", (boolean)false, (int)2, null)) return false;
        ArtemisSessionProvider artemisSessionProvider = this.artemis;
        if (artemisSessionProvider == null) {
            Intrinsics.throwNpe();
        }
        ArtemisMessagingClient.Started started = artemisSessionProvider.getStarted();
        if (started == null) {
            Intrinsics.throwNpe();
        }
        ClientSession.QueueQuery queueQuery = started.getSession().queueQuery(new SimpleString(queueName));
        Intrinsics.checkExpressionValueIsNotNull((Object)queueQuery, (String)"artemis!!.started!!.sess\u2026(SimpleString(queueName))");
        if (!queueQuery.isExists()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateBridgingQueueName(String queueName) {
        if (!StringsKt.startsWith$default((String)queueName, (String)"internal.peers.", (boolean)false, (int)2, null)) return false;
        ArtemisSessionProvider artemisSessionProvider = this.artemis;
        if (artemisSessionProvider == null) {
            Intrinsics.throwNpe();
        }
        ArtemisMessagingClient.Started started = artemisSessionProvider.getStarted();
        if (started == null) {
            Intrinsics.throwNpe();
        }
        ClientSession.QueueQuery queueQuery = started.getSession().queueQuery(new SimpleString(queueName));
        Intrinsics.checkExpressionValueIsNotNull((Object)queueQuery, (String)"artemis!!.started!!.sess\u2026(SimpleString(queueName))");
        if (!queueQuery.isExists()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void processControlMessage(ClientMessage msg) {
        boolean bl;
        void $receiver$iv;
        void var8_7;
        byte[] data;
        byte[] byArray;
        byte[] $receiver = byArray = new byte[msg.getBodySize()];
        msg.getBodyBuffer().readBytes($receiver);
        $receiver = data = byArray;
        SerializationContext context$iv = SerializationDefaults.INSTANCE.getP2P_CONTEXT();
        SerializationFactory serializationFactory$iv = SerializationFactory.Companion.getDefaultFactory();
        void var9_10 = var8_7 = $receiver$iv;
        boolean bl2 = bl = !(((void)var9_10).length == 0);
        if (!bl) {
            String string = "Empty bytes";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteSequence $receiver$iv$iv = ByteArrays.sequence$default((byte[])$receiver$iv, (int)0, (int)0, (int)3, null);
        BridgeControl controlMessage = (BridgeControl)serializationFactory$iv.deserialize($receiver$iv$iv, BridgeControl.class, context$iv);
        log.info("Received bridge control message " + controlMessage);
        BridgeControl bridgeControl = controlMessage;
        if (bridgeControl instanceof BridgeControl.NodeToBridgeSnapshot) {
            boolean bl3;
            block20: {
                Object it;
                boolean bl4;
                Iterable $receiver$iv2;
                block19: {
                    $receiver$iv2 = ((BridgeControl.NodeToBridgeSnapshot)controlMessage).getInboxQueues();
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            it = (String)element$iv;
                            if (this.validateInboxQueueName((String)it)) continue;
                            bl4 = false;
                            break block19;
                        }
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    log.error("Invalid queue names in control message " + controlMessage);
                    return;
                }
                $receiver$iv2 = ((BridgeControl.NodeToBridgeSnapshot)controlMessage).getSendQueues();
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $receiver$iv2) {
                        it = (BridgeEntry)element$iv;
                        if (this.validateBridgingQueueName(((BridgeEntry)it).getQueueName())) continue;
                        bl3 = false;
                        break block20;
                    }
                    bl3 = true;
                }
            }
            if (!bl3) {
                log.error("Invalid queue names in control message " + controlMessage);
                return;
            }
            for (BridgeEntry outQueue : ((BridgeControl.NodeToBridgeSnapshot)controlMessage).getSendQueues()) {
                this.bridgeManager.deployBridge(outQueue.getQueueName(), outQueue.getTargets(), CollectionsKt.toSet((Iterable)outQueue.getLegalNames()));
            }
            this.validInboundQueues.addAll((Collection<String>)((BridgeControl.NodeToBridgeSnapshot)controlMessage).getInboxQueues());
        } else if (bridgeControl instanceof BridgeControl.BridgeToNodeSnapshotRequest) {
            log.error("Message from Bridge " + controlMessage + " detected on wrong topic!");
        } else if (bridgeControl instanceof BridgeControl.Create) {
            if (!this.validateBridgingQueueName(((BridgeControl.Create)controlMessage).getBridgeInfo().getQueueName())) {
                log.error("Invalid queue names in control message " + controlMessage);
                return;
            }
            this.bridgeManager.deployBridge(((BridgeControl.Create)controlMessage).getBridgeInfo().getQueueName(), ((BridgeControl.Create)controlMessage).getBridgeInfo().getTargets(), CollectionsKt.toSet((Iterable)((BridgeControl.Create)controlMessage).getBridgeInfo().getLegalNames()));
        } else if (bridgeControl instanceof BridgeControl.Delete) {
            if (!StringsKt.startsWith$default((String)((BridgeControl.Delete)controlMessage).getBridgeInfo().getQueueName(), (String)"internal.peers.", (boolean)false, (int)2, null)) {
                log.error("Invalid queue names in control message " + controlMessage);
                return;
            }
            this.bridgeManager.destroyBridge(((BridgeControl.Delete)controlMessage).getBridgeInfo().getQueueName(), ((BridgeControl.Delete)controlMessage).getBridgeInfo().getTargets());
        }
    }

    @NotNull
    public final MutualSslConfiguration getConfig() {
        return this.config;
    }

    public BridgeControlListener(@NotNull MutualSslConfiguration config, int maxMessageSize, @NotNull Function0<? extends ArtemisSessionProvider> artemisMessageClientFactory, @Nullable BridgeMetricsService bridgeMetricsService) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(artemisMessageClientFactory, (String)"artemisMessageClientFactory");
        this.config = config;
        this.artemisMessageClientFactory = artemisMessageClientFactory;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        this.bridgeId = string;
        this.bridgeManager = new AMQPBridgeManager(this.config, maxMessageSize, this.artemisMessageClientFactory, bridgeMetricsService);
        BridgeControlListener bridgeControlListener = this;
        bridgeControlListener.validInboundQueues = set2 = (Set)new LinkedHashSet();
    }

    public /* synthetic */ BridgeControlListener(MutualSslConfiguration mutualSslConfiguration, int n, Function0 function0, BridgeMetricsService bridgeMetricsService, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bridgeMetricsService = null;
        }
        this(mutualSslConfiguration, n, (Function0<? extends ArtemisSessionProvider>)function0, bridgeMetricsService);
    }

    public BridgeControlListener(final @NotNull MutualSslConfiguration config, final @NotNull NetworkHostAndPort p2pAddress, final int maxMessageSize) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)p2pAddress, (String)"p2pAddress");
        this(config, maxMessageSize, (Function0)new Function0<ArtemisMessagingClient>(){

            @NotNull
            public final ArtemisMessagingClient invoke() {
                return new ArtemisMessagingClient(config, p2pAddress, maxMessageSize);
            }
        }, null, 8, null);
    }

    static {
        Companion = new Companion(null);
        log = KotlinUtilsKt.contextLogger((Object)Companion);
    }

    public static final /* synthetic */ void access$processControlMessage(BridgeControlListener $this, @NotNull ClientMessage msg) {
        $this.processControlMessage(msg);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/corda/nodeapi/internal/bridging/BridgeControlListener$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "node-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

